/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.model;

/**
 * An RDF literal consisting of a label (the value) and optionally a
 * language tag or a datatype (but not both).
 **/
public interface Literal extends Value {

	/**
	 * Gets the label of this literal.
	 *
	 * @return The literal's label.
	 **/
	public String getLabel();

	/**
	 * Gets the language tag for this literal, normalized to lowercase.
	 *
	 * @return The language tag for this literal, or <tt>null</tt>
	 * if it doesn't have one.
	 **/
	public String getLanguage();

	/**
	 * Gets the datatype for this literal.
	 *
	 * @return The datatype for this literal, or <tt>null</tt>
	 * if it doesn't have one.
	 **/
	public URI getDatatype();
	
	/**
	 * Compares a literal object to another object.
	 * 
	 * @param other The object to compare this literal to.
	 * @return <tt>true</tt> if the other object is an instance of
	 * {@link Literal} and if their labels, language tags and datatypes are
	 * equal.
	 */
	public boolean equals(Object other);
	
	/**
	 * The hash code of a literal is defined as the hash code of its label:
	 * <tt>label.hashCode()</tt>.
	 * 
	 * @return A hash code for the literal.
	 */
	public int hashCode();
}
