/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.model;

import org.openrdf.sesame.sail.StatementIterator;

/**
 * A URI. A URI consists of a local name and a namespace. The local name is
 * defined as the part of the URI string after the last occurrence of the '#',
 * ':' or '/' character, the rest of the URI string is the namespace. URI
 * strings that do not contain any of these character are considered to be
 * malformed.
 **/
public interface URI extends Resource {

	/**
	 * Gets the namespace of this URI.
	 *
	 * @return The URI's namespace.
	 **/
	public String getNamespace();

	/**
	 * Gets the local name of this URI.
	 *
	 * @return The URI's local name.
	 **/
	public String getLocalName();

	/**
	 * Returns the String-representation of this URI. The String-representation
	 * consists of the concatenation of the namespace and the local name.
	 *
	 * @return The String-representation of this URI.
	 **/
	public String getURI();
	
	/**
	 * Gets all statements from the RDF graph for which this URI is the predicate.
	 **/
	public StatementIterator getPredicateStatements()
		throws GraphException;

	/**
	 * Compares a URI object to another object.
	 *
	 * @param o The object to compare this URI to.
	 * @return <tt>true</tt> if the other object is an instance of {@link URI}
	 * and their String-representations are equal, <tt>false</tt> otherwise.
	 */
	public boolean equals(Object o);
	
	/**
	 * The hash code of a URI is defined as follows:
	 * <pre>
	 * namespace.hashCode() ^ localName.hashCode()
	 * </pre>
	 * 
	 * @return A hash code for the URI.
	 */
	public int hashCode();
}
