/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.vocabulary;

/**
 * Constants for OWL primitives and for the OWL namespace.
 **/
public class OWL {

	/** http://www.w3.org/2002/07/owl# **/
	public static final String NAMESPACE = "http://www.w3.org/2002/07/owl#";

	// OWL Lite

	/** http://www.w3.org/2002/07/owl#Class **/
	public static final String CLASS = NAMESPACE + "Class";

	/** http://www.w3.org/2002/07/owl#Individual **/
	public static final String INDIVIDUAL = NAMESPACE + "Individual";

	/** http://www.w3.org/2002/07/owl#equivalentClass **/
	public static final String EQUIVALENTCLASS = NAMESPACE + "equivalentClass";

	/** http://www.w3.org/2002/07/owl#equivalentProperty **/
	public static final String EQUIVALENTPROPERTY = NAMESPACE + "equivalentProperty";

	/** http://www.w3.org/2002/07/owl#sameAs **/
	public static final String SAMEAS = NAMESPACE + "sameAs";

	/** http://www.w3.org/2002/07/owl#differentFrom **/
	public static final String DIFFERENTFROM = NAMESPACE + "differentFrom";

	/** http://www.w3.org/2002/07/owl#AllDifferent **/
	public static final String ALLDIFFERENT = NAMESPACE + "AllDifferent";

	/** http://www.w3.org/2002/07/owl#distinctMembers **/
	public static final String DISTINCTMEMBERS = NAMESPACE + "distinctMembers";

	/** http://www.w3.org/2002/07/owl#ObjectProperty **/
	public static final String OBJECTPROPERTY = NAMESPACE + "ObjectProperty";

	/** http://www.w3.org/2002/07/owl#DatatypeProperty **/
	public static final String DATATYPEPROPERTY = NAMESPACE + "DatatypeProperty";

	/** http://www.w3.org/2002/07/owl#inverseOf **/
	public static final String INVERSEOF = NAMESPACE + "inverseOf";

	/** http://www.w3.org/2002/07/owl#TransitiveProperty **/
	public static final String TRANSITIVEPROPERTY = NAMESPACE + "TransitiveProperty";

	/** http://www.w3.org/2002/07/owl#SymmetricProperty **/
	public static final String SYMMETRICPROPERTY = NAMESPACE + "SymmetricProperty";

	/** http://www.w3.org/2002/07/owl#FunctionalProperty **/
	public static final String FUNCTIONALPROPERTY = NAMESPACE + "FunctionalProperty";

	/** http://www.w3.org/2002/07/owl#InverseFunctionalProperty **/
	public static final String INVERSEFUNCTIONALPROPERTY = NAMESPACE + "InverseFunctionalProperty";

	/** http://www.w3.org/2002/07/owl#Restriction **/
	public static final String RESTRICTION = NAMESPACE + "Restriction";

	/** http://www.w3.org/2002/07/owl#onProperty **/
	public static final String ONPROPERTY = NAMESPACE + "onProperty";

	/** http://www.w3.org/2002/07/owl#allValuesFrom **/
	public static final String ALLVALUESFROM = NAMESPACE + "allValuesFrom";

	/** http://www.w3.org/2002/07/owl#someValuesFrom **/
	public static final String SOMEVALUESFROM = NAMESPACE + "someValuesFrom";

	/** http://www.w3.org/2002/07/owl#minCardinality **/
	public static final String MINCARDINALITY = NAMESPACE + "minCardinality";

	/** http://www.w3.org/2002/07/owl#maxCardinality **/
	public static final String MAXCARDINALITY = NAMESPACE + "maxCardinality";

	/** http://www.w3.org/2002/07/owl#cardinality **/
	public static final String CARDINALITY = NAMESPACE + "cardinality";

	/** http://www.w3.org/2002/07/owl#Ontology **/
	public static final String ONTOLOGY = NAMESPACE + "Ontology";

	/** http://www.w3.org/2002/07/owl#imports **/
	public static final String IMPORTS = NAMESPACE + "imports";

	/** http://www.w3.org/2002/07/owl#intersectionOf **/
	public static final String INTERSECTIONOF = NAMESPACE + "intersectionOf";

	/** http://www.w3.org/2002/07/owl#versionInfo **/
	public static final String VERSIONINFO = NAMESPACE + "versionInfo";

	/** http://www.w3.org/2002/07/owl#priorVersion **/
	public static final String PRIORVERSION = NAMESPACE + "priorVersion";

	/** http://www.w3.org/2002/07/owl#backwardCompatibleWith **/
	public static final String BACKWARDCOMPATIBLEWITH = NAMESPACE + "backwardCompatibleWith";

	/** http://www.w3.org/2002/07/owl#incompatibleWith **/
	public static final String INCOMPATIBLEWITH = NAMESPACE + "incompatibleWith";

	/** http://www.w3.org/2002/07/owl#DeprecatedClass **/
	public static final String DEPRECATEDCLASS = NAMESPACE + "DeprecatedClass";

	/** http://www.w3.org/2002/07/owl#DeprecatedProperty **/
	public static final String DEPRECATEDPROPERTY = NAMESPACE + "DeprecatedProperty";

	/** http://www.w3.org/2002/07/owl#AnnotationProperty **/
	public static final String ANNOTATIONPROPERTY = NAMESPACE + "AnnotationProperty";

	/** http://www.w3.org/2002/07/owl#OntologyProperty **/
	public static final String ONTOLOGYPROPERTY = NAMESPACE + "OntologyProperty";

	// OWL DL and OWL Full

	/** http://www.w3.org/2002/07/owl#oneOf **/
	public static final String ONEOF = NAMESPACE + "oneOf";

	/** http://www.w3.org/2002/07/owl#hasValue **/
	public static final String HASVALUE = NAMESPACE + "hasValue";

	/** http://www.w3.org/2002/07/owl#disjointWith **/
	public static final String DISJOINTWITH = NAMESPACE + "disjointWith";

	/** http://www.w3.org/2002/07/owl#unionOf **/
	public static final String UNIONOF = NAMESPACE + "unionOf";

	/** http://www.w3.org/2002/07/owl#complementOf **/
	public static final String COMPLEMENTOF = NAMESPACE + "complementOf";
}
