/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.vocabulary;

/**
 * Constants for RDF primitives and for the RDF namespace.
 **/
public class RDF {

	/** http://www.w3.org/1999/02/22-rdf-syntax-ns# **/
	public static final String NAMESPACE =
			"http://www.w3.org/1999/02/22-rdf-syntax-ns#";

	/** http://www.w3.org/1999/02/22-rdf-syntax-ns#type **/
	public static final String TYPE = NAMESPACE + "type";

	/** http://www.w3.org/1999/02/22-rdf-syntax-ns#Property **/
	public static final String PROPERTY = NAMESPACE + "Property";

	/** http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral **/
	public static final String XMLLITERAL = NAMESPACE + "XMLLiteral";

	/** http://www.w3.org/1999/02/22-rdf-syntax-ns#subject **/
	public static final String SUBJECT = NAMESPACE + "subject";

	/** http://www.w3.org/1999/02/22-rdf-syntax-ns#predicate **/
	public static final String PREDICATE = NAMESPACE + "predicate";

	/** http://www.w3.org/1999/02/22-rdf-syntax-ns#object **/
	public static final String OBJECT = NAMESPACE + "object";

	/** http://www.w3.org/1999/02/22-rdf-syntax-ns#Statement **/
	public static final String STATEMENT = NAMESPACE + "Statement";

	/** http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag **/
	public static final String BAG = NAMESPACE + "Bag";

	/** http://www.w3.org/1999/02/22-rdf-syntax-ns#Alt **/
	public static final String ALT = NAMESPACE + "Alt";

	/** http://www.w3.org/1999/02/22-rdf-syntax-ns#Seq **/
	public static final String SEQ = NAMESPACE + "Seq";

	/** http://www.w3.org/1999/02/22-rdf-syntax-ns#value **/
	public static final String VALUE = NAMESPACE + "value";

	/** http://www.w3.org/1999/02/22-rdf-syntax-ns#li **/
	public static final String LI = NAMESPACE + "li";

	/** http://www.w3.org/1999/02/22-rdf-syntax-ns#List **/
	public static final String LIST = NAMESPACE + "List";

	/** http://www.w3.org/1999/02/22-rdf-syntax-ns#first **/
	public static final String FIRST = NAMESPACE + "first";

	/** http://www.w3.org/1999/02/22-rdf-syntax-ns#rest **/
	public static final String REST = NAMESPACE + "rest";

	/** http://www.w3.org/1999/02/22-rdf-syntax-ns#nil **/
	public static final String NIL = NAMESPACE + "nil";
}
