/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.rio;

import java.io.IOException;

import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

/**
 * An interface defining methods for writing RDF documents.
 **/
public interface RdfDocumentWriter {

	/**
	 * Sets a mapping from a namespace prefix to a namespace name. Some
	 * implementations of this interface may require that namespace are
	 * set before the document writing starts (i.e. before startDocument()
	 * is called). Note that a mapping can only be defined once for a given
	 * namespace name. The RdfDocumentWriter will ignore an attempt to define
	 * a mapping for a namespace it already has a mapping for.
	 **/
	public void setNamespace(String prefix, String name)
		throws IOException;

	/**
	 * Starts the document writing.
	 **/
	public void startDocument()
		throws IOException;

	/**
	 * Ends the document writing.
	 **/
	public void endDocument()
		throws IOException;

	/**
	 * Writes a statement to the document. The startDocument() method should
	 * have been called before.
	 **/
	public void writeStatement(
		Resource subject, URI predicate, Value object)
		throws IOException;

	/**
	 * Writes a comment to the document. An implementation may ignore these
	 * calls if the format doesn't support comments.
	 **/
	public void writeComment(String comment)
		throws IOException;
}
