/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.rio.n3;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

import org.openrdf.rio.RdfDocumentWriter;
import org.openrdf.rio.turtle.TurtleWriter;

/**
 * An implementation of the RdfDocumentWriter interface that writes RDF
 * documents in N3 format. Note: the current implementation simply wraps a
 * {@link TurtleWriter} and writes documents in Turtle format, which is a subset
 * of N3.
 **/
public class N3Writer implements RdfDocumentWriter {

/*---------------------------------+
| Variables                        |
+---------------------------------*/

	private TurtleWriter _ttlWriter;
	
/*---------------------------------+
| Constructors                     |
+---------------------------------*/

	/**
	 * Creates a new N3Writer that will write to the supplied OutputStream.
	 * 
	 * @param out The OutputStream to write the N3 document to.
	 **/
	public N3Writer(OutputStream out) {
		_ttlWriter = new TurtleWriter(out);
	}

	/**
	 * Creates a new N3Writer that will write to the supplied Writer.
	 * 
	 * @param out The Writer to write the N3 document to.
	 **/
	public N3Writer(Writer out) {
		_ttlWriter = new TurtleWriter(out);
	}

/*---------------------------------+
| Methods from interface RdfWriter |
+---------------------------------*/

	public void setNamespace(String prefix, String name)
		throws IOException
	{
		_ttlWriter.setNamespace(prefix, name);
	}

	public void startDocument()
		throws IOException
	{
		_ttlWriter.startDocument();
	}

	public void endDocument()
		throws IOException
	{
		_ttlWriter.endDocument();
	}

	public void writeStatement(Resource subj, URI pred, Value obj)
		throws IOException
	{
		_ttlWriter.writeStatement(subj, pred, obj);
	}

	public void writeComment(String comment)
		throws IOException
	{
		_ttlWriter.writeComment(comment);
	}
}
