/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sail.query;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Value;
import org.openrdf.sesame.sail.query.BooleanExpr;
import org.openrdf.sesame.sail.query.DirectSubClassOf;
import org.openrdf.sesame.sail.query.DirectSubPropertyOf;
import org.openrdf.sesame.sail.query.DirectType;
import org.openrdf.sesame.sail.query.GraphPattern;
import org.openrdf.sesame.sail.query.GraphPatternQuery;
import org.openrdf.sesame.sail.query.PathExpression;
import org.openrdf.sesame.sail.query.Query;
import org.openrdf.sesame.sail.query.SetOperator;
import org.openrdf.sesame.sail.query.ValueCompare;
import org.openrdf.sesame.sail.query.ValueExpr;
import org.openrdf.sesame.sail.query.Var;

public class QueryOptimizer {
    public static void optimizeQuery(Query qc) {
        if (qc instanceof GraphPatternQuery) {
            GraphPatternQuery gpQuery = (GraphPatternQuery)qc;
            QueryOptimizer._optimizeGraphPattern(gpQuery.getGraphPattern(), new HashSet());
        } else if (qc instanceof SetOperator) {
            SetOperator setOp = (SetOperator)qc;
            QueryOptimizer.optimizeQuery(setOp.getLeftArg());
            QueryOptimizer.optimizeQuery(setOp.getRightArg());
        }
    }

    private static void _optimizeGraphPattern(GraphPattern graphPattern, Set boundVars) {
        Iterator iter = graphPattern.getOptionals().iterator();
        if (iter.hasNext()) {
            HashSet scopeVars = new HashSet(boundVars);
            graphPattern.getLocalVariables(scopeVars);
            while (iter.hasNext()) {
                GraphPattern optionalGP = (GraphPattern)iter.next();
                QueryOptimizer._optimizeGraphPattern(optionalGP, new HashSet(scopeVars));
            }
        }
        QueryOptimizer._inlineVarAssignments(graphPattern);
        QueryOptimizer._orderExpressions(graphPattern, boundVars);
    }

    private static void _inlineVarAssignments(GraphPattern graphPattern) {
        HashSet localVars = new HashSet();
        graphPattern.getLocalVariables(localVars);
        boolean constraintsModified = false;
        ArrayList conjunctiveConstraints = new ArrayList(graphPattern.getConjunctiveConstraints());
        Iterator iter = conjunctiveConstraints.iterator();
        while (iter.hasNext()) {
            ValueCompare valueCompare;
            BooleanExpr boolExpr = (BooleanExpr)iter.next();
            if (!(boolExpr instanceof ValueCompare) || (valueCompare = (ValueCompare)boolExpr).getOperator() != 1) continue;
            ValueExpr arg1 = valueCompare.getLeftArg();
            ValueExpr arg2 = valueCompare.getRightArg();
            Var varArg = null;
            Value value = null;
            if (arg1 instanceof Var && arg1.getValue() == null && arg2.getValue() != null) {
                varArg = (Var)arg1;
                value = arg2.getValue();
            } else if (arg2 instanceof Var && arg2.getValue() == null && arg1.getValue() != null) {
                varArg = (Var)arg2;
                value = arg1.getValue();
            }
            if (varArg == null || !localVars.contains(varArg)) continue;
            varArg.setValue(value);
            iter.remove();
            constraintsModified = true;
        }
        if (constraintsModified) {
            graphPattern.setConstraints(conjunctiveConstraints);
        }
    }

    private static void _orderExpressions(GraphPattern graphPattern, Set boundVars) {
        ArrayList<PathExpression> expressions = new ArrayList<PathExpression>();
        LinkedList conjunctiveConstraints = new LinkedList(graphPattern.getConjunctiveConstraints());
        QueryOptimizer._addVerifiableConstraints(conjunctiveConstraints, boundVars, expressions);
        LinkedList pathExpressions = new LinkedList(graphPattern.getPathExpressions());
        while (!pathExpressions.isEmpty()) {
            PathExpression pe = QueryOptimizer._selectNextPathExpression(pathExpressions, boundVars);
            pathExpressions.remove(pe);
            expressions.add(pe);
            pe.getVariables(boundVars);
            QueryOptimizer._addVerifiableConstraints(conjunctiveConstraints, boundVars, expressions);
        }
        LinkedList optionals = new LinkedList(graphPattern.getOptionals());
        while (!optionals.isEmpty()) {
            PathExpression pe = QueryOptimizer._selectNextPathExpression(optionals, boundVars);
            optionals.remove(pe);
            expressions.add(pe);
            pe.getVariables(boundVars);
            QueryOptimizer._addVerifiableConstraints(conjunctiveConstraints, boundVars, expressions);
        }
        expressions.addAll(conjunctiveConstraints);
        graphPattern.setExpressions(expressions);
    }

    private static PathExpression _selectNextPathExpression(List pathExpressions, Set boundVars) {
        int bestScore = Integer.MIN_VALUE;
        PathExpression result = null;
        ArrayList vars = new ArrayList();
        for (int i = 0; i < pathExpressions.size(); ++i) {
            PathExpression pe = (PathExpression)pathExpressions.get(i);
            vars.clear();
            pe.getVariables(vars);
            int score = 0;
            for (int j = 0; j < vars.size(); ++j) {
                Var var = (Var)vars.get(j);
                if (var.hasValue()) {
                    score += 3;
                    continue;
                }
                if (!boundVars.contains(var)) continue;
                score += 4;
            }
            if (pe instanceof DirectType || pe instanceof DirectSubClassOf || pe instanceof DirectSubPropertyOf) {
                --score;
            }
            if (score <= bestScore) continue;
            bestScore = score;
            result = pe;
        }
        return result;
    }

    private static void _addVerifiableConstraints(List conjunctiveConstraints, Set boundVars, List expressions) {
        Iterator iter = conjunctiveConstraints.iterator();
        while (iter.hasNext()) {
            BooleanExpr constraint = (BooleanExpr)iter.next();
            HashSet constraintVars = new HashSet();
            constraint.getVariables(constraintVars);
            if (!boundVars.containsAll(constraintVars)) continue;
            expressions.add(constraint);
            iter.remove();
        }
    }
}

