/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sail.query;

import java.io.IOException;
import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.sesame.sail.query.DuplicatesFilter;
import org.openrdf.sesame.sail.query.Query;
import org.openrdf.sesame.sail.query.QueryAnswer;
import org.openrdf.sesame.sail.query.QueryAnswerListener;
import org.openrdf.sesame.sail.query.SailQueryException;
import org.openrdf.sesame.sail.query.SetOperator;

public class Union
extends SetOperator {
    public Union(Query leftArg, Query rightArg, boolean all) {
        super(leftArg, rightArg, all);
    }

    public void evaluate(RdfSource rdfSource, QueryAnswerListener listener) throws SailQueryException {
        if (!this._all) {
            listener = new DuplicatesFilter(listener);
        }
        ContinueEvaluationListener cel = new ContinueEvaluationListener(listener);
        this._leftArg.evaluate(rdfSource, cel);
        if (cel.continueEvaluation()) {
            this._rightArg.evaluate(rdfSource, listener);
        }
    }

    public String toString() {
        return "(" + this._leftArg.toString() + " UNION " + (this._all ? "ALL " : "") + this._rightArg.toString() + ")";
    }

    private static class ContinueEvaluationListener
    implements QueryAnswerListener {
        private boolean _continueEvaluation = true;
        private QueryAnswerListener _listener;

        public ContinueEvaluationListener(QueryAnswerListener l) {
            this._listener = l;
        }

        public boolean queryAnswer(QueryAnswer qa) throws IOException {
            this._continueEvaluation = this._listener.queryAnswer(qa);
            return this._continueEvaluation;
        }

        public void clear() {
        }

        public boolean continueEvaluation() {
            return this._continueEvaluation;
        }
    }
}

