/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.memory;

import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sailimpl.memory.MemStatement;
import org.openrdf.sesame.sailimpl.memory.MemStatementIterator;
import org.openrdf.sesame.sailimpl.memory.RdfSchemaRepository;
import org.openrdf.sesame.sailimpl.memory.ResourceNode;
import org.openrdf.sesame.sailimpl.memory.StatementList;
import org.openrdf.sesame.sailimpl.memory.URINode;
import org.openrdf.sesame.sailimpl.memory.ValueNode;
import org.openrdf.util.log.ThreadLog;

public class RdfMTInferencer {
    private static final int Rdf1 = 0;
    private static final int Rdfs2_1 = 1;
    private static final int Rdfs2_2 = 2;
    private static final int Rdfs3_1 = 3;
    private static final int Rdfs3_2 = 4;
    private static final int Rdfs4a = 5;
    private static final int Rdfs4b = 6;
    private static final int Rdfs5_1 = 7;
    private static final int Rdfs5_2 = 8;
    private static final int Rdfs6 = 9;
    private static final int Rdfs7_1 = 10;
    private static final int Rdfs7_2 = 11;
    private static final int Rdfs8 = 12;
    private static final int Rdfs9_1 = 13;
    private static final int Rdfs9_2 = 14;
    private static final int Rdfs10 = 15;
    private static final int Rdfs11_1 = 16;
    private static final int Rdfs11_2 = 17;
    private static final int Rdfs12 = 18;
    private static final int Rdfs13 = 19;
    private static final int RX1 = 20;
    private static final int RULECOUNT = 21;
    private static final String[] RULENAMES = new String[]{"   Rdf1", " Rdfs2_1", " Rdfs2_2", " Rdfs3_1", " Rdfs3_2", "  Rdfs4a", "  Rdfs4b", "Rdfs5_1", "Rdfs5_2", "  Rdfs6", " Rdfs7_1", " Rdfs7_2", "  Rdfs8", " Rdfs9_1", " Rdfs9_2", "  Rdfs10", " Rdfs11_1", " Rdfs11_2", "  Rdfs12", "  Rdfs13", "  RX1"};
    private static final boolean _ = false;
    private static final boolean X = true;
    protected static final boolean[][] TRIGGERS = new boolean[][]{{false, true, false, true, false, true, false, false, false, true, true, false, false, false, true, false, false, false, false, false, false}, {false, true, false, true, false, false, false, false, false, true, true, false, true, false, true, true, false, false, true, true, false}, {false, true, false, true, false, false, false, false, false, true, true, false, true, false, true, true, false, false, true, true, false}, {false, true, false, true, false, false, false, false, false, true, true, false, true, false, true, true, false, false, true, true, false}, {false, true, false, true, false, false, false, false, false, true, true, false, true, false, true, true, false, false, true, true, false}, {false, true, false, true, false, false, false, false, false, false, true, false, false, false, true, false, false, false, false, false, false}, {false, true, false, true, false, false, false, false, false, false, true, false, false, false, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, true, true, false, true, true, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, true, true, false, true, true, false, false, false, false, false, false, false, false, false}, {false, true, false, true, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false}, {false, true, true, true, true, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {false, true, true, true, true, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {false, true, false, true, false, false, false, false, false, false, true, false, false, true, false, false, true, true, false, false, false}, {false, false, false, true, false, false, false, false, false, true, true, false, true, false, true, true, false, false, true, true, false}, {false, false, false, true, false, false, false, false, false, true, true, false, true, false, true, true, false, false, true, true, false}, {false, true, false, true, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, true, false, false, true, false, false, true, true, false, false, false}, {false, false, false, false, false, false, false, false, false, false, true, false, false, true, false, false, true, true, false, false, false}, {false, true, false, true, false, false, true, true, true, false, true, true, false, false, false, false, false, false, false, false, false}, {false, true, false, true, false, false, false, false, false, false, true, false, false, true, false, false, true, true, false, false, false}, {false, true, false, true, false, false, false, false, false, false, true, false, false, false, true, false, false, false, true, false, false}};
    private RdfSchemaRepository _repository;
    private StatementList _newStatements;
    private StatementList _newThisIteration;
    private boolean[] _checkRule = new boolean[21];
    private boolean[] _checkRuleNextIter = new boolean[21];
    private int _totalInferred = 0;
    private int[] _ruleCount = new int[21];

    protected RdfMTInferencer(RdfSchemaRepository repository) {
        this._repository = repository;
    }

    protected void initialize() {
        this._addAxiomStatements();
        this.doInferencing();
    }

    protected void notifyNewStatement(Statement newStatement) {
        if (this._newStatements == null) {
            this._newStatements = new StatementList(512);
        }
        this._newStatements.add(newStatement);
    }

    protected void notifyNewStatements(StatementList newStatements) {
        if (this._newStatements == null) {
            this._newStatements = new StatementList(newStatements);
        } else {
            this._newStatements.addAll(newStatements);
        }
    }

    protected void doInferencing() {
        int i;
        if (this._newStatements == null) {
            return;
        }
        this._totalInferred = 0;
        int iteration = 0;
        int nofInferred = 1;
        for (i = 0; i < 21; ++i) {
            this._ruleCount[i] = 0;
            this._checkRuleNextIter[i] = true;
        }
        while (nofInferred > 0) {
            ++iteration;
            this._prepareIteration();
            nofInferred = 0;
            nofInferred += this._applyRuleRdf1();
            nofInferred += this._applyRuleRdfs2_1();
            nofInferred += this._applyRuleRdfs2_2();
            nofInferred += this._applyRuleRdfs3_1();
            nofInferred += this._applyRuleRdfs3_2();
            nofInferred += this._applyRuleRdfs4a();
            nofInferred += this._applyRuleRdfs4b();
            nofInferred += this._applyRuleRdfs5_1();
            nofInferred += this._applyRuleRdfs5_2();
            nofInferred += this._applyRuleRdfs6();
            nofInferred += this._applyRuleRdfs7_1();
            nofInferred += this._applyRuleRdfs7_2();
            nofInferred += this._applyRuleRdfs8();
            nofInferred += this._applyRuleRdfs9_1();
            nofInferred += this._applyRuleRdfs9_2();
            nofInferred += this._applyRuleRdfs10();
            nofInferred += this._applyRuleRdfs11_1();
            nofInferred += this._applyRuleRdfs11_2();
            nofInferred += this._applyRuleRdfs12();
            nofInferred += this._applyRuleRdfs13();
            ThreadLog.trace((String)("iteration " + iteration + " done; " + "inferred " + (nofInferred += this._applyRuleX1()) + " new statements"));
            this._totalInferred += nofInferred;
        }
        ThreadLog.trace((String)"---RdfMTInferencer statistics:---");
        ThreadLog.trace((String)("total statements inferred = " + this._totalInferred));
        for (i = 0; i < 21; ++i) {
            ThreadLog.trace((String)("rule " + RULENAMES[i] + ":\t#inferred=" + this._ruleCount[i]));
        }
        ThreadLog.trace((String)"---end of statistics:---");
        this._newStatements = null;
        this._newThisIteration = null;
    }

    private void _prepareIteration() {
        this._newThisIteration = this._newStatements;
        this._newStatements = new StatementList();
        for (int i = 0; i < 21; ++i) {
            this._checkRule[i] = this._checkRuleNextIter[i];
            this._checkRuleNextIter[i] = false;
        }
    }

    private void _updateTriggers(int ruleNo, int nofInferred) {
        if (nofInferred > 0) {
            int n = ruleNo;
            this._ruleCount[n] = this._ruleCount[n] + nofInferred;
            boolean[] triggers = TRIGGERS[ruleNo];
            for (int i = 0; i < 21; ++i) {
                if (!triggers[i]) continue;
                this._checkRuleNextIter[i] = true;
            }
        }
    }

    private int _applyRuleRdf1() {
        if (!this._checkRule[0]) {
            return 0;
        }
        int nofInferred = 0;
        MemStatementIterator iter = new MemStatementIterator(this._newThisIteration);
        while (iter.hasNext()) {
            Statement st = iter.next();
            boolean added = this._addInferredStatement((URINode)st.getPredicate(), this._repository.RDF_TYPE_NODE, this._repository.RDF_PROPERTY_NODE);
            if (!added) continue;
            ++nofInferred;
        }
        iter.close();
        this._updateTriggers(0, nofInferred);
        return nofInferred;
    }

    private int _applyRuleRdfs2_1() {
        if (!this._checkRule[1]) {
            return 0;
        }
        int nofInferred = 0;
        MemStatementIterator ntIter = new MemStatementIterator(this._newThisIteration);
        while (ntIter.hasNext()) {
            Statement nt = ntIter.next();
            ResourceNode xxx = (ResourceNode)nt.getSubject();
            URINode aaa = (URINode)nt.getPredicate();
            StatementIterator t1Iter = this._repository.getStatements(aaa, (URI)this._repository.RDFS_DOMAIN_NODE, null);
            while (t1Iter.hasNext()) {
                boolean added;
                Statement t1 = t1Iter.next();
                ValueNode zzz = (ValueNode)t1.getObject();
                if (!(zzz instanceof ResourceNode) || !(added = this._addInferredStatement(xxx, this._repository.RDF_TYPE_NODE, zzz))) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        ntIter.close();
        this._updateTriggers(1, nofInferred);
        return nofInferred;
    }

    private int _applyRuleRdfs2_2() {
        if (!this._checkRule[2]) {
            return 0;
        }
        int nofInferred = 0;
        MemStatementIterator ntIter = new MemStatementIterator(this._newThisIteration, null, this._repository.RDFS_DOMAIN_NODE, null);
        while (ntIter.hasNext()) {
            Statement nt = ntIter.next();
            ResourceNode aaa = (ResourceNode)nt.getSubject();
            ValueNode zzz = (ValueNode)nt.getObject();
            if (!(aaa instanceof URINode) || !(zzz instanceof ResourceNode)) continue;
            StatementIterator t1Iter = this._repository.getStatements(null, (URI)((URINode)aaa), null);
            while (t1Iter.hasNext()) {
                Statement t1 = t1Iter.next();
                ResourceNode xxx = (ResourceNode)t1.getSubject();
                boolean added = this._addInferredStatement(xxx, this._repository.RDF_TYPE_NODE, zzz);
                if (!added) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        ntIter.close();
        this._updateTriggers(2, nofInferred);
        return nofInferred;
    }

    private int _applyRuleRdfs3_1() {
        if (!this._checkRule[3]) {
            return 0;
        }
        int nofInferred = 0;
        MemStatementIterator ntIter = new MemStatementIterator(this._newThisIteration);
        while (ntIter.hasNext()) {
            Statement nt = ntIter.next();
            URINode aaa = (URINode)nt.getPredicate();
            ValueNode uuu = (ValueNode)nt.getObject();
            if (!(uuu instanceof ResourceNode)) continue;
            StatementIterator t1Iter = this._repository.getStatements(aaa, (URI)this._repository.RDFS_RANGE_NODE, null);
            while (t1Iter.hasNext()) {
                boolean added;
                Statement t1 = t1Iter.next();
                ValueNode zzz = (ValueNode)t1.getObject();
                if (!(zzz instanceof ResourceNode) || !(added = this._addInferredStatement((ResourceNode)uuu, this._repository.RDF_TYPE_NODE, zzz))) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        ntIter.close();
        this._updateTriggers(3, nofInferred);
        return nofInferred;
    }

    private int _applyRuleRdfs3_2() {
        if (!this._checkRule[4]) {
            return 0;
        }
        int nofInferred = 0;
        MemStatementIterator ntIter = new MemStatementIterator(this._newThisIteration, null, this._repository.RDFS_RANGE_NODE, null);
        while (ntIter.hasNext()) {
            Statement nt = ntIter.next();
            ResourceNode aaa = (ResourceNode)nt.getSubject();
            ValueNode zzz = (ValueNode)nt.getObject();
            if (!(aaa instanceof URINode) || !(zzz instanceof ResourceNode)) continue;
            StatementIterator t1Iter = this._repository.getStatements(null, (URI)((URINode)aaa), null);
            while (t1Iter.hasNext()) {
                boolean added;
                Statement t1 = t1Iter.next();
                ValueNode uuu = (ValueNode)t1.getObject();
                if (!(uuu instanceof ResourceNode) || !(added = this._addInferredStatement((ResourceNode)uuu, this._repository.RDF_TYPE_NODE, zzz))) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        ntIter.close();
        this._updateTriggers(4, nofInferred);
        return nofInferred;
    }

    private int _applyRuleRdfs4a() {
        if (!this._checkRule[5]) {
            return 0;
        }
        int nofInferred = 0;
        MemStatementIterator iter = new MemStatementIterator(this._newThisIteration);
        while (iter.hasNext()) {
            Statement st = iter.next();
            boolean added = this._addInferredStatement((ResourceNode)st.getSubject(), this._repository.RDF_TYPE_NODE, this._repository.RDFS_RESOURCE_NODE);
            if (!added) continue;
            ++nofInferred;
        }
        iter.close();
        this._updateTriggers(5, nofInferred);
        return nofInferred;
    }

    private int _applyRuleRdfs4b() {
        if (!this._checkRule[6]) {
            return 0;
        }
        int nofInferred = 0;
        MemStatementIterator iter = new MemStatementIterator(this._newThisIteration);
        while (iter.hasNext()) {
            boolean added;
            Statement st = iter.next();
            ValueNode uuu = (ValueNode)st.getObject();
            if (!(uuu instanceof ResourceNode) || !(added = this._addInferredStatement((ResourceNode)uuu, this._repository.RDF_TYPE_NODE, this._repository.RDFS_RESOURCE_NODE))) continue;
            ++nofInferred;
        }
        iter.close();
        this._updateTriggers(6, nofInferred);
        return nofInferred;
    }

    private int _applyRuleRdfs5_1() {
        if (!this._checkRule[7]) {
            return 0;
        }
        int nofInferred = 0;
        MemStatementIterator ntIter = new MemStatementIterator(this._newThisIteration, null, this._repository.RDFS_SUBPROPERTYOF_NODE, null);
        while (ntIter.hasNext()) {
            Statement nt = ntIter.next();
            ResourceNode aaa = (ResourceNode)nt.getSubject();
            ValueNode bbb = (ValueNode)nt.getObject();
            if (!(bbb instanceof ResourceNode)) continue;
            StatementIterator t1Iter = this._repository.getStatements((ResourceNode)bbb, (URI)this._repository.RDFS_SUBPROPERTYOF_NODE, null);
            while (t1Iter.hasNext()) {
                boolean added;
                Statement t1 = t1Iter.next();
                ValueNode ccc = (ValueNode)t1.getObject();
                if (!(ccc instanceof ResourceNode) || !(added = this._addInferredStatement(aaa, this._repository.RDFS_SUBPROPERTYOF_NODE, ccc))) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        ntIter.close();
        this._updateTriggers(7, nofInferred);
        return nofInferred;
    }

    private int _applyRuleRdfs5_2() {
        if (!this._checkRule[8]) {
            return 0;
        }
        int nofInferred = 0;
        MemStatementIterator ntIter = new MemStatementIterator(this._newThisIteration, null, this._repository.RDFS_SUBPROPERTYOF_NODE, null);
        while (ntIter.hasNext()) {
            Statement nt = ntIter.next();
            ResourceNode bbb = (ResourceNode)nt.getSubject();
            ValueNode ccc = (ValueNode)nt.getObject();
            if (!(ccc instanceof ResourceNode)) continue;
            StatementIterator t1Iter = this._repository.getStatements(null, (URI)this._repository.RDFS_SUBPROPERTYOF_NODE, bbb);
            while (t1Iter.hasNext()) {
                Statement t1 = t1Iter.next();
                ResourceNode aaa = (ResourceNode)t1.getSubject();
                boolean added = this._addInferredStatement(aaa, this._repository.RDFS_SUBPROPERTYOF_NODE, ccc);
                if (!added) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        ntIter.close();
        this._updateTriggers(8, nofInferred);
        return nofInferred;
    }

    private int _applyRuleRdfs6() {
        if (!this._checkRule[9]) {
            return 0;
        }
        int nofInferred = 0;
        MemStatementIterator iter = new MemStatementIterator(this._newThisIteration, null, this._repository.RDF_TYPE_NODE, this._repository.RDF_PROPERTY_NODE);
        while (iter.hasNext()) {
            Statement st = iter.next();
            ResourceNode xxx = (ResourceNode)st.getSubject();
            boolean added = this._addInferredStatement(xxx, this._repository.RDFS_SUBPROPERTYOF_NODE, xxx);
            if (!added) continue;
            ++nofInferred;
        }
        iter.close();
        this._updateTriggers(9, nofInferred);
        return nofInferred;
    }

    private int _applyRuleRdfs7_1() {
        if (!this._checkRule[10]) {
            return 0;
        }
        int nofInferred = 0;
        MemStatementIterator ntIter = new MemStatementIterator(this._newThisIteration);
        while (ntIter.hasNext()) {
            Statement nt = ntIter.next();
            ResourceNode xxx = (ResourceNode)nt.getSubject();
            URINode aaa = (URINode)nt.getPredicate();
            ValueNode yyy = (ValueNode)nt.getObject();
            StatementIterator t1Iter = this._repository.getStatements(aaa, (URI)this._repository.RDFS_SUBPROPERTYOF_NODE, null);
            while (t1Iter.hasNext()) {
                boolean added;
                Statement t1 = t1Iter.next();
                ValueNode bbb = (ValueNode)t1.getObject();
                if (!(bbb instanceof URINode) || !(added = this._addInferredStatement(xxx, (URINode)bbb, yyy))) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        ntIter.close();
        this._updateTriggers(10, nofInferred);
        return nofInferred;
    }

    private int _applyRuleRdfs7_2() {
        if (!this._checkRule[11]) {
            return 0;
        }
        int nofInferred = 0;
        MemStatementIterator ntIter = new MemStatementIterator(this._newThisIteration, null, this._repository.RDFS_SUBPROPERTYOF_NODE, null);
        while (ntIter.hasNext()) {
            Statement nt = ntIter.next();
            ResourceNode aaa = (ResourceNode)nt.getSubject();
            ValueNode bbb = (ValueNode)nt.getObject();
            if (!(aaa instanceof URINode) || !(bbb instanceof URINode)) continue;
            StatementIterator t1Iter = this._repository.getStatements(null, (URI)((URINode)aaa), null);
            while (t1Iter.hasNext()) {
                ValueNode yyy;
                Statement t1 = t1Iter.next();
                ResourceNode xxx = (ResourceNode)t1.getSubject();
                boolean added = this._addInferredStatement(xxx, (URINode)bbb, yyy = (ValueNode)t1.getObject());
                if (!added) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        ntIter.close();
        this._updateTriggers(11, nofInferred);
        return nofInferred;
    }

    private int _applyRuleRdfs8() {
        if (!this._checkRule[12]) {
            return 0;
        }
        int nofInferred = 0;
        MemStatementIterator iter = new MemStatementIterator(this._newThisIteration, null, this._repository.RDF_TYPE_NODE, this._repository.RDFS_CLASS_NODE);
        while (iter.hasNext()) {
            Statement st = iter.next();
            ResourceNode xxx = (ResourceNode)st.getSubject();
            boolean added = this._addInferredStatement(xxx, this._repository.RDFS_SUBCLASSOF_NODE, this._repository.RDFS_RESOURCE_NODE);
            if (!added) continue;
            ++nofInferred;
        }
        iter.close();
        this._updateTriggers(12, nofInferred);
        return nofInferred;
    }

    private int _applyRuleRdfs10() {
        if (!this._checkRule[15]) {
            return 0;
        }
        int nofInferred = 0;
        MemStatementIterator iter = new MemStatementIterator(this._newThisIteration, null, this._repository.RDF_TYPE_NODE, this._repository.RDFS_CLASS_NODE);
        while (iter.hasNext()) {
            Statement st = iter.next();
            ResourceNode xxx = (ResourceNode)st.getSubject();
            boolean added = this._addInferredStatement(xxx, this._repository.RDFS_SUBCLASSOF_NODE, xxx);
            if (!added) continue;
            ++nofInferred;
        }
        iter.close();
        this._updateTriggers(15, nofInferred);
        return nofInferred;
    }

    private int _applyRuleRdfs11_1() {
        if (!this._checkRule[16]) {
            return 0;
        }
        int nofInferred = 0;
        MemStatementIterator ntIter = new MemStatementIterator(this._newThisIteration, null, this._repository.RDFS_SUBCLASSOF_NODE, null);
        while (ntIter.hasNext()) {
            Statement nt = ntIter.next();
            ResourceNode xxx = (ResourceNode)nt.getSubject();
            ValueNode yyy = (ValueNode)nt.getObject();
            if (!(yyy instanceof ResourceNode)) continue;
            StatementIterator t1Iter = this._repository.getStatements((ResourceNode)yyy, (URI)this._repository.RDFS_SUBCLASSOF_NODE, null, false);
            while (t1Iter.hasNext()) {
                boolean added;
                Statement t1 = t1Iter.next();
                ValueNode zzz = (ValueNode)t1.getObject();
                if (!(zzz instanceof ResourceNode) || !(added = this._addInferredStatement(xxx, this._repository.RDFS_SUBCLASSOF_NODE, zzz))) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        ntIter.close();
        this._updateTriggers(16, nofInferred);
        return nofInferred;
    }

    private int _applyRuleRdfs11_2() {
        if (!this._checkRule[17]) {
            return 0;
        }
        int nofInferred = 0;
        MemStatementIterator ntIter = new MemStatementIterator(this._newThisIteration, null, this._repository.RDFS_SUBCLASSOF_NODE, null);
        while (ntIter.hasNext()) {
            Statement nt = ntIter.next();
            ResourceNode yyy = (ResourceNode)nt.getSubject();
            ValueNode zzz = (ValueNode)nt.getObject();
            if (!(zzz instanceof ResourceNode)) continue;
            StatementIterator t1Iter = this._repository.getStatements(null, (URI)this._repository.RDFS_SUBCLASSOF_NODE, yyy);
            while (t1Iter.hasNext()) {
                Statement t1 = t1Iter.next();
                ResourceNode xxx = (ResourceNode)t1.getSubject();
                boolean added = this._addInferredStatement(xxx, this._repository.RDFS_SUBCLASSOF_NODE, zzz);
                if (!added) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        ntIter.close();
        this._updateTriggers(17, nofInferred);
        return nofInferred;
    }

    private int _applyRuleRdfs9_1() {
        if (!this._checkRule[13]) {
            return 0;
        }
        int nofInferred = 0;
        MemStatementIterator ntIter = new MemStatementIterator(this._newThisIteration, null, this._repository.RDFS_SUBCLASSOF_NODE, null);
        while (ntIter.hasNext()) {
            Statement nt = ntIter.next();
            ResourceNode xxx = (ResourceNode)nt.getSubject();
            ValueNode yyy = (ValueNode)nt.getObject();
            if (!(yyy instanceof ResourceNode)) continue;
            StatementIterator t1Iter = this._repository.getStatements(null, (URI)this._repository.RDF_TYPE_NODE, xxx, false);
            while (t1Iter.hasNext()) {
                Statement t1 = t1Iter.next();
                ResourceNode aaa = (ResourceNode)t1.getSubject();
                boolean added = this._addInferredStatement(aaa, this._repository.RDF_TYPE_NODE, yyy);
                if (!added) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        ntIter.close();
        this._updateTriggers(13, nofInferred);
        return nofInferred;
    }

    private int _applyRuleRdfs9_2() {
        if (!this._checkRule[14]) {
            return 0;
        }
        int nofInferred = 0;
        MemStatementIterator ntIter = new MemStatementIterator(this._newThisIteration, null, this._repository.RDF_TYPE_NODE, null);
        while (ntIter.hasNext()) {
            Statement nt = ntIter.next();
            ResourceNode aaa = (ResourceNode)nt.getSubject();
            ValueNode xxx = (ValueNode)nt.getObject();
            if (!(xxx instanceof ResourceNode)) continue;
            StatementIterator t1Iter = this._repository.getStatements((ResourceNode)xxx, (URI)this._repository.RDFS_SUBCLASSOF_NODE, null);
            while (t1Iter.hasNext()) {
                boolean added;
                Statement t1 = t1Iter.next();
                ValueNode yyy = (ValueNode)t1.getObject();
                if (!(yyy instanceof ResourceNode) || !(added = this._addInferredStatement(aaa, this._repository.RDF_TYPE_NODE, yyy))) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        ntIter.close();
        this._updateTriggers(14, nofInferred);
        return nofInferred;
    }

    private int _applyRuleRdfs12() {
        if (!this._checkRule[18]) {
            return 0;
        }
        int nofInferred = 0;
        MemStatementIterator iter = new MemStatementIterator(this._newThisIteration, null, this._repository.RDF_TYPE_NODE, this._repository.RDFS_CONTAINERMEMBERSHIPPROPERTY_NODE);
        while (iter.hasNext()) {
            Statement st = iter.next();
            ResourceNode xxx = (ResourceNode)st.getSubject();
            boolean added = this._addInferredStatement(xxx, this._repository.RDFS_SUBPROPERTYOF_NODE, this._repository.RDFS_MEMBER_NODE);
            if (!added) continue;
            ++nofInferred;
        }
        iter.close();
        this._updateTriggers(18, nofInferred);
        return nofInferred;
    }

    private int _applyRuleRdfs13() {
        if (!this._checkRule[19]) {
            return 0;
        }
        int nofInferred = 0;
        MemStatementIterator iter = new MemStatementIterator(this._newThisIteration, null, this._repository.RDF_TYPE_NODE, this._repository.RDFS_DATATYPE_NODE);
        while (iter.hasNext()) {
            Statement st = iter.next();
            ResourceNode xxx = (ResourceNode)st.getSubject();
            boolean added = this._addInferredStatement(xxx, this._repository.RDFS_SUBCLASSOF_NODE, this._repository.RDFS_LITERAL_NODE);
            if (!added) continue;
            ++nofInferred;
        }
        iter.close();
        this._updateTriggers(19, nofInferred);
        return nofInferred;
    }

    private int _applyRuleX1() {
        if (!this._checkRule[20]) {
            return 0;
        }
        int nofInferred = 0;
        MemStatementIterator iter = new MemStatementIterator(this._newThisIteration);
        while (iter.hasNext()) {
            boolean added;
            Statement st = iter.next();
            URINode predNode = (URINode)st.getPredicate();
            if (!predNode.getNamespace().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#") || !predNode.getLocalName().startsWith("_") || !(added = this._addInferredStatement(predNode, this._repository.RDF_TYPE_NODE, this._repository.RDFS_CONTAINERMEMBERSHIPPROPERTY_NODE))) continue;
            ++nofInferred;
        }
        iter.close();
        this._updateTriggers(20, nofInferred);
        return nofInferred;
    }

    private void _addAxiomStatements() {
        this._addInferredStatement(this._repository.RDF_TYPE_NODE, this._repository.RDF_TYPE_NODE, this._repository.RDF_PROPERTY_NODE);
        this._addInferredStatement(this._repository.RDF_SUBJECT_NODE, this._repository.RDF_TYPE_NODE, this._repository.RDF_PROPERTY_NODE);
        this._addInferredStatement(this._repository.RDF_PREDICATE_NODE, this._repository.RDF_TYPE_NODE, this._repository.RDF_PROPERTY_NODE);
        this._addInferredStatement(this._repository.RDF_OBJECT_NODE, this._repository.RDF_TYPE_NODE, this._repository.RDF_PROPERTY_NODE);
        this._addInferredStatement(this._repository.RDF_FIRST_NODE, this._repository.RDF_TYPE_NODE, this._repository.RDF_PROPERTY_NODE);
        this._addInferredStatement(this._repository.RDF_REST_NODE, this._repository.RDF_TYPE_NODE, this._repository.RDF_PROPERTY_NODE);
        this._addInferredStatement(this._repository.RDF_VALUE_NODE, this._repository.RDF_TYPE_NODE, this._repository.RDF_PROPERTY_NODE);
        this._addInferredStatement(this._repository.RDF_NIL_NODE, this._repository.RDF_TYPE_NODE, this._repository.RDF_LIST_NODE);
        this._addInferredStatement(this._repository.RDF_TYPE_NODE, this._repository.RDFS_DOMAIN_NODE, this._repository.RDFS_RESOURCE_NODE);
        this._addInferredStatement(this._repository.RDFS_DOMAIN_NODE, this._repository.RDFS_DOMAIN_NODE, this._repository.RDF_PROPERTY_NODE);
        this._addInferredStatement(this._repository.RDFS_RANGE_NODE, this._repository.RDFS_DOMAIN_NODE, this._repository.RDF_PROPERTY_NODE);
        this._addInferredStatement(this._repository.RDFS_SUBPROPERTYOF_NODE, this._repository.RDFS_DOMAIN_NODE, this._repository.RDF_PROPERTY_NODE);
        this._addInferredStatement(this._repository.RDFS_SUBCLASSOF_NODE, this._repository.RDFS_DOMAIN_NODE, this._repository.RDFS_CLASS_NODE);
        this._addInferredStatement(this._repository.RDF_SUBJECT_NODE, this._repository.RDFS_DOMAIN_NODE, this._repository.RDF_STATEMENT_NODE);
        this._addInferredStatement(this._repository.RDF_PREDICATE_NODE, this._repository.RDFS_DOMAIN_NODE, this._repository.RDF_STATEMENT_NODE);
        this._addInferredStatement(this._repository.RDF_OBJECT_NODE, this._repository.RDFS_DOMAIN_NODE, this._repository.RDF_STATEMENT_NODE);
        this._addInferredStatement(this._repository.RDFS_MEMBER_NODE, this._repository.RDFS_DOMAIN_NODE, this._repository.RDFS_RESOURCE_NODE);
        this._addInferredStatement(this._repository.RDF_FIRST_NODE, this._repository.RDFS_DOMAIN_NODE, this._repository.RDF_LIST_NODE);
        this._addInferredStatement(this._repository.RDF_REST_NODE, this._repository.RDFS_DOMAIN_NODE, this._repository.RDF_LIST_NODE);
        this._addInferredStatement(this._repository.RDFS_SEEALSO_NODE, this._repository.RDFS_DOMAIN_NODE, this._repository.RDFS_RESOURCE_NODE);
        this._addInferredStatement(this._repository.RDFS_ISDEFINEDBY_NODE, this._repository.RDFS_DOMAIN_NODE, this._repository.RDFS_RESOURCE_NODE);
        this._addInferredStatement(this._repository.RDFS_COMMENT_NODE, this._repository.RDFS_DOMAIN_NODE, this._repository.RDFS_RESOURCE_NODE);
        this._addInferredStatement(this._repository.RDFS_LABEL_NODE, this._repository.RDFS_DOMAIN_NODE, this._repository.RDFS_RESOURCE_NODE);
        this._addInferredStatement(this._repository.RDF_VALUE_NODE, this._repository.RDFS_DOMAIN_NODE, this._repository.RDFS_RESOURCE_NODE);
        this._addInferredStatement(this._repository.RDF_TYPE_NODE, this._repository.RDFS_RANGE_NODE, this._repository.RDFS_CLASS_NODE);
        this._addInferredStatement(this._repository.RDFS_DOMAIN_NODE, this._repository.RDFS_RANGE_NODE, this._repository.RDFS_CLASS_NODE);
        this._addInferredStatement(this._repository.RDFS_RANGE_NODE, this._repository.RDFS_RANGE_NODE, this._repository.RDFS_CLASS_NODE);
        this._addInferredStatement(this._repository.RDFS_SUBPROPERTYOF_NODE, this._repository.RDFS_RANGE_NODE, this._repository.RDF_PROPERTY_NODE);
        this._addInferredStatement(this._repository.RDFS_SUBCLASSOF_NODE, this._repository.RDFS_RANGE_NODE, this._repository.RDFS_CLASS_NODE);
        this._addInferredStatement(this._repository.RDF_SUBJECT_NODE, this._repository.RDFS_RANGE_NODE, this._repository.RDFS_RESOURCE_NODE);
        this._addInferredStatement(this._repository.RDF_PREDICATE_NODE, this._repository.RDFS_RANGE_NODE, this._repository.RDFS_RESOURCE_NODE);
        this._addInferredStatement(this._repository.RDF_OBJECT_NODE, this._repository.RDFS_RANGE_NODE, this._repository.RDFS_RESOURCE_NODE);
        this._addInferredStatement(this._repository.RDFS_MEMBER_NODE, this._repository.RDFS_RANGE_NODE, this._repository.RDFS_RESOURCE_NODE);
        this._addInferredStatement(this._repository.RDF_FIRST_NODE, this._repository.RDFS_RANGE_NODE, this._repository.RDFS_RESOURCE_NODE);
        this._addInferredStatement(this._repository.RDF_REST_NODE, this._repository.RDFS_RANGE_NODE, this._repository.RDF_LIST_NODE);
        this._addInferredStatement(this._repository.RDFS_SEEALSO_NODE, this._repository.RDFS_RANGE_NODE, this._repository.RDFS_RESOURCE_NODE);
        this._addInferredStatement(this._repository.RDFS_ISDEFINEDBY_NODE, this._repository.RDFS_RANGE_NODE, this._repository.RDFS_RESOURCE_NODE);
        this._addInferredStatement(this._repository.RDFS_COMMENT_NODE, this._repository.RDFS_RANGE_NODE, this._repository.RDFS_LITERAL_NODE);
        this._addInferredStatement(this._repository.RDFS_LABEL_NODE, this._repository.RDFS_RANGE_NODE, this._repository.RDFS_LITERAL_NODE);
        this._addInferredStatement(this._repository.RDF_VALUE_NODE, this._repository.RDFS_RANGE_NODE, this._repository.RDFS_RESOURCE_NODE);
        this._addInferredStatement(this._repository.RDF_ALT_NODE, this._repository.RDFS_SUBCLASSOF_NODE, this._repository.RDFS_CONTAINER_NODE);
        this._addInferredStatement(this._repository.RDF_BAG_NODE, this._repository.RDFS_SUBCLASSOF_NODE, this._repository.RDFS_CONTAINER_NODE);
        this._addInferredStatement(this._repository.RDF_SEQ_NODE, this._repository.RDFS_SUBCLASSOF_NODE, this._repository.RDFS_CONTAINER_NODE);
        this._addInferredStatement(this._repository.RDFS_CONTAINERMEMBERSHIPPROPERTY_NODE, this._repository.RDFS_SUBCLASSOF_NODE, this._repository.RDF_PROPERTY_NODE);
        this._addInferredStatement(this._repository.RDFS_ISDEFINEDBY_NODE, this._repository.RDFS_SUBPROPERTYOF_NODE, this._repository.RDFS_SEEALSO_NODE);
        this._addInferredStatement(this._repository.RDF_XMLLITERAL_NODE, this._repository.RDF_TYPE_NODE, this._repository.RDFS_DATATYPE_NODE);
        this._addInferredStatement(this._repository.RDF_XMLLITERAL_NODE, this._repository.RDFS_SUBCLASSOF_NODE, this._repository.RDFS_LITERAL_NODE);
        this._addInferredStatement(this._repository.RDFS_DATATYPE_NODE, this._repository.RDFS_SUBCLASSOF_NODE, this._repository.RDFS_CLASS_NODE);
    }

    private boolean _addInferredStatement(ResourceNode subjNode, URINode predNode, ValueNode objNode) {
        if (this._repository.hasStatement(subjNode, (URI)predNode, objNode)) {
            return false;
        }
        MemStatement newStatement = this._repository._addStatement(subjNode, (URI)predNode, objNode);
        newStatement.setExplicit(false);
        this.notifyNewStatement((Statement)newStatement);
        return true;
    }
}

