/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.nativerdf.datastore;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.openrdf.util.log.ThreadLog;

public class TransferUtil {
    private static boolean supportsTransfer = true;
    private static ByteBuffer _byteBuffer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long transferTo(FileChannel sourceChannel, long startPos, long count, WritableByteChannel targetChannel) throws IOException {
        long curPos;
        if (supportsTransfer) {
            return sourceChannel.transferTo(startPos, count, targetChannel);
        }
        long maxPos = startPos + count;
        ByteBuffer byteBuffer = _byteBuffer;
        synchronized (byteBuffer) {
            int c;
            for (curPos = startPos; curPos < maxPos; curPos += (long)c) {
                if (maxPos - curPos < (long)_byteBuffer.capacity()) {
                    _byteBuffer.limit((int)(maxPos - curPos));
                }
                if ((c = sourceChannel.read(_byteBuffer, curPos)) < 0) break;
                _byteBuffer.flip();
                targetChannel.write(_byteBuffer);
                _byteBuffer.clear();
            }
        }
        return curPos - startPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long transferFrom(ReadableByteChannel sourceChannel, long startPos, long count, FileChannel targetChannel) throws IOException {
        long curPos;
        if (supportsTransfer) {
            return targetChannel.transferFrom(sourceChannel, startPos, count);
        }
        long maxPos = startPos + count;
        ByteBuffer byteBuffer = _byteBuffer;
        synchronized (byteBuffer) {
            int c;
            for (curPos = startPos; curPos < maxPos; curPos += (long)c) {
                if (maxPos - curPos < (long)_byteBuffer.capacity()) {
                    _byteBuffer.limit((int)(maxPos - curPos));
                }
                if ((c = sourceChannel.read(_byteBuffer)) < 0) break;
                _byteBuffer.flip();
                targetChannel.write(_byteBuffer, curPos);
                _byteBuffer.clear();
            }
        }
        return curPos - startPos;
    }

    static {
        String os_name = System.getProperty("os.name");
        String os_version = System.getProperty("os.version");
        String java_version = System.getProperty("java.version");
        if (os_name != null && os_name.equalsIgnoreCase("linux") && os_version != null && os_version.startsWith("2.6.") && java_version != null && java_version.startsWith("1.4.")) {
            supportsTransfer = false;
            _byteBuffer = ByteBuffer.allocateDirect(16384);
            ThreadLog.warning((String)"Transfers on file channels not supported on this platform, falling back to possibly slower, more conventional means");
            System.err.println("Transfers on file channels not supported on this platform, falling back to possibly slower, more conventional means");
        }
    }
}

