/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.omm.security;

import java.util.ArrayList;
import java.util.Iterator;
import org.openrdf.model.Statement;
import org.openrdf.sesame.omm.SecurityServices;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sailimpl.omm.security.NullParameterException;
import org.openrdf.sesame.sailimpl.omm.security.Right;

public class StatementFilterIterator
implements StatementIterator {
    ArrayList list = new ArrayList();
    Iterator iter = null;

    public StatementFilterIterator(StatementIterator sti, SecurityServices service, Right right) throws NullParameterException {
        if (null == sti) {
            throw new NullParameterException("[StatementIterator] should not be [null].");
        }
        if (null == right) {
            throw new NullParameterException("[Right] should not be [null].");
        }
        if (null == service) {
            throw new NullParameterException("[SecurityServices] should not be [null].");
        }
        try {
            while (sti.hasNext()) {
                Statement st = sti.next();
                if (!service.isStatementAccessible(st, right)) continue;
                this.list.add(st);
            }
            sti.close();
            this.iter = this.list.iterator();
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new RuntimeException(x.getMessage());
        }
    }

    public boolean hasNext() {
        return this.iter != null && this.iter.hasNext();
    }

    public Statement next() {
        return (Statement)this.iter.next();
    }

    public void close() {
        this.iter = null;
    }
}

