/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.client;

import info.aduna.iteration.IterationWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.httpclient.HttpMethod;
import org.openrdf.http.client.QueueCursor;
import org.openrdf.model.Statement;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;

public class BackgroundGraphResult
extends IterationWrapper<Statement, QueryEvaluationException>
implements GraphQueryResult,
Runnable,
RDFHandler {
    private volatile boolean closed;
    private volatile Thread parserThread;
    private RDFParser parser;
    private Charset charset;
    private InputStream in;
    private String baseURI;
    private CountDownLatch namespacesReady = new CountDownLatch(1);
    private Map<String, String> namespaces = new ConcurrentHashMap<String, String>();
    private QueueCursor<Statement> queue;
    private HttpMethod method;

    public BackgroundGraphResult(RDFParser parser, InputStream in, Charset charset, String baseURI, HttpMethod method) {
        this(new QueueCursor<Statement>(10), parser, in, charset, baseURI, method);
    }

    public BackgroundGraphResult(QueueCursor<Statement> queue, RDFParser parser, InputStream in, Charset charset, String baseURI, HttpMethod method) {
        super(queue);
        this.queue = queue;
        this.parser = parser;
        this.in = in;
        this.charset = charset;
        this.baseURI = baseURI;
        this.method = method;
    }

    public boolean hasNext() throws QueryEvaluationException {
        return this.queue.hasNext();
    }

    public Statement next() throws QueryEvaluationException {
        return (Statement)this.queue.next();
    }

    public void remove() throws QueryEvaluationException {
        this.queue.remove();
    }

    protected void handleClose() throws QueryEvaluationException {
        super.handleClose();
        this.closed = true;
        Thread thread = this.parserThread;
        if (thread != null) {
            thread.interrupt();
        }
        try {
            this.queue.close();
            this.in.close();
        }
        catch (IOException e) {
            throw new QueryEvaluationException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean completed = false;
        this.parserThread = Thread.currentThread();
        try {
            this.parser.setRDFHandler((RDFHandler)this);
            if (this.charset == null) {
                this.parser.parse(this.in, this.baseURI);
            } else {
                this.parser.parse((Reader)new InputStreamReader(this.in, this.charset), this.baseURI);
            }
            this.method.releaseConnection();
            completed = true;
        }
        catch (RDFHandlerException e) {
        }
        catch (RDFParseException e) {
            this.queue.toss((Exception)((Object)e));
        }
        catch (IOException e) {
            this.queue.toss(e);
        }
        finally {
            this.parserThread = null;
            this.queue.done();
            if (!completed) {
                this.method.abort();
                this.method.releaseConnection();
            }
        }
    }

    public void startRDF() throws RDFHandlerException {
    }

    public Map<String, String> getNamespaces() {
        try {
            this.namespacesReady.await();
            return this.namespaces;
        }
        catch (InterruptedException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public void handleComment(String comment) throws RDFHandlerException {
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.namespaces.put(prefix, uri);
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        this.namespacesReady.countDown();
        if (this.closed) {
            throw new RDFHandlerException("Result closed");
        }
        try {
            this.queue.put(st);
        }
        catch (InterruptedException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void endRDF() throws RDFHandlerException {
        this.namespacesReady.countDown();
    }
}

