/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf;

import java.util.Arrays;
import java.util.List;
import org.openrdf.IsolationLevel;
import org.openrdf.model.IRI;
import org.openrdf.model.impl.SimpleValueFactory;

public enum IsolationLevels implements IsolationLevel
{
    NONE(new IsolationLevels[0]),
    READ_UNCOMMITTED(NONE),
    READ_COMMITTED(READ_UNCOMMITTED, NONE),
    SNAPSHOT_READ(READ_COMMITTED, READ_UNCOMMITTED, NONE),
    SNAPSHOT(SNAPSHOT_READ, READ_COMMITTED, READ_UNCOMMITTED, NONE),
    SERIALIZABLE(SNAPSHOT, SNAPSHOT_READ, READ_COMMITTED, READ_UNCOMMITTED, NONE);

    private final List<? extends IsolationLevels> compatibleLevels;

    private IsolationLevels(IsolationLevels ... compatibleLevels) {
        this.compatibleLevels = Arrays.asList(compatibleLevels);
    }

    @Override
    public boolean isCompatibleWith(IsolationLevel otherLevel) {
        return this.equals(otherLevel) || this.compatibleLevels.contains(otherLevel);
    }

    public static IsolationLevel getCompatibleIsolationLevel(IsolationLevel level, List<? extends IsolationLevel> supportedLevels) {
        if (supportedLevels == null) {
            throw new IllegalArgumentException("list of supported levels may not be null");
        }
        if (level == null) {
            throw new IllegalArgumentException("level may not be null");
        }
        if (!supportedLevels.contains(level)) {
            IsolationLevel compatibleLevel = null;
            for (IsolationLevel isolationLevel : supportedLevels) {
                if (!isolationLevel.isCompatibleWith(level)) continue;
                compatibleLevel = isolationLevel;
                break;
            }
            return compatibleLevel;
        }
        return level;
    }

    @Override
    public IRI getURI() {
        SimpleValueFactory f = SimpleValueFactory.getInstance();
        return f.createIRI("http://www.openrdf.org/schema/sesame#", this.name());
    }
}

