/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.IRI;
import org.openrdf.model.Literal;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.util.Literals;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;

public class SimpleLiteral
implements Literal {
    private static final long serialVersionUID = -1649571784782592271L;
    private String label;
    private String language;
    private IRI datatype;

    protected SimpleLiteral() {
    }

    protected SimpleLiteral(String label) {
        this.setLabel(label);
        this.setDatatype(XMLSchema.STRING);
    }

    protected SimpleLiteral(String label, String language) {
        this.setLabel(label);
        this.setLanguage(language);
    }

    protected SimpleLiteral(String label, IRI datatype) {
        this.setLabel(label);
        if (RDF.LANGSTRING.equals(datatype)) {
            throw new IllegalArgumentException("datatype rdf:langString requires a language tag");
        }
        if (datatype == null) {
            datatype = XMLSchema.STRING;
        }
        this.setDatatype(datatype);
    }

    protected void setLabel(String label) {
        Objects.requireNonNull(label, "Literal label cannot be null");
        this.label = label;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    protected void setLanguage(String language) {
        Objects.requireNonNull(language);
        this.language = language;
        this.setDatatype(RDF.LANGSTRING);
    }

    @Override
    public Optional<String> getLanguage() {
        return Optional.ofNullable(this.language);
    }

    protected void setDatatype(IRI datatype) {
        this.datatype = datatype;
    }

    @Override
    public IRI getDatatype() {
        return this.datatype;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Literal) {
            Literal other = (Literal)o;
            if (!this.label.equals(other.getLabel())) {
                return false;
            }
            if (!this.datatype.equals(other.getDatatype())) {
                return false;
            }
            if (this.getLanguage().isPresent() && other.getLanguage().isPresent()) {
                return this.getLanguage().get().equalsIgnoreCase(other.getLanguage().get());
            }
            return !this.getLanguage().isPresent() && !other.getLanguage().isPresent();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.label.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.label.length() * 2);
        sb.append('\"');
        sb.append(this.label);
        sb.append('\"');
        if (Literals.isLanguageLiteral(this)) {
            sb.append('@');
            sb.append(this.language);
        } else {
            sb.append("^^<");
            sb.append(this.datatype.toString());
            sb.append(">");
        }
        return sb.toString();
    }

    @Override
    public String stringValue() {
        return this.label;
    }

    @Override
    public boolean booleanValue() {
        return XMLDatatypeUtil.parseBoolean(this.getLabel());
    }

    @Override
    public byte byteValue() {
        return XMLDatatypeUtil.parseByte(this.getLabel());
    }

    @Override
    public short shortValue() {
        return XMLDatatypeUtil.parseShort(this.getLabel());
    }

    @Override
    public int intValue() {
        return XMLDatatypeUtil.parseInt(this.getLabel());
    }

    @Override
    public long longValue() {
        return XMLDatatypeUtil.parseLong(this.getLabel());
    }

    @Override
    public float floatValue() {
        return XMLDatatypeUtil.parseFloat(this.getLabel());
    }

    @Override
    public double doubleValue() {
        return XMLDatatypeUtil.parseDouble(this.getLabel());
    }

    @Override
    public BigInteger integerValue() {
        return XMLDatatypeUtil.parseInteger(this.getLabel());
    }

    @Override
    public BigDecimal decimalValue() {
        return XMLDatatypeUtil.parseDecimal(this.getLabel());
    }

    @Override
    public XMLGregorianCalendar calendarValue() {
        return XMLDatatypeUtil.parseCalendar(this.getLabel());
    }
}

