/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.BNode;
import org.openrdf.model.IRI;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.impl.BooleanLiteral;
import org.openrdf.model.impl.ContextStatement;
import org.openrdf.model.impl.DecimalLiteral;
import org.openrdf.model.impl.IntegerLiteral;
import org.openrdf.model.impl.NumericLiteral;
import org.openrdf.model.impl.SimpleBNode;
import org.openrdf.model.impl.SimpleIRI;
import org.openrdf.model.impl.SimpleLiteral;
import org.openrdf.model.impl.SimpleStatement;
import org.openrdf.model.vocabulary.XMLSchema;

public abstract class AbstractValueFactory
implements ValueFactory {
    private static long lastBNodePrefixUID = 0L;
    private static final DatatypeFactory datatypeFactory;
    private int nextBNodeID;
    private String bnodePrefix;

    private static synchronized long getNextBNodePrefixUid() {
        lastBNodePrefixUID = Math.max(System.currentTimeMillis(), lastBNodePrefixUID + 1L);
        return lastBNodePrefixUID;
    }

    public AbstractValueFactory() {
        this.initBNodeParams();
    }

    @Override
    public IRI createIRI(String iri) {
        return new SimpleIRI(iri);
    }

    @Override
    public IRI createIRI(String namespace, String localName) {
        return this.createIRI(namespace + localName);
    }

    @Override
    public BNode createBNode(String nodeID) {
        return new SimpleBNode(nodeID);
    }

    @Override
    public Literal createLiteral(String value) {
        return new SimpleLiteral(value, XMLSchema.STRING);
    }

    @Override
    public Literal createLiteral(String value, String language) {
        return new SimpleLiteral(value, language);
    }

    @Override
    public Literal createLiteral(boolean b) {
        return b ? BooleanLiteral.TRUE : BooleanLiteral.FALSE;
    }

    @Override
    public Literal createLiteral(String value, IRI datatype) {
        return new SimpleLiteral(value, datatype);
    }

    @Override
    public Statement createStatement(Resource subject, IRI predicate, Value object) {
        return new SimpleStatement(subject, predicate, object);
    }

    @Override
    public Statement createStatement(Resource subject, IRI predicate, Value object, Resource context) {
        return new ContextStatement(subject, predicate, object, context);
    }

    protected void initBNodeParams() {
        this.bnodePrefix = "node" + Long.toString(AbstractValueFactory.getNextBNodePrefixUid(), 32) + "x";
        this.nextBNodeID = 1;
    }

    @Override
    public synchronized BNode createBNode() {
        int id = this.nextBNodeID++;
        BNode result = this.createBNode(this.bnodePrefix + id);
        if (id == Integer.MAX_VALUE) {
            this.initBNodeParams();
        }
        return result;
    }

    @Override
    public Literal createLiteral(byte value) {
        return this.createIntegerLiteral(value, XMLSchema.BYTE);
    }

    @Override
    public Literal createLiteral(short value) {
        return this.createIntegerLiteral(value, XMLSchema.SHORT);
    }

    @Override
    public Literal createLiteral(int value) {
        return this.createIntegerLiteral(value, XMLSchema.INT);
    }

    @Override
    public Literal createLiteral(long value) {
        return this.createIntegerLiteral(value, XMLSchema.LONG);
    }

    protected Literal createIntegerLiteral(Number value, IRI datatype) {
        return this.createNumericLiteral(value, datatype);
    }

    @Override
    public Literal createLiteral(float value) {
        return this.createFPLiteral(Float.valueOf(value), XMLSchema.FLOAT);
    }

    @Override
    public Literal createLiteral(double value) {
        return this.createFPLiteral(value, XMLSchema.DOUBLE);
    }

    @Override
    public Literal createLiteral(BigInteger bigInteger) {
        return this.createIntegerLiteral(bigInteger, XMLSchema.INTEGER);
    }

    @Override
    public Literal createLiteral(BigDecimal bigDecimal) {
        return this.createNumericLiteral(bigDecimal, XMLSchema.DECIMAL);
    }

    protected Literal createFPLiteral(Number value, IRI datatype) {
        return this.createNumericLiteral(value, datatype);
    }

    protected Literal createNumericLiteral(Number number, IRI datatype) {
        if (number instanceof BigDecimal) {
            return new DecimalLiteral((BigDecimal)number, datatype);
        }
        if (number instanceof BigInteger) {
            return new IntegerLiteral((BigInteger)number, datatype);
        }
        return new NumericLiteral(number, datatype);
    }

    @Override
    public Literal createLiteral(XMLGregorianCalendar calendar) {
        return this.createLiteral(calendar.toXMLFormat(), XMLDatatypeUtil.qnameToURI(calendar.getXMLSchemaType()));
    }

    @Override
    public Literal createLiteral(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        XMLGregorianCalendar xmlGregCalendar = datatypeFactory.newXMLGregorianCalendar(c);
        return this.createLiteral(xmlGregCalendar);
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new Error("Could not instantiate javax.xml.datatype.DatatypeFactory", e);
        }
    }
}

