/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.openrdf.model.BNode;
import org.openrdf.model.IRI;
import org.openrdf.model.Literal;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.util.ModelException;
import org.openrdf.util.iterators.Iterators;

public class Models {
    protected Models() {
    }

    public static Optional<Value> object(Model m) {
        return m.stream().map(st -> st.getObject()).findAny();
    }

    @Deprecated
    public static Value anyObject(Model m) {
        return Models.object(m).orElse(null);
    }

    public static Optional<Literal> objectLiteral(Model m) {
        return m.stream().map(st -> st.getObject()).filter(o -> o instanceof Literal).map(l -> (Literal)l).findAny();
    }

    @Deprecated
    public static Literal anyObjectLiteral(Model m) {
        return Models.objectLiteral(m).orElse(null);
    }

    public static Optional<Resource> objectResource(Model m) {
        return m.stream().map(st -> st.getObject()).filter(o -> o instanceof Resource).map(r -> (Resource)r).findAny();
    }

    @Deprecated
    public static Resource anyObjectResource(Model m) {
        return Models.objectResource(m).orElse(null);
    }

    public static Optional<IRI> objectIRI(Model m) {
        return m.stream().map(st -> st.getObject()).filter(o -> o instanceof IRI).map(r -> (IRI)r).findAny();
    }

    public static Optional<String> objectString(Model m) {
        return m.stream().map(st -> st.getObject().stringValue()).findAny();
    }

    @Deprecated
    public static URI anyObjectURI(Model m) {
        return Models.objectIRI(m).orElse(null);
    }

    public static Optional<Resource> subject(Model m) {
        return m.stream().map(st -> st.getSubject()).findAny();
    }

    @Deprecated
    public static Resource anySubject(Model m) {
        return Models.subject(m).orElse(null);
    }

    public static Optional<IRI> subjectIRI(Model m) {
        return m.stream().map(st -> st.getSubject()).filter(s -> s instanceof IRI).map(s -> (IRI)s).findAny();
    }

    @Deprecated
    public static URI anySubjectURI(Model m) {
        return Models.subjectIRI(m).orElse(null);
    }

    public static Optional<BNode> subjectBNode(Model m) {
        return m.stream().map(st -> st.getSubject()).filter(s -> s instanceof BNode).map(s -> (BNode)s).findAny();
    }

    @Deprecated
    public static BNode anySubjectBNode(Model m) {
        return Models.subjectBNode(m).orElse(null);
    }

    public static Optional<IRI> predicate(Model m) {
        return m.stream().map(st -> st.getPredicate()).findAny();
    }

    @Deprecated
    public static URI anyPredicate(Model m) {
        return Models.predicate(m).orElse(null);
    }

    public static Model setProperty(Model m, Resource subject, IRI property, Value value, Resource ... contexts) {
        Objects.requireNonNull(m, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        Objects.requireNonNull(value, "value may not be null");
        if (m.contains(subject, property, null, contexts)) {
            m.remove(subject, property, null, contexts);
        }
        m.add(subject, property, value, contexts);
        return m;
    }

    public static boolean isomorphic(Iterable<? extends Statement> model1, Iterable<? extends Statement> model2) {
        Set<? extends Statement> set1 = Models.toSet(model1);
        Set<? extends Statement> set2 = Models.toSet(model2);
        if (set1.size() != set2.size()) {
            return false;
        }
        return Models.isSubsetInternal(set1, set2);
    }

    @Deprecated
    public static boolean equals(Iterable<? extends Statement> model1, Iterable<? extends Statement> model2) {
        return Models.isomorphic(model1, model2);
    }

    public static boolean isSubset(Iterable<? extends Statement> model1, Iterable<? extends Statement> model2) {
        Set<? extends Statement> set1 = Models.toSet(model1);
        Set<? extends Statement> set2 = Models.toSet(model2);
        return Models.isSubset(set1, set2);
    }

    public static boolean isSubset(Set<? extends Statement> model1, Set<? extends Statement> model2) {
        if (model1.size() > model2.size()) {
            return false;
        }
        return Models.isSubsetInternal(model1, model2);
    }

    private static boolean isSubsetInternal(Set<? extends Statement> model1, Set<? extends Statement> model2) {
        return Models.matchModels(model1, model2);
    }

    private static boolean matchModels(Set<? extends Statement> model1, Set<? extends Statement> model2) {
        ArrayList<Statement> model1BNodes = new ArrayList<Statement>(model1.size());
        for (Statement statement : model1) {
            if (statement.getSubject() instanceof BNode || statement.getObject() instanceof BNode || statement.getContext() instanceof BNode) {
                model1BNodes.add(statement);
                continue;
            }
            if (model2.contains(statement)) continue;
            return false;
        }
        return Models.matchModels(model1BNodes, model2, new HashMap<BNode, BNode>(), 0);
    }

    private static boolean matchModels(List<? extends Statement> model1, Iterable<? extends Statement> model2, Map<BNode, BNode> bNodeMapping, int idx) {
        boolean result = false;
        if (idx < model1.size()) {
            Statement st1 = model1.get(idx);
            List<Statement> matchingStats = Models.findMatchingStatements(st1, model2, bNodeMapping);
            for (Statement st2 : matchingStats) {
                HashMap<BNode, BNode> newBNodeMapping = new HashMap<BNode, BNode>(bNodeMapping);
                if (st1.getSubject() instanceof BNode && st2.getSubject() instanceof BNode) {
                    newBNodeMapping.put((BNode)st1.getSubject(), (BNode)st2.getSubject());
                }
                if (st1.getObject() instanceof BNode && st2.getObject() instanceof BNode) {
                    newBNodeMapping.put((BNode)st1.getObject(), (BNode)st2.getObject());
                }
                if (st1.getContext() instanceof BNode && st2.getContext() instanceof BNode) {
                    newBNodeMapping.put((BNode)st1.getContext(), (BNode)st2.getContext());
                }
                if (!(result = Models.matchModels(model1, model2, newBNodeMapping, idx + 1))) continue;
                break;
            }
        } else {
            result = true;
        }
        return result;
    }

    private static List<Statement> findMatchingStatements(Statement st, Iterable<? extends Statement> model, Map<BNode, BNode> bNodeMapping) {
        ArrayList<Statement> result = new ArrayList<Statement>();
        for (Statement statement : model) {
            if (!Models.statementsMatch(st, statement, bNodeMapping)) continue;
            result.add(statement);
        }
        return result;
    }

    private static boolean statementsMatch(Statement st1, Statement st2, Map<BNode, BNode> bNodeMapping) {
        BNode mappedBNode;
        BNode mappedBNode2;
        BNode mappedBNode3;
        IRI pred2;
        IRI pred1 = st1.getPredicate();
        if (!pred1.equals(pred2 = st2.getPredicate())) {
            return false;
        }
        Resource subj1 = st1.getSubject();
        Resource subj2 = st2.getSubject();
        if (subj1 instanceof BNode && subj2 instanceof BNode ? ((mappedBNode3 = bNodeMapping.get(subj1)) != null ? !subj2.equals(mappedBNode3) : bNodeMapping.containsValue(subj2)) : !subj1.equals(subj2)) {
            return false;
        }
        Value obj1 = st1.getObject();
        Value obj2 = st2.getObject();
        if (obj1 instanceof BNode && obj2 instanceof BNode ? ((mappedBNode2 = bNodeMapping.get(obj1)) != null ? !obj2.equals(mappedBNode2) : bNodeMapping.containsValue(obj2)) : !obj1.equals(obj2)) {
            return false;
        }
        Resource context1 = st1.getContext();
        Resource context2 = st2.getContext();
        if (context1 == null) {
            return context2 == null;
        }
        if (context2 == null) {
            return false;
        }
        return !(context1 instanceof BNode && context2 instanceof BNode ? ((mappedBNode = bNodeMapping.get(context1)) != null ? !context2.equals(mappedBNode) : bNodeMapping.containsValue(context2)) : !context1.equals(context1));
    }

    private static <S extends Statement> Set<S> toSet(Iterable<S> iterable) {
        HashSet set = null;
        if (iterable instanceof Set) {
            set = (HashSet)iterable;
        } else {
            set = new HashSet();
            Iterators.addAll(iterable.iterator(), set);
        }
        return set;
    }

    public static Supplier<ModelException> modelException(String message) {
        return () -> new ModelException(message);
    }
}

