/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.util;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import org.openrdf.OpenRDFUtil;
import org.openrdf.model.IRI;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;

public class Statements {
    public static void consume(ValueFactory vf, Resource subject, IRI predicate, Value object, Consumer<Statement> consumer, Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull(contexts);
        Objects.requireNonNull(consumer);
        if (contexts.length > 0) {
            for (Resource context : contexts) {
                consumer.accept(vf.createStatement(subject, predicate, object, context));
            }
        } else {
            consumer.accept(vf.createStatement(subject, predicate, object));
        }
    }

    public static <C extends Collection<Statement>> C create(ValueFactory vf, Resource subject, IRI predicate, Value object, C collection, Resource ... contexts) {
        Objects.requireNonNull(collection);
        Statements.consume(vf, subject, predicate, object, st -> collection.add(st), contexts);
        return collection;
    }
}

