/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.federation;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.SingletonIteration;
import java.util.Collection;
import java.util.Set;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.Service;
import org.openrdf.query.algebra.evaluation.federation.FederatedService;
import org.openrdf.query.algebra.evaluation.federation.JoinExecutorBase;
import org.openrdf.query.algebra.evaluation.iterator.SilentIteration;
import org.openrdf.query.impl.EmptyBindingSet;

public class ServiceFallbackIteration
extends JoinExecutorBase<BindingSet> {
    protected final Service service;
    protected final Set<String> projectionVars;
    protected final FederatedService federatedService;
    protected final Collection<BindingSet> bindings;

    public ServiceFallbackIteration(Service service, Set<String> projectionVars, Collection<BindingSet> bindings, FederatedService federatedService) throws QueryEvaluationException {
        super(null, null, EmptyBindingSet.getInstance());
        this.service = service;
        this.projectionVars = projectionVars;
        this.bindings = bindings;
        this.federatedService = federatedService;
        this.run();
    }

    @Override
    protected void handleBindings() throws Exception {
        for (BindingSet b : this.bindings) {
            try {
                CloseableIteration result = this.federatedService.select(this.service, this.projectionVars, b, this.service.getBaseURI());
                result = this.service.isSilent() ? new SilentIteration((CloseableIteration<BindingSet, QueryEvaluationException>)result) : result;
                this.addResult(result);
            }
            catch (QueryEvaluationException e) {
                if (this.service.isSilent()) {
                    this.addResult(new SingletonIteration((Object)b));
                    continue;
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (this.service.isSilent()) {
                    this.addResult(new SingletonIteration((Object)b));
                    continue;
                }
                throw e;
            }
        }
    }
}

