/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.CloseableIteratorIteration;
import info.aduna.iteration.ConvertingIteration;
import info.aduna.iteration.DelayedIteration;
import info.aduna.iteration.DistinctIteration;
import info.aduna.iteration.EmptyIteration;
import info.aduna.iteration.FilterIteration;
import info.aduna.iteration.IntersectIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.LimitIteration;
import info.aduna.iteration.LookAheadIteration;
import info.aduna.iteration.OffsetIteration;
import info.aduna.iteration.ReducedIteration;
import info.aduna.iteration.SingletonIteration;
import info.aduna.iteration.UnionIteration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.impl.BooleanLiteralImpl;
import org.openrdf.model.util.URIUtil;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.SESAME;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.And;
import org.openrdf.query.algebra.ArbitraryLengthPath;
import org.openrdf.query.algebra.BNodeGenerator;
import org.openrdf.query.algebra.BinaryTupleOperator;
import org.openrdf.query.algebra.BindingSetAssignment;
import org.openrdf.query.algebra.Bound;
import org.openrdf.query.algebra.Coalesce;
import org.openrdf.query.algebra.Compare;
import org.openrdf.query.algebra.CompareAll;
import org.openrdf.query.algebra.CompareAny;
import org.openrdf.query.algebra.Datatype;
import org.openrdf.query.algebra.DescribeOperator;
import org.openrdf.query.algebra.Difference;
import org.openrdf.query.algebra.Distinct;
import org.openrdf.query.algebra.EmptySet;
import org.openrdf.query.algebra.Exists;
import org.openrdf.query.algebra.Extension;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.FunctionCall;
import org.openrdf.query.algebra.Group;
import org.openrdf.query.algebra.IRIFunction;
import org.openrdf.query.algebra.If;
import org.openrdf.query.algebra.In;
import org.openrdf.query.algebra.Intersection;
import org.openrdf.query.algebra.IsBNode;
import org.openrdf.query.algebra.IsLiteral;
import org.openrdf.query.algebra.IsNumeric;
import org.openrdf.query.algebra.IsResource;
import org.openrdf.query.algebra.IsURI;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.Label;
import org.openrdf.query.algebra.Lang;
import org.openrdf.query.algebra.LangMatches;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.Like;
import org.openrdf.query.algebra.ListMemberOperator;
import org.openrdf.query.algebra.LocalName;
import org.openrdf.query.algebra.MathExpr;
import org.openrdf.query.algebra.MultiProjection;
import org.openrdf.query.algebra.Namespace;
import org.openrdf.query.algebra.Not;
import org.openrdf.query.algebra.Or;
import org.openrdf.query.algebra.Order;
import org.openrdf.query.algebra.Projection;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.QueryRoot;
import org.openrdf.query.algebra.Reduced;
import org.openrdf.query.algebra.Regex;
import org.openrdf.query.algebra.SameTerm;
import org.openrdf.query.algebra.Service;
import org.openrdf.query.algebra.SingletonSet;
import org.openrdf.query.algebra.Slice;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.Str;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UnaryTupleOperator;
import org.openrdf.query.algebra.Union;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.ZeroLengthPath;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.federation.FederatedService;
import org.openrdf.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.openrdf.query.algebra.evaluation.federation.ServiceJoinIterator;
import org.openrdf.query.algebra.evaluation.function.Function;
import org.openrdf.query.algebra.evaluation.function.FunctionRegistry;
import org.openrdf.query.algebra.evaluation.function.datetime.Now;
import org.openrdf.query.algebra.evaluation.impl.ExternalSet;
import org.openrdf.query.algebra.evaluation.iterator.BadlyDesignedLeftJoinIterator;
import org.openrdf.query.algebra.evaluation.iterator.DescribeIteration;
import org.openrdf.query.algebra.evaluation.iterator.ExtensionIterator;
import org.openrdf.query.algebra.evaluation.iterator.FilterIterator;
import org.openrdf.query.algebra.evaluation.iterator.GroupIterator;
import org.openrdf.query.algebra.evaluation.iterator.HashJoinIteration;
import org.openrdf.query.algebra.evaluation.iterator.JoinIterator;
import org.openrdf.query.algebra.evaluation.iterator.LeftJoinIterator;
import org.openrdf.query.algebra.evaluation.iterator.MultiProjectionIterator;
import org.openrdf.query.algebra.evaluation.iterator.OrderIterator;
import org.openrdf.query.algebra.evaluation.iterator.PathIteration;
import org.openrdf.query.algebra.evaluation.iterator.ProjectionIterator;
import org.openrdf.query.algebra.evaluation.iterator.SPARQLMinusIteration;
import org.openrdf.query.algebra.evaluation.iterator.SilentIteration;
import org.openrdf.query.algebra.evaluation.iterator.ZeroLengthPathIteration;
import org.openrdf.query.algebra.evaluation.util.EvaluationStrategies;
import org.openrdf.query.algebra.evaluation.util.MathUtil;
import org.openrdf.query.algebra.evaluation.util.OrderComparator;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;
import org.openrdf.query.algebra.evaluation.util.ValueComparator;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.query.algebra.helpers.TupleExprs;
import org.openrdf.query.algebra.helpers.VarNameCollector;
import org.openrdf.query.impl.MapBindingSet;

public class EvaluationStrategyImpl
implements EvaluationStrategy {
    protected final TripleSource tripleSource;
    protected final Dataset dataset;
    protected final FederatedServiceResolver serviceResolver;
    private Value sharedValueOfNow;
    private final long iterationCacheSyncThreshold;

    public EvaluationStrategyImpl(TripleSource tripleSource, FederatedServiceResolver serviceResolver) {
        this(tripleSource, null, serviceResolver);
    }

    public EvaluationStrategyImpl(TripleSource tripleSource, Dataset dataset, FederatedServiceResolver serviceResolver) {
        this(tripleSource, dataset, serviceResolver, 0L);
    }

    public EvaluationStrategyImpl(TripleSource tripleSource, Dataset dataset, FederatedServiceResolver serviceResolver, long iterationCacheSyncTreshold) {
        this.tripleSource = tripleSource;
        this.dataset = dataset;
        this.serviceResolver = serviceResolver;
        this.iterationCacheSyncThreshold = iterationCacheSyncTreshold;
        EvaluationStrategies.register(this);
    }

    @Override
    public FederatedService getService(String serviceUrl) throws QueryEvaluationException {
        return this.serviceResolver.getService(serviceUrl);
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(TupleExpr expr, BindingSet bindings) throws QueryEvaluationException {
        if (expr instanceof StatementPattern) {
            return this.evaluate((StatementPattern)expr, bindings);
        }
        if (expr instanceof UnaryTupleOperator) {
            return this.evaluate((UnaryTupleOperator)expr, bindings);
        }
        if (expr instanceof BinaryTupleOperator) {
            return this.evaluate((BinaryTupleOperator)expr, bindings);
        }
        if (expr instanceof SingletonSet) {
            return this.evaluate((SingletonSet)expr, bindings);
        }
        if (expr instanceof EmptySet) {
            return this.evaluate((EmptySet)expr, bindings);
        }
        if (expr instanceof ExternalSet) {
            return this.evaluate((ExternalSet)expr, bindings);
        }
        if (expr instanceof ZeroLengthPath) {
            return this.evaluate((ZeroLengthPath)expr, bindings);
        }
        if (expr instanceof ArbitraryLengthPath) {
            return this.evaluate((ArbitraryLengthPath)expr, bindings);
        }
        if (expr instanceof BindingSetAssignment) {
            return this.evaluate((BindingSetAssignment)expr, bindings);
        }
        if (expr == null) {
            throw new IllegalArgumentException("expr must not be null");
        }
        throw new QueryEvaluationException("Unsupported tuple expr type: " + expr.getClass());
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(ArbitraryLengthPath alp, BindingSet bindings) throws QueryEvaluationException {
        StatementPattern.Scope scope = alp.getScope();
        Var subjectVar = alp.getSubjectVar();
        TupleExpr pathExpression = alp.getPathExpression();
        Var objVar = alp.getObjectVar();
        Var contextVar = alp.getContextVar();
        long minLength = alp.getMinLength();
        return new PathIteration(this, scope, subjectVar, pathExpression, objVar, contextVar, minLength, bindings);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(ZeroLengthPath zlp, BindingSet bindings) throws QueryEvaluationException {
        Var subjectVar = zlp.getSubjectVar();
        Var objVar = zlp.getObjectVar();
        Var contextVar = zlp.getContextVar();
        Value subj = null;
        try {
            subj = this.evaluate(subjectVar, bindings);
        }
        catch (QueryEvaluationException queryEvaluationException) {
            // empty catch block
        }
        Value obj = null;
        try {
            obj = this.evaluate(objVar, bindings);
        }
        catch (QueryEvaluationException queryEvaluationException) {
            // empty catch block
        }
        if (subj != null && obj != null && !subj.equals(obj)) {
            return new EmptyIteration();
        }
        return this.getZeroLengthPathIterator(bindings, subjectVar, objVar, contextVar, subj, obj);
    }

    protected ZeroLengthPathIteration getZeroLengthPathIterator(BindingSet bindings, Var subjectVar, Var objVar, Var contextVar, Value subj, Value obj) {
        return new ZeroLengthPathIteration(this, subjectVar, objVar, subj, obj, contextVar, bindings);
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Service service, String serviceUri, CloseableIteration<BindingSet, QueryEvaluationException> bindings) throws QueryEvaluationException {
        try {
            FederatedService fs = this.serviceResolver.getService(serviceUri);
            return fs.evaluate(service, bindings, service.getBaseURI());
        }
        catch (QueryEvaluationException e) {
            if (service.isSilent()) {
                return bindings;
            }
            throw new QueryEvaluationException((Throwable)e);
        }
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Service service, BindingSet bindings) throws QueryEvaluationException {
        String serviceUri;
        Var serviceRef = service.getServiceRef();
        if (serviceRef.hasValue()) {
            serviceUri = serviceRef.getValue().stringValue();
        } else if (bindings != null && bindings.hasBinding(serviceRef.getName())) {
            serviceUri = bindings.getBinding(serviceRef.getName()).getValue().stringValue();
        } else {
            throw new QueryEvaluationException("SERVICE variables must be bound at evaluation time.");
        }
        try {
            FederatedService fs = this.serviceResolver.getService(serviceUri);
            HashSet freeVars = new HashSet(service.getServiceVars());
            freeVars.removeAll(bindings.getBindingNames());
            MapBindingSet allBindings = new MapBindingSet();
            for (Object binding : bindings) {
                allBindings.addBinding(binding.getName(), binding.getValue());
            }
            Set<Var> boundVars = this.getBoundVariables(service);
            for (Var boundVar : boundVars) {
                freeVars.remove(boundVar.getName());
                allBindings.addBinding(boundVar.getName(), boundVar.getValue());
            }
            bindings = allBindings;
            String baseUri = service.getBaseURI();
            if (freeVars.size() == 0) {
                boolean exists = fs.ask(service, bindings, baseUri);
                if (exists) {
                    return new SingletonIteration((Object)bindings);
                }
                return new EmptyIteration();
            }
            CloseableIteration result = fs.select(service, freeVars, bindings, baseUri);
            if (service.isSilent()) {
                return new SilentIteration((CloseableIteration<BindingSet, QueryEvaluationException>)result);
            }
            return result;
        }
        catch (QueryEvaluationException e) {
            if (service.isSilent()) {
                return new SingletonIteration((Object)bindings);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (service.isSilent()) {
                return new SingletonIteration((Object)bindings);
            }
            throw e;
        }
    }

    private Set<Var> getBoundVariables(Service service) {
        BoundVarVisitor visitor = new BoundVarVisitor();
        visitor.meet(service);
        return visitor.boundVars;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(DescribeOperator operator, BindingSet bindings) throws QueryEvaluationException {
        CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluate(operator.getArg(), bindings);
        return new DescribeIteration((Iteration<BindingSet, QueryEvaluationException>)iter, this, operator.getBindingNames(), bindings);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(StatementPattern sp, final BindingSet bindings) throws QueryEvaluationException {
        void var11_14;
        final Var subjVar = sp.getSubjectVar();
        final Var predVar = sp.getPredicateVar();
        final Var objVar = sp.getObjectVar();
        final Var conVar = sp.getContextVar();
        final Value subjValue = this.getVarValue(subjVar, bindings);
        final Value predValue = this.getVarValue(predVar, bindings);
        final Value objValue = this.getVarValue(objVar, bindings);
        Value contextValue = this.getVarValue(conVar, bindings);
        Object var11_11 = null;
        try {
            Resource[] contexts;
            Set graphs = null;
            boolean emptyGraph = false;
            if (this.dataset != null) {
                if (sp.getScope() == StatementPattern.Scope.DEFAULT_CONTEXTS) {
                    graphs = this.dataset.getDefaultGraphs();
                    emptyGraph = graphs.isEmpty() && !this.dataset.getNamedGraphs().isEmpty();
                } else {
                    graphs = this.dataset.getNamedGraphs();
                    boolean bl = emptyGraph = graphs.isEmpty() && !this.dataset.getDefaultGraphs().isEmpty();
                }
            }
            if (emptyGraph) {
                return new EmptyIteration();
            }
            if (graphs == null || graphs.isEmpty()) {
                contexts = contextValue != null ? new Resource[]{(Resource)contextValue} : new Resource[]{};
            } else if (contextValue != null) {
                if (!graphs.contains(contextValue)) return new EmptyIteration();
                contexts = new Resource[]{(Resource)contextValue};
            } else {
                contexts = new Resource[graphs.size()];
                int i = 0;
                for (URI graph : graphs) {
                    URI context = null;
                    if (!SESAME.NIL.equals((Object)graph)) {
                        context = graph;
                    }
                    contexts[i++] = context;
                }
            }
            CloseableIteration<? extends Statement, QueryEvaluationException> closeableIteration = this.tripleSource.getStatements((Resource)subjValue, (URI)predValue, objValue, contexts);
            if (contexts.length == 0 && sp.getScope() == StatementPattern.Scope.NAMED_CONTEXTS) {
                FilterIteration<Statement, QueryEvaluationException> filterIteration = new FilterIteration<Statement, QueryEvaluationException>(closeableIteration){

                    protected boolean accept(Statement st) {
                        return st.getContext() != null;
                    }
                };
            }
        }
        catch (ClassCastException e) {
            return new EmptyIteration();
        }
        FilterIteration<Statement, QueryEvaluationException> filterIteration = new FilterIteration<Statement, QueryEvaluationException>((Iteration)var11_14){

            protected boolean accept(Statement st) {
                Resource subj = st.getSubject();
                URI pred = st.getPredicate();
                Value obj = st.getObject();
                Resource context = st.getContext();
                if (subjVar != null && subjValue == null) {
                    if (subjVar.equals((Object)predVar) && !subj.equals(pred)) {
                        return false;
                    }
                    if (subjVar.equals((Object)objVar) && !subj.equals(obj)) {
                        return false;
                    }
                    if (subjVar.equals((Object)conVar) && !subj.equals(context)) {
                        return false;
                    }
                }
                if (predVar != null && predValue == null) {
                    if (predVar.equals((Object)objVar) && !pred.equals((Object)obj)) {
                        return false;
                    }
                    if (predVar.equals((Object)conVar) && !pred.equals((Object)context)) {
                        return false;
                    }
                }
                return objVar == null || objValue != null || !objVar.equals((Object)conVar) || obj.equals(context);
            }
        };
        return new ConvertingIteration<Statement, BindingSet, QueryEvaluationException>((Iteration)filterIteration){

            protected BindingSet convert(Statement st) {
                QueryBindingSet result = new QueryBindingSet(bindings);
                if (subjVar != null && !subjVar.isConstant() && !result.hasBinding(subjVar.getName())) {
                    result.addBinding(subjVar.getName(), (Value)st.getSubject());
                }
                if (predVar != null && !predVar.isConstant() && !result.hasBinding(predVar.getName())) {
                    result.addBinding(predVar.getName(), (Value)st.getPredicate());
                }
                if (objVar != null && !objVar.isConstant() && !result.hasBinding(objVar.getName())) {
                    result.addBinding(objVar.getName(), st.getObject());
                }
                if (conVar != null && !conVar.isConstant() && !result.hasBinding(conVar.getName()) && st.getContext() != null) {
                    result.addBinding(conVar.getName(), (Value)st.getContext());
                }
                return result;
            }
        };
    }

    protected Value getVarValue(Var var, BindingSet bindings) {
        if (var == null) {
            return null;
        }
        if (var.hasValue()) {
            return var.getValue();
        }
        return bindings.getValue(var.getName());
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(UnaryTupleOperator expr, BindingSet bindings) throws QueryEvaluationException {
        if (expr instanceof Projection) {
            return this.evaluate((Projection)expr, bindings);
        }
        if (expr instanceof MultiProjection) {
            return this.evaluate((MultiProjection)expr, bindings);
        }
        if (expr instanceof Filter) {
            return this.evaluate((Filter)expr, bindings);
        }
        if (expr instanceof Service) {
            return this.evaluate((Service)expr, bindings);
        }
        if (expr instanceof Slice) {
            return this.evaluate((Slice)expr, bindings);
        }
        if (expr instanceof Extension) {
            return this.evaluate((Extension)expr, bindings);
        }
        if (expr instanceof Distinct) {
            return this.evaluate((Distinct)expr, bindings);
        }
        if (expr instanceof Reduced) {
            return this.evaluate((Reduced)expr, bindings);
        }
        if (expr instanceof Group) {
            return this.evaluate((Group)expr, bindings);
        }
        if (expr instanceof Order) {
            return this.evaluate((Order)expr, bindings);
        }
        if (expr instanceof QueryRoot) {
            this.sharedValueOfNow = null;
            return this.evaluate(((QueryRoot)expr).getArg(), bindings);
        }
        if (expr instanceof DescribeOperator) {
            return this.evaluate((DescribeOperator)expr, bindings);
        }
        if (expr == null) {
            throw new IllegalArgumentException("expr must not be null");
        }
        throw new QueryEvaluationException("Unknown unary tuple operator type: " + expr.getClass());
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSetAssignment bsa, BindingSet bindings) throws QueryEvaluationException {
        final Iterator iter = bsa.getBindingSets().iterator();
        if (bindings.size() == 0) {
            return new CloseableIteratorIteration(iter);
        }
        final QueryBindingSet b = new QueryBindingSet(bindings);
        LookAheadIteration<BindingSet, QueryEvaluationException> result = new LookAheadIteration<BindingSet, QueryEvaluationException>(){

            protected BindingSet getNextElement() throws QueryEvaluationException {
                QueryBindingSet result = null;
                block0: while (result == null && iter.hasNext()) {
                    BindingSet assignedBindings = (BindingSet)iter.next();
                    for (String name : assignedBindings.getBindingNames()) {
                        Value assignedValue = assignedBindings.getValue(name);
                        if (assignedValue == null) continue;
                        Value bValue = b.getValue(name);
                        if (bValue == null || assignedValue.equals(bValue)) {
                            if (result == null) {
                                result = new QueryBindingSet(b);
                            }
                            if (bValue != null) continue;
                            result.addBinding(name, assignedValue);
                            continue;
                        }
                        result = null;
                        continue block0;
                    }
                }
                return result;
            }
        };
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Projection projection, BindingSet bindings) throws QueryEvaluationException {
        Object result = this.evaluate(projection.getArg(), bindings);
        result = new ProjectionIterator(projection, (CloseableIteration<BindingSet, QueryEvaluationException>)result, bindings);
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(MultiProjection multiProjection, BindingSet bindings) throws QueryEvaluationException {
        Object result = this.evaluate(multiProjection.getArg(), bindings);
        result = new MultiProjectionIterator(multiProjection, (CloseableIteration<BindingSet, QueryEvaluationException>)result, bindings);
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Filter filter, BindingSet bindings) throws QueryEvaluationException {
        Object result = this.evaluate(filter.getArg(), bindings);
        result = new FilterIterator(filter, (CloseableIteration<BindingSet, QueryEvaluationException>)result, this);
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Slice slice, BindingSet bindings) throws QueryEvaluationException {
        OffsetIteration result = this.evaluate(slice.getArg(), bindings);
        if (slice.hasOffset()) {
            result = new OffsetIteration(result, slice.getOffset());
        }
        if (slice.hasLimit()) {
            result = new LimitIteration((Iteration)result, slice.getLimit());
        }
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Extension extension, BindingSet bindings) throws QueryEvaluationException {
        Object result;
        try {
            result = this.evaluate(extension.getArg(), bindings);
        }
        catch (ValueExprEvaluationException e) {
            result = new EmptyIteration();
        }
        result = new ExtensionIterator(extension, (CloseableIteration<BindingSet, QueryEvaluationException>)result, this);
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Distinct distinct, BindingSet bindings) throws QueryEvaluationException {
        return new DistinctIteration(this.evaluate(distinct.getArg(), bindings));
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Reduced reduced, BindingSet bindings) throws QueryEvaluationException {
        return new ReducedIteration(this.evaluate(reduced.getArg(), bindings));
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Group node, BindingSet bindings) throws QueryEvaluationException {
        return new GroupIterator(this, node, bindings, this.iterationCacheSyncThreshold);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Order node, BindingSet bindings) throws QueryEvaluationException {
        ValueComparator vcmp = new ValueComparator();
        OrderComparator cmp = new OrderComparator(this, node, vcmp);
        boolean reduced = this.isReducedOrDistinct((QueryModelNode)node);
        long limit = this.getLimit((QueryModelNode)node);
        return new OrderIterator(this.evaluate(node.getArg(), bindings), cmp, limit, reduced, this.iterationCacheSyncThreshold);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BinaryTupleOperator expr, BindingSet bindings) throws QueryEvaluationException {
        if (expr instanceof Join) {
            return this.evaluate((Join)expr, bindings);
        }
        if (expr instanceof LeftJoin) {
            return this.evaluate((LeftJoin)expr, bindings);
        }
        if (expr instanceof Union) {
            return this.evaluate((Union)expr, bindings);
        }
        if (expr instanceof Intersection) {
            return this.evaluate((Intersection)expr, bindings);
        }
        if (expr instanceof Difference) {
            return this.evaluate((Difference)expr, bindings);
        }
        if (expr == null) {
            throw new IllegalArgumentException("expr must not be null");
        }
        throw new QueryEvaluationException("Unsupported binary tuple operator type: " + expr.getClass());
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Join join, BindingSet bindings) throws QueryEvaluationException {
        if (join.getRightArg() instanceof Service) {
            CloseableIteration<BindingSet, QueryEvaluationException> leftIter = this.evaluate(join.getLeftArg(), bindings);
            return new ServiceJoinIterator(leftIter, (Service)join.getRightArg(), bindings, this);
        }
        if (TupleExprs.containsProjection((TupleExpr)join.getRightArg())) {
            return new HashJoinIteration((EvaluationStrategy)this, join, bindings);
        }
        return new JoinIterator(this, join, bindings);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(LeftJoin leftJoin, BindingSet bindings) throws QueryEvaluationException {
        VarNameCollector optionalVarCollector = new VarNameCollector();
        leftJoin.getRightArg().visit((QueryModelVisitor)optionalVarCollector);
        if (leftJoin.hasCondition()) {
            leftJoin.getCondition().visit((QueryModelVisitor)optionalVarCollector);
        }
        Set problemVars = optionalVarCollector.getVarNames();
        problemVars.removeAll(leftJoin.getLeftArg().getBindingNames());
        problemVars.retainAll(bindings.getBindingNames());
        if (problemVars.isEmpty()) {
            return new LeftJoinIterator(this, leftJoin, bindings);
        }
        return new BadlyDesignedLeftJoinIterator(this, leftJoin, bindings, problemVars);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(final Union union, final BindingSet bindings) throws QueryEvaluationException {
        DelayedIteration<BindingSet, QueryEvaluationException> leftArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return EvaluationStrategyImpl.this.evaluate(union.getLeftArg(), bindings);
            }
        };
        DelayedIteration<BindingSet, QueryEvaluationException> rightArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return EvaluationStrategyImpl.this.evaluate(union.getRightArg(), bindings);
            }
        };
        return new UnionIteration(new Iteration[]{leftArg, rightArg});
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(final Intersection intersection, final BindingSet bindings) throws QueryEvaluationException {
        DelayedIteration<BindingSet, QueryEvaluationException> leftArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return EvaluationStrategyImpl.this.evaluate(intersection.getLeftArg(), bindings);
            }
        };
        DelayedIteration<BindingSet, QueryEvaluationException> rightArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return EvaluationStrategyImpl.this.evaluate(intersection.getRightArg(), bindings);
            }
        };
        return new IntersectIteration((Iteration)leftArg, (Iteration)rightArg);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(final Difference difference, final BindingSet bindings) throws QueryEvaluationException {
        DelayedIteration<BindingSet, QueryEvaluationException> leftArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return EvaluationStrategyImpl.this.evaluate(difference.getLeftArg(), bindings);
            }
        };
        DelayedIteration<BindingSet, QueryEvaluationException> rightArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return EvaluationStrategyImpl.this.evaluate(difference.getRightArg(), bindings);
            }
        };
        return new SPARQLMinusIteration(leftArg, rightArg);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(SingletonSet singletonSet, BindingSet bindings) throws QueryEvaluationException {
        return new SingletonIteration((Object)bindings);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(EmptySet emptySet, BindingSet bindings) throws QueryEvaluationException {
        return new EmptyIteration();
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(ExternalSet external, BindingSet bindings) throws QueryEvaluationException {
        return external.evaluate(bindings);
    }

    @Override
    public Value evaluate(ValueExpr expr, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        if (expr instanceof Var) {
            return this.evaluate((Var)expr, bindings);
        }
        if (expr instanceof ValueConstant) {
            return this.evaluate((ValueConstant)expr, bindings);
        }
        if (expr instanceof BNodeGenerator) {
            return this.evaluate((BNodeGenerator)expr, bindings);
        }
        if (expr instanceof Bound) {
            return this.evaluate((Bound)expr, bindings);
        }
        if (expr instanceof Str) {
            return this.evaluate((Str)expr, bindings);
        }
        if (expr instanceof Label) {
            return this.evaluate((Label)expr, bindings);
        }
        if (expr instanceof Lang) {
            return this.evaluate((Lang)expr, bindings);
        }
        if (expr instanceof LangMatches) {
            return this.evaluate((LangMatches)expr, bindings);
        }
        if (expr instanceof Datatype) {
            return this.evaluate((Datatype)expr, bindings);
        }
        if (expr instanceof Namespace) {
            return this.evaluate((Namespace)expr, bindings);
        }
        if (expr instanceof LocalName) {
            return this.evaluate((LocalName)expr, bindings);
        }
        if (expr instanceof IsResource) {
            return this.evaluate((IsResource)expr, bindings);
        }
        if (expr instanceof IsURI) {
            return this.evaluate((IsURI)expr, bindings);
        }
        if (expr instanceof IsBNode) {
            return this.evaluate((IsBNode)expr, bindings);
        }
        if (expr instanceof IsLiteral) {
            return this.evaluate((IsLiteral)expr, bindings);
        }
        if (expr instanceof IsNumeric) {
            return this.evaluate((IsNumeric)expr, bindings);
        }
        if (expr instanceof IRIFunction) {
            return this.evaluate((IRIFunction)expr, bindings);
        }
        if (expr instanceof Regex) {
            return this.evaluate((Regex)expr, bindings);
        }
        if (expr instanceof Coalesce) {
            return this.evaluate((Coalesce)expr, bindings);
        }
        if (expr instanceof Like) {
            return this.evaluate((Like)expr, bindings);
        }
        if (expr instanceof FunctionCall) {
            return this.evaluate((FunctionCall)expr, bindings);
        }
        if (expr instanceof And) {
            return this.evaluate((And)expr, bindings);
        }
        if (expr instanceof Or) {
            return this.evaluate((Or)expr, bindings);
        }
        if (expr instanceof Not) {
            return this.evaluate((Not)expr, bindings);
        }
        if (expr instanceof SameTerm) {
            return this.evaluate((SameTerm)expr, bindings);
        }
        if (expr instanceof Compare) {
            return this.evaluate((Compare)expr, bindings);
        }
        if (expr instanceof MathExpr) {
            return this.evaluate((MathExpr)expr, bindings);
        }
        if (expr instanceof In) {
            return this.evaluate((In)expr, bindings);
        }
        if (expr instanceof CompareAny) {
            return this.evaluate((CompareAny)expr, bindings);
        }
        if (expr instanceof CompareAll) {
            return this.evaluate((CompareAll)expr, bindings);
        }
        if (expr instanceof Exists) {
            return this.evaluate((Exists)expr, bindings);
        }
        if (expr instanceof If) {
            return this.evaluate((If)expr, bindings);
        }
        if (expr instanceof ListMemberOperator) {
            return this.evaluate((ListMemberOperator)expr, bindings);
        }
        if (expr == null) {
            throw new IllegalArgumentException("expr must not be null");
        }
        throw new QueryEvaluationException("Unsupported value expr type: " + expr.getClass());
    }

    public Value evaluate(Var var, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value value = var.getValue();
        if (value == null) {
            value = bindings.getValue(var.getName());
        }
        if (value == null) {
            throw new ValueExprEvaluationException();
        }
        return value;
    }

    public Value evaluate(ValueConstant valueConstant, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        return valueConstant.getValue();
    }

    public Value evaluate(BNodeGenerator node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        ValueExpr nodeIdExpr = node.getNodeIdExpr();
        if (nodeIdExpr != null) {
            Value nodeId = this.evaluate(nodeIdExpr, bindings);
            if (nodeId instanceof Literal) {
                String nodeLabel = ((Literal)nodeId).getLabel() + bindings.toString().hashCode();
                return this.tripleSource.getValueFactory().createBNode(nodeLabel);
            }
            throw new ValueExprEvaluationException("BNODE function argument must be a literal");
        }
        return this.tripleSource.getValueFactory().createBNode();
    }

    public Value evaluate(Bound node, BindingSet bindings) throws QueryEvaluationException {
        try {
            Value argValue = this.evaluate(node.getArg(), bindings);
            return BooleanLiteralImpl.valueOf((argValue != null ? 1 : 0) != 0);
        }
        catch (ValueExprEvaluationException e) {
            return BooleanLiteralImpl.FALSE;
        }
    }

    public Value evaluate(Str node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof URI) {
            return this.tripleSource.getValueFactory().createLiteral(argValue.toString());
        }
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            if (QueryEvaluationUtil.isSimpleLiteral(literal)) {
                return literal;
            }
            return this.tripleSource.getValueFactory().createLiteral(literal.getLabel());
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(Label node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            if (QueryEvaluationUtil.isSimpleLiteral(literal)) {
                return literal;
            }
            return this.tripleSource.getValueFactory().createLiteral(literal.getLabel());
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(Lang node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            String langTag = literal.getLanguage();
            if (langTag == null) {
                langTag = "";
            }
            return this.tripleSource.getValueFactory().createLiteral(langTag);
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(Datatype node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value v = this.evaluate(node.getArg(), bindings);
        if (v instanceof Literal) {
            Literal literal = (Literal)v;
            if (literal.getDatatype() != null) {
                return literal.getDatatype();
            }
            if (literal.getLanguage() != null) {
                return RDF.LANGSTRING;
            }
            return XMLSchema.STRING;
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(Namespace node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof URI) {
            URI uri = (URI)argValue;
            return this.tripleSource.getValueFactory().createURI(uri.getNamespace());
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(LocalName node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof URI) {
            URI uri = (URI)argValue;
            return this.tripleSource.getValueFactory().createLiteral(uri.getLocalName());
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(IsResource node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        return BooleanLiteralImpl.valueOf((boolean)(argValue instanceof Resource));
    }

    public Value evaluate(IsURI node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        return BooleanLiteralImpl.valueOf((boolean)(argValue instanceof URI));
    }

    public Value evaluate(IsBNode node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        return BooleanLiteralImpl.valueOf((boolean)(argValue instanceof BNode));
    }

    public Value evaluate(IsLiteral node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        return BooleanLiteralImpl.valueOf((boolean)(argValue instanceof Literal));
    }

    public Value evaluate(IsNumeric node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof Literal) {
            Literal lit = (Literal)argValue;
            URI datatype = lit.getDatatype();
            return BooleanLiteralImpl.valueOf((boolean)XMLDatatypeUtil.isNumericDatatype((URI)datatype));
        }
        return BooleanLiteralImpl.FALSE;
    }

    public URI evaluate(IRIFunction node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof Literal) {
            Literal lit = (Literal)argValue;
            String uriString = lit.getLabel();
            String baseURI = node.getBaseURI();
            if (!URIUtil.isValidURIReference((String)uriString)) {
                if (baseURI != null) {
                    uriString = baseURI + uriString;
                    if (!URIUtil.isValidURIReference((String)uriString)) {
                        throw new ValueExprEvaluationException("not a valid URI reference: " + uriString);
                    }
                } else {
                    throw new ValueExprEvaluationException("not a valid URI reference: " + uriString);
                }
            }
            URI result = null;
            try {
                result = this.tripleSource.getValueFactory().createURI(uriString);
            }
            catch (IllegalArgumentException e) {
                throw new ValueExprEvaluationException(e.getMessage());
            }
            return result;
        }
        if (argValue instanceof URI) {
            return (URI)argValue;
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(Regex node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value arg = this.evaluate(node.getArg(), bindings);
        Value parg = this.evaluate(node.getPatternArg(), bindings);
        Value farg = null;
        ValueExpr flagsArg = node.getFlagsArg();
        if (flagsArg != null) {
            farg = this.evaluate(flagsArg, bindings);
        }
        if (QueryEvaluationUtil.isStringLiteral(arg) && QueryEvaluationUtil.isSimpleLiteral(parg) && (farg == null || QueryEvaluationUtil.isSimpleLiteral(farg))) {
            String text = ((Literal)arg).getLabel();
            String ptn = ((Literal)parg).getLabel();
            String flags = "";
            if (farg != null) {
                flags = ((Literal)farg).getLabel();
            }
            int f = 0;
            block8: for (char c : flags.toCharArray()) {
                switch (c) {
                    case 's': {
                        f |= 0x20;
                        continue block8;
                    }
                    case 'm': {
                        f |= 8;
                        continue block8;
                    }
                    case 'i': {
                        f |= 2;
                        continue block8;
                    }
                    case 'x': {
                        f |= 4;
                        continue block8;
                    }
                    case 'd': {
                        f |= 1;
                        continue block8;
                    }
                    case 'u': {
                        f |= 0x40;
                        continue block8;
                    }
                    default: {
                        throw new ValueExprEvaluationException(flags);
                    }
                }
            }
            Pattern pattern = Pattern.compile(ptn, f);
            boolean result = pattern.matcher(text).find();
            return BooleanLiteralImpl.valueOf((boolean)result);
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(LangMatches node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value langTagValue = this.evaluate(node.getLeftArg(), bindings);
        Value langRangeValue = this.evaluate(node.getRightArg(), bindings);
        if (QueryEvaluationUtil.isSimpleLiteral(langTagValue) && QueryEvaluationUtil.isSimpleLiteral(langRangeValue)) {
            String langTag = ((Literal)langTagValue).getLabel();
            String langRange = ((Literal)langRangeValue).getLabel();
            boolean result = false;
            if (langRange.equals("*")) {
                result = langTag.length() > 0;
            } else if (langTag.length() == langRange.length()) {
                result = langTag.equalsIgnoreCase(langRange);
            } else if (langTag.length() > langRange.length()) {
                String prefix = langTag.substring(0, langRange.length());
                result = prefix.equalsIgnoreCase(langRange) && langTag.charAt(langRange.length()) == '-';
            }
            return BooleanLiteralImpl.valueOf((boolean)result);
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(Like node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        String snippet;
        Value val = this.evaluate(node.getArg(), bindings);
        String strVal = null;
        if (val instanceof URI) {
            strVal = ((URI)val).toString();
        } else if (val instanceof Literal) {
            strVal = ((Literal)val).getLabel();
        }
        if (strVal == null) {
            throw new ValueExprEvaluationException();
        }
        if (!node.isCaseSensitive()) {
            strVal = strVal.toLowerCase();
        }
        int valIndex = 0;
        int prevPatternIndex = -1;
        int patternIndex = node.getOpPattern().indexOf(42);
        if (patternIndex == -1) {
            return BooleanLiteralImpl.valueOf((boolean)node.getOpPattern().equals(strVal));
        }
        if (patternIndex > 0) {
            snippet = node.getOpPattern().substring(0, patternIndex);
            if (!strVal.startsWith(snippet)) {
                return BooleanLiteralImpl.FALSE;
            }
            valIndex += snippet.length();
            prevPatternIndex = patternIndex;
            patternIndex = node.getOpPattern().indexOf(42, patternIndex + 1);
        }
        while (patternIndex != -1) {
            snippet = node.getOpPattern().substring(prevPatternIndex + 1, patternIndex);
            valIndex = strVal.indexOf(snippet, valIndex);
            if (valIndex == -1) {
                return BooleanLiteralImpl.FALSE;
            }
            valIndex += snippet.length();
            prevPatternIndex = patternIndex;
            patternIndex = node.getOpPattern().indexOf(42, patternIndex + 1);
        }
        snippet = node.getOpPattern().substring(prevPatternIndex + 1);
        if (snippet.length() > 0) {
            int i;
            valIndex = strVal.indexOf(snippet, valIndex);
            while ((i = strVal.indexOf(snippet, valIndex + 1)) != -1) {
                valIndex = i;
            }
            if (valIndex == -1) {
                return BooleanLiteralImpl.FALSE;
            }
            if ((valIndex += snippet.length()) < strVal.length()) {
                return BooleanLiteralImpl.FALSE;
            }
        }
        return BooleanLiteralImpl.TRUE;
    }

    public Value evaluate(FunctionCall node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Function function = (Function)FunctionRegistry.getInstance().get(node.getURI());
        if (function == null) {
            throw new QueryEvaluationException("Unknown function '" + node.getURI() + "'");
        }
        if (function instanceof Now) {
            return this.evaluate((Now)function, bindings);
        }
        List args = node.getArgs();
        Value[] argValues = new Value[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            argValues[i] = this.evaluate((ValueExpr)args.get(i), bindings);
        }
        return function.evaluate(this.tripleSource.getValueFactory(), argValues);
    }

    public Value evaluate(And node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        try {
            Value leftValue = this.evaluate(node.getLeftArg(), bindings);
            if (!QueryEvaluationUtil.getEffectiveBooleanValue(leftValue)) {
                return BooleanLiteralImpl.FALSE;
            }
        }
        catch (ValueExprEvaluationException e) {
            Value rightValue = this.evaluate(node.getRightArg(), bindings);
            if (!QueryEvaluationUtil.getEffectiveBooleanValue(rightValue)) {
                return BooleanLiteralImpl.FALSE;
            }
            throw new ValueExprEvaluationException();
        }
        Value rightValue = this.evaluate(node.getRightArg(), bindings);
        return BooleanLiteralImpl.valueOf((boolean)QueryEvaluationUtil.getEffectiveBooleanValue(rightValue));
    }

    public Value evaluate(Or node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        try {
            Value leftValue = this.evaluate(node.getLeftArg(), bindings);
            if (QueryEvaluationUtil.getEffectiveBooleanValue(leftValue)) {
                return BooleanLiteralImpl.TRUE;
            }
        }
        catch (ValueExprEvaluationException e) {
            Value rightValue = this.evaluate(node.getRightArg(), bindings);
            if (QueryEvaluationUtil.getEffectiveBooleanValue(rightValue)) {
                return BooleanLiteralImpl.TRUE;
            }
            throw new ValueExprEvaluationException();
        }
        Value rightValue = this.evaluate(node.getRightArg(), bindings);
        return BooleanLiteralImpl.valueOf((boolean)QueryEvaluationUtil.getEffectiveBooleanValue(rightValue));
    }

    public Value evaluate(Not node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        boolean argBoolean = QueryEvaluationUtil.getEffectiveBooleanValue(argValue);
        return BooleanLiteralImpl.valueOf((!argBoolean ? 1 : 0) != 0);
    }

    public Value evaluate(Now node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        if (this.sharedValueOfNow == null) {
            this.sharedValueOfNow = node.evaluate(this.tripleSource.getValueFactory(), new Value[0]);
        }
        return this.sharedValueOfNow;
    }

    public Value evaluate(SameTerm node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value leftVal = this.evaluate(node.getLeftArg(), bindings);
        Value rightVal = this.evaluate(node.getRightArg(), bindings);
        return BooleanLiteralImpl.valueOf((leftVal != null && leftVal.equals(rightVal) ? 1 : 0) != 0);
    }

    public Value evaluate(Coalesce node, BindingSet bindings) throws ValueExprEvaluationException {
        Value result = null;
        for (ValueExpr expr : node.getArguments()) {
            try {
                result = this.evaluate(expr, bindings);
                break;
            }
            catch (ValueExprEvaluationException e) {
            }
            catch (QueryEvaluationException e) {
            }
        }
        if (result == null) {
            throw new ValueExprEvaluationException("COALESCE arguments do not evaluate to a value: " + node.getSignature());
        }
        return result;
    }

    public Value evaluate(Compare node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value leftVal = this.evaluate(node.getLeftArg(), bindings);
        Value rightVal = this.evaluate(node.getRightArg(), bindings);
        return BooleanLiteralImpl.valueOf((boolean)QueryEvaluationUtil.compare(leftVal, rightVal, node.getOperator()));
    }

    public Value evaluate(MathExpr node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value leftVal = this.evaluate(node.getLeftArg(), bindings);
        Value rightVal = this.evaluate(node.getRightArg(), bindings);
        if (leftVal instanceof Literal && rightVal instanceof Literal) {
            return MathUtil.compute((Literal)leftVal, (Literal)rightVal, node.getOperator());
        }
        throw new ValueExprEvaluationException("Both arguments must be numeric literals");
    }

    public Value evaluate(If node, BindingSet bindings) throws QueryEvaluationException {
        boolean conditionIsTrue;
        Value result = null;
        try {
            Value value = this.evaluate(node.getCondition(), bindings);
            conditionIsTrue = QueryEvaluationUtil.getEffectiveBooleanValue(value);
        }
        catch (ValueExprEvaluationException e) {
            return null;
        }
        result = conditionIsTrue ? this.evaluate(node.getResult(), bindings) : this.evaluate(node.getAlternative(), bindings);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value evaluate(In node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value leftValue = this.evaluate(node.getArg(), bindings);
        boolean result = false;
        String bindingName = (String)node.getSubQuery().getBindingNames().iterator().next();
        CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluate(node.getSubQuery(), bindings);
        try {
            while (!result && iter.hasNext()) {
                BindingSet bindingSet = (BindingSet)iter.next();
                Value rightValue = bindingSet.getValue(bindingName);
                result = leftValue == null && rightValue == null || leftValue != null && leftValue.equals(rightValue);
            }
        }
        finally {
            iter.close();
        }
        return BooleanLiteralImpl.valueOf((boolean)result);
    }

    public Value evaluate(ListMemberOperator node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        List args = node.getArguments();
        Value leftValue = this.evaluate((ValueExpr)args.get(0), bindings);
        boolean result = false;
        ValueExprEvaluationException typeError = null;
        for (int i = 1; i < args.size(); ++i) {
            ValueExpr arg = (ValueExpr)args.get(i);
            try {
                Value rightValue = this.evaluate(arg, bindings);
                boolean bl = result = leftValue == null && rightValue == null;
                if (!result) {
                    result = QueryEvaluationUtil.compare(leftValue, rightValue, Compare.CompareOp.EQ);
                }
                if (!result) continue;
                break;
            }
            catch (ValueExprEvaluationException caught) {
                typeError = caught;
            }
        }
        if (typeError != null && !result) {
            throw typeError;
        }
        return BooleanLiteralImpl.valueOf((boolean)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value evaluate(CompareAny node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        boolean result;
        block7: {
            Value leftValue = this.evaluate(node.getArg(), bindings);
            result = false;
            String bindingName = (String)node.getSubQuery().getBindingNames().iterator().next();
            CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluate(node.getSubQuery(), bindings);
            block5: while (true) {
                while (!result && iter.hasNext()) {
                    BindingSet bindingSet = (BindingSet)iter.next();
                    Value rightValue = bindingSet.getValue(bindingName);
                    try {
                        result = QueryEvaluationUtil.compare(leftValue, rightValue, node.getOperator());
                        continue block5;
                    }
                    catch (ValueExprEvaluationException valueExprEvaluationException) {
                    }
                }
                break block7;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                iter.close();
            }
        }
        return BooleanLiteralImpl.valueOf((boolean)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value evaluate(CompareAll node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        boolean result;
        block7: {
            Value leftValue = this.evaluate(node.getArg(), bindings);
            result = true;
            String bindingName = (String)node.getSubQuery().getBindingNames().iterator().next();
            CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluate(node.getSubQuery(), bindings);
            block5: while (true) {
                while (result && iter.hasNext()) {
                    BindingSet bindingSet = (BindingSet)iter.next();
                    Value rightValue = bindingSet.getValue(bindingName);
                    try {
                        result = QueryEvaluationUtil.compare(leftValue, rightValue, node.getOperator());
                        continue block5;
                    }
                    catch (ValueExprEvaluationException e) {
                        result = false;
                    }
                }
                break block7;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                iter.close();
            }
        }
        return BooleanLiteralImpl.valueOf((boolean)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value evaluate(Exists node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluate(node.getSubQuery(), bindings);
        try {
            BooleanLiteralImpl booleanLiteralImpl = BooleanLiteralImpl.valueOf((boolean)iter.hasNext());
            return booleanLiteralImpl;
        }
        finally {
            iter.close();
        }
    }

    @Override
    public boolean isTrue(ValueExpr expr, BindingSet bindings) throws QueryEvaluationException {
        try {
            Value value = this.evaluate(expr, bindings);
            return QueryEvaluationUtil.getEffectiveBooleanValue(value);
        }
        catch (ValueExprEvaluationException e) {
            return false;
        }
    }

    protected boolean isReducedOrDistinct(QueryModelNode node) {
        QueryModelNode parent = node.getParentNode();
        if (parent instanceof Slice) {
            return this.isReducedOrDistinct(parent);
        }
        return parent instanceof Distinct || parent instanceof Reduced;
    }

    protected long getLimit(QueryModelNode node) {
        QueryModelNode parent;
        long offset = 0L;
        if (node instanceof Slice) {
            Slice slice = (Slice)node;
            if (slice.hasOffset() && slice.hasLimit()) {
                return slice.getOffset() + slice.getLimit();
            }
            if (slice.hasLimit()) {
                return slice.getLimit();
            }
            if (slice.hasOffset()) {
                offset = slice.getOffset();
            }
        }
        if ((parent = node.getParentNode()) instanceof Distinct || parent instanceof Reduced || parent instanceof Slice) {
            long limit = this.getLimit(parent);
            if (offset > 0L && limit < Long.MAX_VALUE) {
                return offset + limit;
            }
            return limit;
        }
        return Long.MAX_VALUE;
    }

    private static class BoundVarVisitor
    extends QueryModelVisitorBase<RuntimeException> {
        private final Set<Var> boundVars = new HashSet<Var>();

        private BoundVarVisitor() {
        }

        public void meet(Var var) {
            if (var.hasValue()) {
                this.boundVars.add(var);
            }
        }
    }
}

