/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.iterator;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.DelayedIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.LookAheadIteration;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;

public class OrderIterator
extends DelayedIteration<BindingSet, QueryEvaluationException> {
    private final CloseableIteration<BindingSet, QueryEvaluationException> iter;
    private final Comparator<BindingSet> comparator;
    private final long limit;
    private final boolean distinct;
    private final File tempFile;
    private final DB db;
    private final long iterationSyncThreshold;

    public OrderIterator(CloseableIteration<BindingSet, QueryEvaluationException> iter, Comparator<BindingSet> comparator) {
        this(iter, comparator, Integer.MAX_VALUE, false);
    }

    public OrderIterator(CloseableIteration<BindingSet, QueryEvaluationException> iter, Comparator<BindingSet> comparator, long limit, boolean distinct) {
        this(iter, comparator, limit, distinct, 0L);
    }

    public OrderIterator(CloseableIteration<BindingSet, QueryEvaluationException> iter, Comparator<BindingSet> comparator, long limit, boolean distinct, long iterationSyncThreshold) {
        this.iter = iter;
        this.comparator = comparator;
        this.limit = limit;
        this.distinct = distinct;
        this.iterationSyncThreshold = iterationSyncThreshold;
        if (iterationSyncThreshold > 0L) {
            try {
                this.tempFile = File.createTempFile("order-eval", null);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            this.db = DBMaker.newFileDB((File)this.tempFile).deleteFilesAfterClose().closeOnJvmShutdown().make();
        } else {
            this.tempFile = null;
            this.db = null;
        }
    }

    protected NavigableMap<BindingSet, Integer> makeOrderedMap() {
        if (this.db == null) {
            return new TreeMap<BindingSet, Integer>(this.comparator);
        }
        return this.db.createTreeMap("iteration").comparator(this.comparator).makeOrGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
        final NavigableMap<BindingSet, Integer> map = this.makeOrderedMap();
        long size = 0L;
        try {
            while (this.iter.hasNext()) {
                BindingSet next = (BindingSet)this.iter.next();
                if (size >= this.limit && this.comparator.compare(next, (BindingSet)map.lastKey()) >= 0) continue;
                Integer count = (Integer)map.get(next);
                if (count == null) {
                    this.put(map, next, 1);
                    ++size;
                } else if (!this.distinct) {
                    count = count + 1;
                    this.put(map, next, count);
                    ++size;
                }
                if (this.db != null && size % this.iterationSyncThreshold == 0L) {
                    this.db.commit();
                }
                if (size <= this.limit) continue;
                BindingSet lastKey = (BindingSet)map.lastKey();
                Integer lastCount = (Integer)map.get(lastKey);
                if (lastCount > 1) {
                    lastCount = lastCount - 1;
                    this.put(map, lastKey, lastCount);
                } else {
                    this.removeLast(map.navigableKeySet());
                }
                --size;
            }
        }
        finally {
            this.iter.close();
        }
        return new LookAheadIteration<BindingSet, QueryEvaluationException>(){
            private volatile Iterator<BindingSet> iterator;
            private volatile BindingSet currentBindingSet;
            private volatile int count;
            {
                this.iterator = map.keySet().iterator();
                this.currentBindingSet = null;
                this.count = 0;
            }

            protected BindingSet getNextElement() {
                if (this.count == 0 && this.iterator.hasNext()) {
                    this.currentBindingSet = this.iterator.next();
                    this.count = (Integer)map.get(this.currentBindingSet);
                }
                if (this.count > 0) {
                    --this.count;
                    return this.currentBindingSet;
                }
                return null;
            }
        };
    }

    protected void removeLast(Collection<BindingSet> lastResults) {
        if (lastResults instanceof LinkedList) {
            ((LinkedList)lastResults).removeLast();
        } else if (lastResults instanceof List) {
            ((List)lastResults).remove(lastResults.size() - 1);
        } else {
            Iterator<BindingSet> iter = lastResults.iterator();
            while (iter.hasNext()) {
                iter.next();
            }
            iter.remove();
        }
    }

    protected boolean add(BindingSet next, Collection<BindingSet> list) throws QueryEvaluationException {
        return list.add(next);
    }

    protected Integer put(NavigableMap<BindingSet, Integer> map, BindingSet set, int count) throws QueryEvaluationException {
        return map.put(set, count);
    }

    public void remove() throws QueryEvaluationException {
        throw new UnsupportedOperationException();
    }

    protected void handleClose() throws QueryEvaluationException {
        this.iter.close();
        if (this.db != null) {
            this.db.close();
        }
        super.handleClose();
    }
}

