/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.resultio.sparqlxml;

import info.aduna.xml.SimpleSAXAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.query.resultio.QueryResultParseException;
import org.xml.sax.SAXException;

class SPARQLResultsSAXParser
extends SimpleSAXAdapter {
    private List<String> bindingNames;
    private String currentBindingName;
    private Value currentValue;
    private MapBindingSet currentSolution;
    private ValueFactory valueFactory;
    private QueryResultHandler handler;

    public SPARQLResultsSAXParser(ValueFactory valueFactory, QueryResultHandler handler) {
        this.valueFactory = valueFactory;
        this.handler = handler;
    }

    public void startDocument() throws SAXException {
        this.bindingNames = new ArrayList<String>();
        this.currentValue = null;
    }

    public void endDocument() throws SAXException {
        try {
            if (this.handler != null) {
                this.handler.endQueryResult();
            }
        }
        catch (TupleQueryResultHandlerException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startTag(String tagName, Map<String, String> atts, String text) throws SAXException {
        if ("binding".equals(tagName)) {
            this.currentBindingName = atts.get("name");
            if (this.currentBindingName != null) return;
            throw new SAXException("name attribute missing for binding element");
        }
        if ("uri".equals(tagName)) {
            try {
                this.currentValue = this.valueFactory.createURI(text);
                return;
            }
            catch (IllegalArgumentException e) {
                throw new SAXException(e.getMessage(), e);
            }
        } else if ("bnode".equals(tagName)) {
            this.currentValue = this.valueFactory.createBNode(text);
            return;
        } else if ("literal".equals(tagName)) {
            String xmlLang = atts.get("xml:lang");
            String datatype = atts.get("datatype");
            if (xmlLang != null) {
                this.currentValue = this.valueFactory.createLiteral(text, xmlLang);
                return;
            } else if (datatype != null) {
                try {
                    this.currentValue = this.valueFactory.createLiteral(text, this.valueFactory.createURI(datatype));
                    return;
                }
                catch (IllegalArgumentException e) {
                    throw new SAXException(e.getMessage(), e);
                }
            } else {
                this.currentValue = this.valueFactory.createLiteral(text);
            }
            return;
        } else if ("result".equals(tagName)) {
            this.currentSolution = new MapBindingSet(this.bindingNames.size());
            return;
        } else if ("variable".equals(tagName)) {
            String varName = atts.get("name");
            if (varName == null) {
                throw new SAXException("name missing for variable element");
            }
            this.bindingNames.add(varName);
            return;
        } else if ("results".equals(tagName)) {
            try {
                if (this.handler == null) return;
                this.handler.startQueryResult(this.bindingNames);
                return;
            }
            catch (TupleQueryResultHandlerException e) {
                throw new SAXException((Exception)((Object)e));
            }
        } else {
            if (!"boolean".equals(tagName)) return;
            QueryResultParseException realException = new QueryResultParseException("Found boolean results in tuple parser");
            throw new SAXException((Exception)realException);
        }
    }

    public void endTag(String tagName) throws SAXException {
        if ("binding".equals(tagName)) {
            if (this.currentValue == null) {
                throw new SAXException("Value missing for binding element");
            }
            this.currentSolution.addBinding(this.currentBindingName, this.currentValue);
            this.currentBindingName = null;
            this.currentValue = null;
        } else if ("result".equals(tagName)) {
            try {
                if (this.handler != null) {
                    this.handler.handleSolution((BindingSet)this.currentSolution);
                }
                this.currentSolution = null;
            }
            catch (TupleQueryResultHandlerException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }
    }
}

