/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.config;

import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.util.Models;
import org.openrdf.repository.config.AbstractRepositoryImplConfig;
import org.openrdf.repository.config.DelegatingRepositoryImplConfig;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryConfigSchema;
import org.openrdf.repository.config.RepositoryImplConfig;

public abstract class AbstractDelegatingRepositoryImplConfig
extends AbstractRepositoryImplConfig
implements DelegatingRepositoryImplConfig {
    private RepositoryImplConfig delegate;

    public AbstractDelegatingRepositoryImplConfig() {
    }

    public AbstractDelegatingRepositoryImplConfig(String type) {
        super(type);
    }

    public AbstractDelegatingRepositoryImplConfig(String type, RepositoryImplConfig delegate) {
        this(type);
        this.setDelegate(delegate);
    }

    @Override
    public RepositoryImplConfig getDelegate() {
        return this.delegate;
    }

    public void setDelegate(RepositoryImplConfig delegate) {
        this.delegate = delegate;
    }

    @Override
    public void validate() throws RepositoryConfigException {
        super.validate();
        if (this.delegate == null) {
            throw new RepositoryConfigException("No delegate specified for " + this.getType() + " repository");
        }
        this.delegate.validate();
    }

    @Override
    public Resource export(Model model) {
        Resource resource = super.export(model);
        if (this.delegate != null) {
            Resource delegateNode = this.delegate.export(model);
            model.add(resource, RepositoryConfigSchema.DELEGATE, (Value)delegateNode, new Resource[0]);
        }
        return resource;
    }

    @Override
    public void parse(Model model, Resource resource) throws RepositoryConfigException {
        super.parse(model, resource);
        Models.objectResource((Model)model.filter(resource, RepositoryConfigSchema.DELEGATE, null, new Resource[0])).ifPresent(delegate -> this.setDelegate(AbstractDelegatingRepositoryImplConfig.create(model, delegate)));
    }
}

