/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.config;

import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.impl.SimpleValueFactory;
import org.openrdf.model.util.ModelException;
import org.openrdf.model.util.Models;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryConfigSchema;
import org.openrdf.repository.config.RepositoryFactory;
import org.openrdf.repository.config.RepositoryImplConfig;
import org.openrdf.repository.config.RepositoryRegistry;

public class AbstractRepositoryImplConfig
implements RepositoryImplConfig {
    private String type;

    public AbstractRepositoryImplConfig() {
    }

    public AbstractRepositoryImplConfig(String type) {
        this();
        this.setType(type);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void validate() throws RepositoryConfigException {
        if (this.type == null) {
            throw new RepositoryConfigException("No type specified for repository implementation");
        }
    }

    @Override
    public Resource export(Model model) {
        BNode implNode = SimpleValueFactory.getInstance().createBNode();
        if (this.type != null) {
            model.add((Resource)implNode, RepositoryConfigSchema.REPOSITORYTYPE, (Value)SimpleValueFactory.getInstance().createLiteral(this.type), new Resource[0]);
        }
        return implNode;
    }

    @Override
    public void parse(Model model, Resource resource) throws RepositoryConfigException {
        Models.objectLiteral((Model)model.filter(resource, RepositoryConfigSchema.REPOSITORYTYPE, null, new Resource[0])).ifPresent(typeLit -> this.setType(typeLit.getLabel()));
    }

    public static RepositoryImplConfig create(Model model, Resource resource) throws RepositoryConfigException {
        try {
            Literal typeLit = Models.objectLiteral((Model)model.filter(resource, RepositoryConfigSchema.REPOSITORYTYPE, null, new Resource[0])).orElse(null);
            if (typeLit != null) {
                RepositoryFactory factory = (RepositoryFactory)RepositoryRegistry.getInstance().get(typeLit.getLabel()).orElseThrow(() -> new RepositoryConfigException("Unsupported repository type: " + typeLit.getLabel()));
                RepositoryImplConfig implConfig = factory.getConfig();
                implConfig.parse(model, resource);
                return implConfig;
            }
            return null;
        }
        catch (ModelException e) {
            throw new RepositoryConfigException(e.getMessage(), e);
        }
    }
}

