/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.config;

import info.aduna.iteration.Iterations;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.IRI;
import org.openrdf.model.Literal;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.QueryResults;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.config.RepositoryConfig;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryConfigSchema;

public class RepositoryConfigUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getRepositoryIDs(Repository repository) throws RepositoryException {
        try (RepositoryConnection con = repository.getConnection();){
            LinkedHashSet<String> idSet = new LinkedHashSet<String>();
            try (RepositoryResult<Statement> idStatementIter = con.getStatements(null, RepositoryConfigSchema.REPOSITORYID, null, true, new Resource[0]);){
                while (idStatementIter.hasNext()) {
                    Statement idStatement = idStatementIter.next();
                    if (!(idStatement.getObject() instanceof Literal)) continue;
                    Literal idLiteral = (Literal)idStatement.getObject();
                    idSet.add(idLiteral.getLabel());
                }
            }
            LinkedHashSet<String> linkedHashSet = idSet;
            return linkedHashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasRepositoryConfig(Repository repository, String repositoryID) throws RepositoryException, RepositoryConfigException {
        try (RepositoryConnection con = repository.getConnection();){
            boolean bl = RepositoryConfigUtil.getIDStatement(con, repositoryID) != null;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RepositoryConfig getRepositoryConfig(Repository repository, String repositoryID) throws RepositoryConfigException, RepositoryException {
        try (RepositoryConnection con = repository.getConnection();){
            Statement idStatement = RepositoryConfigUtil.getIDStatement(con, repositoryID);
            if (idStatement == null) {
                RepositoryConfig repositoryConfig = null;
                return repositoryConfig;
            }
            Resource repositoryNode = idStatement.getSubject();
            Resource context = idStatement.getContext();
            if (context == null) {
                throw new RepositoryException("No configuration context for repository " + repositoryID);
            }
            Model contextGraph = QueryResults.asModel(con.getStatements((Resource)null, (IRI)null, (Value)null, true, context));
            RepositoryConfig repositoryConfig = RepositoryConfig.create(contextGraph, repositoryNode);
            return repositoryConfig;
        }
    }

    public static void updateRepositoryConfigs(Repository repository, RepositoryConfig ... configs) throws RepositoryException, RepositoryConfigException {
        try (RepositoryConnection con = repository.getConnection();){
            RepositoryConfigUtil.updateRepositoryConfigs(con, configs);
        }
    }

    public static void updateRepositoryConfigs(RepositoryConnection con, RepositoryConfig ... configs) throws RepositoryException, RepositoryConfigException {
        ValueFactory vf = con.getRepository().getValueFactory();
        con.begin();
        for (RepositoryConfig config : configs) {
            Resource context = RepositoryConfigUtil.getContext(con, config.getID());
            if (context != null) {
                con.clear(context);
            } else {
                context = vf.createBNode();
            }
            con.add(context, RDF.TYPE, (Value)RepositoryConfigSchema.REPOSITORY_CONTEXT, new Resource[0]);
            LinkedHashModel graph = new LinkedHashModel();
            config.export((Model)graph);
            con.add((Iterable<? extends Statement>)graph, context);
        }
        con.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeRepositoryConfigs(Repository repository, String ... repositoryIDs) throws RepositoryException, RepositoryConfigException {
        boolean changed = false;
        try (RepositoryConnection con = repository.getConnection();){
            con.begin();
            for (String id : repositoryIDs) {
                Resource context = RepositoryConfigUtil.getContext(con, id);
                if (context == null) continue;
                con.clear(context);
                con.remove(context, RDF.TYPE, (Value)RepositoryConfigSchema.REPOSITORY_CONTEXT, new Resource[0]);
                changed = true;
            }
            con.commit();
        }
        return changed;
    }

    public static Resource getContext(RepositoryConnection con, String repositoryID) throws RepositoryException, RepositoryConfigException {
        Resource context = null;
        Statement idStatement = RepositoryConfigUtil.getIDStatement(con, repositoryID);
        if (idStatement != null) {
            context = idStatement.getContext();
        }
        return context;
    }

    private static Statement getIDStatement(RepositoryConnection con, String repositoryID) throws RepositoryException, RepositoryConfigException {
        Literal idLiteral = con.getRepository().getValueFactory().createLiteral(repositoryID);
        List idStatementList = Iterations.asList(con.getStatements(null, RepositoryConfigSchema.REPOSITORYID, (Value)idLiteral, true, new Resource[0]));
        if (idStatementList.size() == 1) {
            return (Statement)idStatementList.get(0);
        }
        if (idStatementList.isEmpty()) {
            return null;
        }
        throw new RepositoryConfigException("Multiple ID-statements for repository ID " + repositoryID);
    }
}

