/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.OpenRDFException;
import org.openrdf.OpenRDFUtil;
import org.openrdf.model.BNode;
import org.openrdf.model.IRI;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.helpers.AbstractRDFHandler;

public abstract class AbstractRDFInserter
extends AbstractRDFHandler {
    protected Resource[] contexts = new Resource[0];
    private boolean preserveBNodeIDs = true;
    private final Map<String, String> namespaceMap = new HashMap<String, String>();
    private final Map<String, BNode> bNodesMap = new HashMap<String, BNode>();
    private final ValueFactory valueFactory;

    protected AbstractRDFInserter(ValueFactory vf) {
        this.valueFactory = vf;
    }

    public void setPreserveBNodeIDs(boolean preserveBNodeIDs) {
        this.preserveBNodeIDs = preserveBNodeIDs;
    }

    public boolean preservesBNodeIDs() {
        return this.preserveBNodeIDs;
    }

    public void enforceContext(Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        this.contexts = Arrays.copyOf(contexts, contexts.length);
    }

    public boolean enforcesContext() {
        return this.contexts.length != 0;
    }

    public Resource[] getContexts() {
        return Arrays.copyOf(this.contexts, this.contexts.length);
    }

    protected abstract void addNamespace(String var1, String var2) throws OpenRDFException;

    protected abstract void addStatement(Resource var1, IRI var2, Value var3, Resource var4) throws OpenRDFException;

    public void endRDF() throws RDFHandlerException {
        for (Map.Entry<String, String> entry : this.namespaceMap.entrySet()) {
            String prefix = entry.getKey();
            String name = entry.getValue();
            try {
                this.addNamespace(prefix, name);
            }
            catch (OpenRDFException e) {
                throw new RDFHandlerException((Throwable)e);
            }
        }
        this.namespaceMap.clear();
        this.bNodesMap.clear();
    }

    public void handleNamespace(String prefix, String name) {
        if (prefix != null && !this.namespaceMap.containsKey(prefix)) {
            this.namespaceMap.put(prefix, name);
        }
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        Resource subj = st.getSubject();
        IRI pred = st.getPredicate();
        Value obj = st.getObject();
        Resource ctxt = st.getContext();
        if (!this.preserveBNodeIDs) {
            if (subj instanceof BNode) {
                subj = this.mapBNode((BNode)subj);
            }
            if (obj instanceof BNode) {
                obj = this.mapBNode((BNode)obj);
            }
            if (!this.enforcesContext() && ctxt instanceof BNode) {
                ctxt = this.mapBNode((BNode)ctxt);
            }
        }
        try {
            this.addStatement(subj, pred, obj, ctxt);
        }
        catch (OpenRDFException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    private BNode mapBNode(BNode bNode) {
        BNode result = this.bNodesMap.get(bNode.getID());
        if (result == null) {
            result = this.valueFactory.createBNode();
            this.bNodesMap.put(bNode.getID(), result);
        }
        return result;
    }
}

