/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.util;

import java.util.function.Consumer;
import java.util.function.Function;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.UnknownTransactionStateException;
import org.openrdf.rio.RDFHandler;

public final class Repositories {
    public static void consume(Repository repository, Consumer<RepositoryConnection> processFunction) throws RepositoryException, UnknownTransactionStateException {
        Repositories.get(repository, conn -> {
            processFunction.accept((RepositoryConnection)conn);
            return null;
        });
    }

    public static void consume(Repository repository, Consumer<RepositoryConnection> processFunction, Consumer<RepositoryException> exceptionHandler) throws RepositoryException, UnknownTransactionStateException {
        try {
            Repositories.consume(repository, processFunction);
        }
        catch (RepositoryException e) {
            exceptionHandler.accept(e);
        }
    }

    public static void consumeSilent(Repository repository, Consumer<RepositoryConnection> processFunction) {
        Repositories.consume(repository, processFunction, e -> {});
    }

    public static <T> T get(Repository repository, Function<RepositoryConnection, T> processFunction) throws RepositoryException, UnknownTransactionStateException {
        RepositoryConnection conn = null;
        try {
            conn = repository.getConnection();
            conn.begin();
            T result = processFunction.apply(conn);
            conn.commit();
            T t = result;
            return t;
        }
        catch (RepositoryException e) {
            if (conn != null && conn.isActive()) {
                conn.rollback();
            }
            throw e;
        }
        finally {
            if (conn != null && conn.isOpen()) {
                conn.close();
            }
        }
    }

    public static <T> T get(Repository repository, Function<RepositoryConnection, T> processFunction, Consumer<RepositoryException> exceptionHandler) throws RepositoryException, UnknownTransactionStateException {
        try {
            return Repositories.get(repository, processFunction);
        }
        catch (RepositoryException e) {
            exceptionHandler.accept(e);
            return null;
        }
    }

    public static <T> T getSilent(Repository repository, Function<RepositoryConnection, T> processFunction) {
        return Repositories.get(repository, processFunction, e -> {});
    }

    public static <T> T tupleQuery(Repository repository, String query, Function<TupleQueryResult, T> processFunction) throws RepositoryException, UnknownTransactionStateException, MalformedQueryException, QueryEvaluationException {
        return (T)Repositories.get(repository, conn -> {
            TupleQuery preparedQuery = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
            try (TupleQueryResult queryResult = preparedQuery.evaluate();){
                Object r = processFunction.apply(queryResult);
                return r;
            }
        });
    }

    public static void tupleQuery(Repository repository, String query, TupleQueryResultHandler handler) throws RepositoryException, UnknownTransactionStateException, MalformedQueryException, QueryEvaluationException {
        Repositories.consume(repository, conn -> {
            TupleQuery preparedQuery = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
            preparedQuery.evaluate(handler);
        });
    }

    public static <T> T graphQuery(Repository repository, String query, Function<GraphQueryResult, T> processFunction) throws RepositoryException, UnknownTransactionStateException, MalformedQueryException, QueryEvaluationException {
        return (T)Repositories.get(repository, conn -> {
            GraphQuery preparedQuery = conn.prepareGraphQuery(QueryLanguage.SPARQL, query);
            try (GraphQueryResult queryResult = preparedQuery.evaluate();){
                Object r = processFunction.apply(queryResult);
                return r;
            }
        });
    }

    public static void graphQuery(Repository repository, String query, RDFHandler handler) throws RepositoryException, UnknownTransactionStateException, MalformedQueryException, QueryEvaluationException {
        Repositories.consume(repository, conn -> {
            GraphQuery preparedQuery = conn.prepareGraphQuery(QueryLanguage.SPARQL, query);
            preparedQuery.evaluate(handler);
        });
    }

    private Repositories() {
    }
}

