/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sail;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.Dataset;
import org.openrdf.query.Update;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.query.algebra.UpdateExpr;
import org.openrdf.query.impl.AbstractOperation;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.query.parser.ParsedUpdate;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepositoryConnection;
import org.openrdf.repository.sail.helpers.SailUpdateExecutor;
import org.openrdf.rio.RDFParseException;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SailUpdate
extends AbstractOperation
implements Update {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ParsedUpdate parsedUpdate;
    private final SailRepositoryConnection con;

    protected SailUpdate(ParsedUpdate parsedUpdate, SailRepositoryConnection con) {
        this.parsedUpdate = parsedUpdate;
        this.con = con;
    }

    public ParsedUpdate getParsedUpdate() {
        return this.parsedUpdate;
    }

    protected SailRepositoryConnection getConnection() {
        return this.con;
    }

    public String toString() {
        return this.parsedUpdate.toString();
    }

    public void execute() throws UpdateExecutionException {
        List updateExprs = this.parsedUpdate.getUpdateExprs();
        Map datasetMapping = this.parsedUpdate.getDatasetMapping();
        ValueFactory vf = this.getConnection().getValueFactory();
        SailConnection conn = this.getConnection().getSailConnection();
        SailUpdateExecutor executor = new SailUpdateExecutor(conn, vf, this.getConnection().getParserConfig());
        for (UpdateExpr updateExpr : updateExprs) {
            Dataset activeDataset = this.getMergedDataset((Dataset)datasetMapping.get(updateExpr));
            try {
                boolean localTransaction;
                boolean bl = localTransaction = !this.getConnection().isActive();
                if (localTransaction) {
                    this.getConnection().begin();
                }
                executor.executeUpdate(updateExpr, activeDataset, this.getBindings(), true);
                if (!localTransaction) continue;
                this.getConnection().commit();
            }
            catch (SailException e) {
                this.logger.warn("exception during update execution: ", (Throwable)e);
                if (updateExpr.isSilent()) continue;
                throw new UpdateExecutionException((Throwable)e);
            }
            catch (RepositoryException e) {
                this.logger.warn("exception during update execution: ", (Throwable)e);
                if (updateExpr.isSilent()) continue;
                throw new UpdateExecutionException((Throwable)e);
            }
            catch (RDFParseException e) {
                this.logger.warn("exception during update execution: ", (Throwable)e);
                if (updateExpr.isSilent()) continue;
                throw new UpdateExecutionException((Throwable)e);
            }
            catch (IOException e) {
                this.logger.warn("exception during update execution: ", (Throwable)e);
                if (updateExpr.isSilent()) continue;
                throw new UpdateExecutionException((Throwable)e);
            }
        }
    }

    protected Dataset getMergedDataset(Dataset sparqlDefinedDataset) {
        Set ngs;
        if (sparqlDefinedDataset == null) {
            return this.dataset;
        }
        if (this.dataset == null) {
            return sparqlDefinedDataset;
        }
        DatasetImpl mergedDataset = new DatasetImpl();
        boolean merge = false;
        Set dgs = sparqlDefinedDataset.getDefaultGraphs();
        if (dgs != null && dgs.size() > 0) {
            merge = true;
            for (URI graphURI : dgs) {
                mergedDataset.addDefaultGraph(graphURI);
            }
        }
        if ((ngs = sparqlDefinedDataset.getNamedGraphs()) != null && ngs.size() > 0) {
            merge = true;
            for (URI graphURI : ngs) {
                mergedDataset.addNamedGraph(graphURI);
            }
        }
        if (merge) {
            mergedDataset.setDefaultInsertGraph(this.dataset.getDefaultInsertGraph());
            for (URI graphURI : this.dataset.getDefaultRemoveGraphs()) {
                mergedDataset.addDefaultRemoveGraph(graphURI);
            }
            return mergedDataset;
        }
        return sparqlDefinedDataset;
    }
}

