/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sparql.query;

import java.io.IOException;
import org.openrdf.http.client.SparqlSession;
import org.openrdf.http.client.query.AbstractHTTPQuery;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sparql.query.QueryStringUtil;

public class SPARQLBooleanQuery
extends AbstractHTTPQuery
implements BooleanQuery {
    public SPARQLBooleanQuery(SparqlSession httpClient, String baseURI, String queryString) {
        super(httpClient, QueryLanguage.SPARQL, queryString, baseURI);
    }

    public boolean evaluate() throws QueryEvaluationException {
        SparqlSession client = this.getHttpClient();
        try {
            return client.sendBooleanQuery(this.queryLanguage, this.getQueryString(), this.baseURI, this.dataset, this.getIncludeInferred(), this.getMaxExecutionTime(), this.getBindingsArray());
        }
        catch (IOException e) {
            throw new QueryEvaluationException(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new QueryEvaluationException(e.getMessage(), (Throwable)e);
        }
        catch (MalformedQueryException e) {
            throw new QueryEvaluationException(e.getMessage(), (Throwable)e);
        }
    }

    private String getQueryString() {
        return QueryStringUtil.getQueryString(this.queryString, this.getBindings());
    }
}

