/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio;

import info.aduna.lang.FileFormat;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import org.openrdf.model.Model;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.ParseErrorListener;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.RDFWriterRegistry;
import org.openrdf.rio.UnsupportedRDFormatException;
import org.openrdf.rio.WriterConfig;
import org.openrdf.rio.helpers.ContextStatementCollector;
import org.openrdf.rio.helpers.ParseErrorLogger;

public class Rio {
    public static RDFFormat getParserFormatForMIMEType(String mimeType) {
        return Rio.getParserFormatForMIMEType(mimeType, null);
    }

    public static RDFFormat getParserFormatForMIMEType(String mimeType, RDFFormat fallback) {
        return (RDFFormat)RDFFormat.matchMIMEType((String)mimeType, (Iterable)RDFParserRegistry.getInstance().getKeys(), (FileFormat)fallback);
    }

    public static RDFFormat getParserFormatForFileName(String fileName) {
        return Rio.getParserFormatForFileName(fileName, null);
    }

    public static RDFFormat getParserFormatForFileName(String fileName, RDFFormat fallback) {
        return (RDFFormat)RDFFormat.matchFileName((String)fileName, (Iterable)RDFParserRegistry.getInstance().getKeys(), (FileFormat)fallback);
    }

    public static RDFFormat getWriterFormatForMIMEType(String mimeType) {
        return Rio.getWriterFormatForMIMEType(mimeType, null);
    }

    public static RDFFormat getWriterFormatForMIMEType(String mimeType, RDFFormat fallback) {
        return (RDFFormat)RDFFormat.matchMIMEType((String)mimeType, (Iterable)RDFWriterRegistry.getInstance().getKeys(), (FileFormat)fallback);
    }

    public static RDFFormat getWriterFormatForFileName(String fileName) {
        return Rio.getWriterFormatForFileName(fileName, null);
    }

    public static RDFFormat getWriterFormatForFileName(String fileName, RDFFormat fallback) {
        return (RDFFormat)RDFFormat.matchFileName((String)fileName, (Iterable)RDFWriterRegistry.getInstance().getKeys(), (FileFormat)fallback);
    }

    public static RDFParser createParser(RDFFormat format) throws UnsupportedRDFormatException {
        RDFParserFactory factory = (RDFParserFactory)RDFParserRegistry.getInstance().get((Object)format);
        if (factory != null) {
            return factory.getParser();
        }
        throw new UnsupportedRDFormatException("No parser factory available for RDF format " + (Object)((Object)format));
    }

    public static RDFParser createParser(RDFFormat format, ValueFactory valueFactory) throws UnsupportedRDFormatException {
        RDFParser rdfParser = Rio.createParser(format);
        rdfParser.setValueFactory(valueFactory);
        return rdfParser;
    }

    public static RDFWriter createWriter(RDFFormat format, OutputStream out) throws UnsupportedRDFormatException {
        RDFWriterFactory factory = (RDFWriterFactory)RDFWriterRegistry.getInstance().get((Object)format);
        if (factory != null) {
            return factory.getWriter(out);
        }
        throw new UnsupportedRDFormatException("No writer factory available for RDF format " + (Object)((Object)format));
    }

    public static RDFWriter createWriter(RDFFormat format, Writer writer) throws UnsupportedRDFormatException {
        RDFWriterFactory factory = (RDFWriterFactory)RDFWriterRegistry.getInstance().get((Object)format);
        if (factory != null) {
            return factory.getWriter(writer);
        }
        throw new UnsupportedRDFormatException("No writer factory available for RDF format " + (Object)((Object)format));
    }

    public static Model parse(InputStream in, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, UnsupportedRDFormatException {
        return Rio.parse(in, baseURI, dataFormat, new ParserConfig(), (ValueFactory)ValueFactoryImpl.getInstance(), (ParseErrorListener)new ParseErrorLogger(), contexts);
    }

    public static Model parse(Reader reader, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, UnsupportedRDFormatException {
        return Rio.parse(reader, baseURI, dataFormat, new ParserConfig(), (ValueFactory)ValueFactoryImpl.getInstance(), (ParseErrorListener)new ParseErrorLogger(), contexts);
    }

    public static Model parse(InputStream in, String baseURI, RDFFormat dataFormat, ParserConfig settings, ValueFactory valueFactory, ParseErrorListener errors, Resource ... contexts) throws IOException, RDFParseException, UnsupportedRDFormatException {
        LinkedHashModel result = new LinkedHashModel();
        RDFParser parser = Rio.createParser(dataFormat, valueFactory);
        parser.setParserConfig(settings);
        parser.setParseErrorListener(errors);
        parser.setRDFHandler(new ContextStatementCollector((Collection<Statement>)result, valueFactory, contexts));
        try {
            parser.parse(in, baseURI);
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
        return result;
    }

    public static Model parse(Reader reader, String baseURI, RDFFormat dataFormat, ParserConfig settings, ValueFactory valueFactory, ParseErrorListener errors, Resource ... contexts) throws IOException, RDFParseException, UnsupportedRDFormatException {
        LinkedHashModel result = new LinkedHashModel();
        RDFParser parser = Rio.createParser(dataFormat, valueFactory);
        parser.setParserConfig(settings);
        parser.setParseErrorListener(errors);
        parser.setRDFHandler(new ContextStatementCollector((Collection<Statement>)result, valueFactory, contexts));
        try {
            parser.parse(reader, baseURI);
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
        return result;
    }

    public static void write(Iterable<Statement> model, OutputStream output, RDFFormat dataFormat) throws RDFHandlerException {
        Rio.write(model, output, dataFormat, new WriterConfig());
    }

    public static void write(Iterable<Statement> model, Writer output, RDFFormat dataFormat) throws RDFHandlerException {
        Rio.write(model, output, dataFormat, new WriterConfig());
    }

    public static void write(Iterable<Statement> model, OutputStream output, RDFFormat dataFormat, WriterConfig settings) throws RDFHandlerException {
        RDFWriter writer = Rio.createWriter(dataFormat, output);
        writer.setWriterConfig(settings);
        Rio.write(model, (RDFHandler)writer);
    }

    public static void write(Iterable<Statement> model, Writer output, RDFFormat dataFormat, WriterConfig settings) throws RDFHandlerException {
        RDFWriter writer = Rio.createWriter(dataFormat, output);
        writer.setWriterConfig(settings);
        Rio.write(model, (RDFHandler)writer);
    }

    public static void write(Iterable<Statement> model, RDFHandler writer) throws RDFHandlerException {
        writer.startRDF();
        if (model instanceof Model) {
            for (Namespace nextNamespace : ((Model)model).getNamespaces()) {
                writer.handleNamespace(nextNamespace.getPrefix(), nextNamespace.getName());
            }
        }
        for (Statement st : model) {
            writer.handleStatement(st);
        }
        writer.endRDF();
    }

    public static void write(Statement st, OutputStream output, RDFFormat dataFormat) throws RDFHandlerException {
        Rio.write(st, output, dataFormat, new WriterConfig());
    }

    public static void write(Statement st, OutputStream output, RDFFormat dataFormat, WriterConfig settings) throws RDFHandlerException {
        RDFWriter writer = Rio.createWriter(dataFormat, output);
        writer.setWriterConfig(settings);
        Rio.write(st, (RDFHandler)writer);
    }

    public static void write(Statement statement, Writer output, RDFFormat dataFormat) throws RDFHandlerException {
        Rio.write(statement, output, dataFormat, new WriterConfig());
    }

    public static void write(Statement statement, Writer output, RDFFormat dataFormat, WriterConfig settings) throws RDFHandlerException {
        RDFWriter writer = Rio.createWriter(dataFormat, output);
        writer.setWriterConfig(settings);
        Rio.write(statement, (RDFHandler)writer);
    }

    public static void write(Statement statement, RDFHandler writer) throws RDFHandlerException {
        writer.startRDF();
        writer.handleStatement(statement);
        writer.endRDF();
    }

    public static void main(String[] args) throws IOException, RDFParseException, RDFHandlerException, UnsupportedRDFormatException {
        if (args.length < 2) {
            System.out.println("Usage: java org.openrdf.rio.Rio <inputFile> <outputFile>");
            return;
        }
        String inputFile = args[0];
        FileInputStream inStream = new FileInputStream(inputFile);
        RDFFormat inputFormat = Rio.getParserFormatForFileName(inputFile, RDFFormat.RDFXML);
        RDFParser rdfParser = Rio.createParser(inputFormat);
        String outputFile = args[1];
        FileOutputStream outStream = new FileOutputStream(outputFile);
        RDFFormat outputFormat = Rio.getWriterFormatForFileName(outputFile, RDFFormat.RDFXML);
        RDFWriter rdfWriter = Rio.createWriter(outputFormat, outStream);
        rdfParser.setRDFHandler(rdfWriter);
        rdfParser.parse(inStream, "file:" + inputFile);
        inStream.close();
        outStream.close();
    }
}

