/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Namespace;
import org.openrdf.model.impl.NamespaceImpl;
import org.openrdf.rio.DatatypeHandler;
import org.openrdf.rio.DatatypeHandlerRegistry;
import org.openrdf.rio.LanguageHandler;
import org.openrdf.rio.LanguageHandlerRegistry;
import org.openrdf.rio.RioSetting;
import org.openrdf.rio.helpers.LargeLiteralHandling;
import org.openrdf.rio.helpers.RioSettingImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicParserSettings {
    private static final Set<Namespace> defaultPrefix;
    private static final Logger log;
    public static final RioSetting<Boolean> VERIFY_DATATYPE_VALUES;
    public static final RioSetting<Boolean> FAIL_ON_UNKNOWN_DATATYPES;
    public static final RioSetting<Boolean> NORMALIZE_DATATYPE_VALUES;
    public static final RioSetting<List<DatatypeHandler>> DATATYPE_HANDLERS;
    public static final RioSetting<Boolean> FAIL_ON_UNKNOWN_LANGUAGES;
    public static final RioSetting<Boolean> VERIFY_LANGUAGE_TAGS;
    public static final RioSetting<Boolean> NORMALIZE_LANGUAGE_TAGS;
    public static final RioSetting<List<LanguageHandler>> LANGUAGE_HANDLERS;
    public static final RioSetting<Boolean> VERIFY_RELATIVE_URIS;
    public static final RioSetting<Boolean> VERIFY_URI_SYNTAX;
    public static final RioSetting<Boolean> PRESERVE_BNODE_IDS;
    public static final RioSetting<LargeLiteralHandling> LARGE_LITERALS_HANDLING;
    public static final RioSetting<Long> LARGE_LITERALS_LIMIT;
    public static final RioSetting<Set<Namespace>> NAMESPACES;

    private BasicParserSettings() {
    }

    static {
        HashSet<NamespaceImpl> aNamespaces = new HashSet<NamespaceImpl>();
        aNamespaces.add(new NamespaceImpl("grddl", "http://www.w3.org/2003/g/data-view#"));
        aNamespaces.add(new NamespaceImpl("ma", "http://www.w3.org/ns/ma-ont#"));
        aNamespaces.add(new NamespaceImpl("owl", "http://www.w3.org/2002/07/owl#"));
        aNamespaces.add(new NamespaceImpl("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
        aNamespaces.add(new NamespaceImpl("rdfa", "http://www.w3.org/ns/rdfa#"));
        aNamespaces.add(new NamespaceImpl("rdfs", "http://www.w3.org/2000/01/rdf-schema#"));
        aNamespaces.add(new NamespaceImpl("rif", "http://www.w3.org/2007/rif#"));
        aNamespaces.add(new NamespaceImpl("skos", "http://www.w3.org/2004/02/skos/core#"));
        aNamespaces.add(new NamespaceImpl("skosxl", "http://www.w3.org/2008/05/skos-xl#"));
        aNamespaces.add(new NamespaceImpl("wdr", "http://www.w3.org/2007/05/powder#"));
        aNamespaces.add(new NamespaceImpl("void", "http://rdfs.org/ns/void#"));
        aNamespaces.add(new NamespaceImpl("wdrs", "http://www.w3.org/2007/05/powder-s#"));
        aNamespaces.add(new NamespaceImpl("xhv", "http://www.w3.org/1999/xhtml/vocab#"));
        aNamespaces.add(new NamespaceImpl("xml", "http://www.w3.org/XML/1998/namespace"));
        aNamespaces.add(new NamespaceImpl("xsd", "http://www.w3.org/2001/XMLSchema#"));
        defaultPrefix = Collections.unmodifiableSet(aNamespaces);
        log = LoggerFactory.getLogger(BasicParserSettings.class);
        VERIFY_DATATYPE_VALUES = new RioSettingImpl<Boolean>("org.openrdf.rio.verifydatatypevalues", "Verify recognised datatype values", Boolean.FALSE);
        FAIL_ON_UNKNOWN_DATATYPES = new RioSettingImpl<Boolean>("org.openrdf.rio.failonunknowndatatypes", "Fail on unknown datatypes", Boolean.FALSE);
        NORMALIZE_DATATYPE_VALUES = new RioSettingImpl<Boolean>("org.openrdf.rio.normalizedatatypevalues", "Normalize recognised datatype values", Boolean.FALSE);
        FAIL_ON_UNKNOWN_LANGUAGES = new RioSettingImpl<Boolean>("org.openrdf.rio.failonunknownlanguages", "Fail on unknown languages", Boolean.FALSE);
        VERIFY_LANGUAGE_TAGS = new RioSettingImpl<Boolean>("org.openrdf.rio.verifylanguagevalues", "Verify language tags", Boolean.TRUE);
        NORMALIZE_LANGUAGE_TAGS = new RioSettingImpl<Boolean>("org.openrdf.rio.normalizelanguagevalues", "Normalize recognised language tags", Boolean.FALSE);
        VERIFY_RELATIVE_URIS = new RioSettingImpl<Boolean>("org.openrdf.rio.verifyrelativeuris", "Verify relative URIs", Boolean.TRUE);
        VERIFY_URI_SYNTAX = new RioSettingImpl<Boolean>("org.openrdf.rio.verifyurisyntax", "Verify URI syntax", Boolean.TRUE);
        PRESERVE_BNODE_IDS = new RioSettingImpl<Boolean>("org.openrdf.rio.preservebnodeids", "Preserve blank node identifiers", Boolean.FALSE);
        LARGE_LITERALS_HANDLING = new RioSettingImpl<LargeLiteralHandling>("org.openrdf.rio.largeliterals", "Large literals handling", LargeLiteralHandling.PRESERVE);
        LARGE_LITERALS_LIMIT = new RioSettingImpl<Long>("org.openrdf.rio.largeliteralslimit", "Size limit for large literals", 0x100000L);
        NAMESPACES = new RioSettingImpl<Set<Namespace>>("org.openrdf.rio.namespaces", "Collection of default namespaces to use for parsing", defaultPrefix);
        ArrayList<DatatypeHandler> defaultDatatypeHandlers = new ArrayList<DatatypeHandler>(4);
        try {
            DatatypeHandlerRegistry registry = DatatypeHandlerRegistry.getInstance();
            for (String nextHandler : Arrays.asList("org.openrdf.rio.datatypes.xmlschema", "org.openrdf.rio.datatypes.rdf", "org.openrdf.rio.datatypes.dbpedia", "org.openrdf.rio.datatypes.virtuosogeometry", "org.openrdf.rio.datatypes.geosparql")) {
                DatatypeHandler nextdt = (DatatypeHandler)registry.get(nextHandler);
                if (nextdt != null) {
                    defaultDatatypeHandlers.add(nextdt);
                    continue;
                }
                log.warn("Could not find DatatypeHandler : {}", (Object)nextHandler);
            }
        }
        catch (Exception e) {
            log.warn("Found an error loading DatatypeHandler services", (Throwable)e);
        }
        DATATYPE_HANDLERS = new RioSettingImpl("org.openrdf.rio.datatypehandlers", "Datatype Handlers", defaultDatatypeHandlers);
        ArrayList<LanguageHandler> defaultLanguageHandlers = new ArrayList<LanguageHandler>(1);
        try {
            LanguageHandlerRegistry registry = LanguageHandlerRegistry.getInstance();
            for (String nextHandler : Arrays.asList("org.openrdf.rio.languages.RFC3066")) {
                LanguageHandler nextlang = (LanguageHandler)registry.get(nextHandler);
                if (nextlang != null) {
                    defaultLanguageHandlers.add(nextlang);
                    continue;
                }
                log.warn("Could not find LanguageHandler : {}", (Object)nextHandler);
            }
        }
        catch (Exception e) {
            log.warn("Found an error loading LanguageHandler services", (Throwable)e);
        }
        LANGUAGE_HANDLERS = new RioSettingImpl("org.openrdf.rio.languagehandlers", "Language Handlers", defaultLanguageHandlers);
    }
}

