/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.helpers;

import java.lang.ref.WeakReference;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.helpers.RDFHandlerWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeLimitRDFHandler
extends RDFHandlerWrapper {
    private static final Timer timer = new Timer("TimeLimitRDFHandler", true);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InterruptTask interruptTask;
    private volatile boolean isInterrupted = false;
    private final AtomicBoolean ended = new AtomicBoolean(false);

    public TimeLimitRDFHandler(RDFHandler rdfHandler, long timeLimit) {
        super(rdfHandler);
        assert (timeLimit > 0L) : "time limit must be a positive number, is: " + timeLimit;
        this.interruptTask = new InterruptTask(this);
        timer.schedule((TimerTask)this.interruptTask, timeLimit);
    }

    private boolean isEnded() {
        return this.ended.get();
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        this.checkInterrupted();
        super.startRDF();
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        this.checkInterrupted();
        if (this.ended.compareAndSet(false, true)) {
            super.endRDF();
        }
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.checkInterrupted();
        super.handleNamespace(prefix, uri);
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        this.checkInterrupted();
        super.handleStatement(st);
    }

    @Override
    public void handleComment(String comment) throws RDFHandlerException {
        this.checkInterrupted();
        super.handleComment(comment);
    }

    private void checkInterrupted() throws RDFHandlerException {
        if (this.isInterrupted) {
            throw new RDFHandlerException("RDFHandler took too long");
        }
    }

    private void interrupt() {
        this.isInterrupted = true;
        if (!this.isEnded()) {
            try {
                this.endRDF();
            }
            catch (RDFHandlerException e) {
                this.logger.warn("Failed to end RDF", (Throwable)((Object)e));
            }
        }
    }

    private static class InterruptTask
    extends TimerTask {
        private WeakReference<TimeLimitRDFHandler> handlerRef;

        InterruptTask(TimeLimitRDFHandler handler) {
            this.handlerRef = new WeakReference<TimeLimitRDFHandler>(handler);
        }

        @Override
        public void run() {
            TimeLimitRDFHandler handler = (TimeLimitRDFHandler)this.handlerRef.get();
            if (handler != null) {
                handler.interrupt();
            }
        }
    }
}

