/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RioConfig;
import org.openrdf.rio.RioSetting;
import org.openrdf.rio.helpers.BasicParserSettings;
import org.openrdf.rio.helpers.NTriplesParserSettings;
import org.openrdf.rio.helpers.TriXParserSettings;

public class ParserConfig
extends RioConfig
implements Serializable {
    private static final long serialVersionUID = 270L;
    private Set<RioSetting<?>> nonFatalErrors = new HashSet();

    public ParserConfig() {
    }

    @Deprecated
    public ParserConfig(boolean verifyData, boolean stopAtFirstError, boolean preserveBNodeIDs, RDFParser.DatatypeHandling datatypeHandling) {
        this();
        this.set((RioSetting)BasicParserSettings.PRESERVE_BNODE_IDS, (Object)preserveBNodeIDs);
        if (!stopAtFirstError) {
            HashSet nonFatalErrors = new HashSet();
            nonFatalErrors.add(TriXParserSettings.FAIL_ON_TRIX_INVALID_STATEMENT);
            nonFatalErrors.add(TriXParserSettings.FAIL_ON_TRIX_MISSING_DATATYPE);
            nonFatalErrors.add(NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
            if (verifyData) {
                nonFatalErrors.add(BasicParserSettings.VERIFY_RELATIVE_URIS);
                if (datatypeHandling == RDFParser.DatatypeHandling.IGNORE) {
                    nonFatalErrors.add(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES);
                    nonFatalErrors.add(BasicParserSettings.VERIFY_DATATYPE_VALUES);
                    nonFatalErrors.add(BasicParserSettings.NORMALIZE_DATATYPE_VALUES);
                } else if (datatypeHandling == RDFParser.DatatypeHandling.VERIFY) {
                    nonFatalErrors.add(BasicParserSettings.NORMALIZE_DATATYPE_VALUES);
                }
            }
            this.setNonFatalErrors(nonFatalErrors);
        }
    }

    public ParserConfig setNonFatalErrors(Set<RioSetting<?>> nonFatalErrors) {
        this.nonFatalErrors = new HashSet(nonFatalErrors);
        return this;
    }

    public ParserConfig addNonFatalError(RioSetting<?> nextNonFatalError) {
        this.nonFatalErrors.add(nextNonFatalError);
        return this;
    }

    public boolean isNonFatalError(RioSetting<?> errorToCheck) {
        return this.nonFatalErrors.contains(errorToCheck);
    }

    public Set<RioSetting<?>> getNonFatalErrors() {
        return Collections.unmodifiableSet(this.nonFatalErrors);
    }

    @Deprecated
    public boolean verifyData() {
        return this.get(BasicParserSettings.VERIFY_RELATIVE_URIS);
    }

    @Deprecated
    public boolean stopAtFirstError() {
        return this.getNonFatalErrors().isEmpty();
    }

    public boolean isPreserveBNodeIDs() {
        return this.get(BasicParserSettings.PRESERVE_BNODE_IDS);
    }

    @Deprecated
    public RDFParser.DatatypeHandling datatypeHandling() {
        throw new RuntimeException("This method is not supported anymore.");
    }

    @Override
    public ParserConfig useDefaults() {
        super.useDefaults();
        this.nonFatalErrors.clear();
        return this;
    }

    @Override
    public <T> ParserConfig set(RioSetting<T> setting, T value) {
        super.set(setting, value);
        return this;
    }
}

