/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import org.openrdf.model.Model;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.SimpleValueFactory;
import org.openrdf.rio.ParseErrorListener;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.RDFWriterRegistry;
import org.openrdf.rio.UnsupportedRDFormatException;
import org.openrdf.rio.WriterConfig;
import org.openrdf.rio.helpers.ContextStatementCollector;
import org.openrdf.rio.helpers.ParseErrorLogger;

public class Rio {
    public static Optional<RDFFormat> getParserFormatForMIMEType(String mimeType) {
        return RDFFormat.matchMIMEType((String)mimeType, (Iterable)RDFParserRegistry.getInstance().getKeys());
    }

    public static Optional<RDFFormat> getParserFormatForFileName(String fileName) {
        return RDFFormat.matchFileName((String)fileName, (Iterable)RDFParserRegistry.getInstance().getKeys());
    }

    public static Optional<RDFFormat> getWriterFormatForMIMEType(String mimeType) {
        return RDFFormat.matchMIMEType((String)mimeType, (Iterable)RDFWriterRegistry.getInstance().getKeys());
    }

    public static Optional<RDFFormat> getWriterFormatForFileName(String fileName) {
        return RDFFormat.matchFileName((String)fileName, (Iterable)RDFWriterRegistry.getInstance().getKeys());
    }

    public static RDFParser createParser(RDFFormat format) throws UnsupportedRDFormatException {
        RDFParserFactory factory = (RDFParserFactory)RDFParserRegistry.getInstance().get((Object)format).orElseThrow(Rio.unsupportedFormat(format));
        return factory.getParser();
    }

    public static RDFParser createParser(RDFFormat format, ValueFactory valueFactory) throws UnsupportedRDFormatException {
        RDFParser rdfParser = Rio.createParser(format);
        rdfParser.setValueFactory(valueFactory);
        return rdfParser;
    }

    public static RDFWriter createWriter(RDFFormat format, OutputStream out) throws UnsupportedRDFormatException {
        RDFWriterFactory factory = (RDFWriterFactory)RDFWriterRegistry.getInstance().get((Object)format).orElseThrow(Rio.unsupportedFormat(format));
        return factory.getWriter(out);
    }

    public static RDFWriter createWriter(RDFFormat format, Writer writer) throws UnsupportedRDFormatException {
        RDFWriterFactory factory = (RDFWriterFactory)RDFWriterRegistry.getInstance().get((Object)format).orElseThrow(Rio.unsupportedFormat(format));
        return factory.getWriter(writer);
    }

    public static Model parse(InputStream in, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, UnsupportedRDFormatException {
        return Rio.parse(in, baseURI, dataFormat, new ParserConfig(), (ValueFactory)SimpleValueFactory.getInstance(), (ParseErrorListener)new ParseErrorLogger(), contexts);
    }

    public static Model parse(Reader reader, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, UnsupportedRDFormatException {
        return Rio.parse(reader, baseURI, dataFormat, new ParserConfig(), (ValueFactory)SimpleValueFactory.getInstance(), (ParseErrorListener)new ParseErrorLogger(), contexts);
    }

    public static Model parse(InputStream in, String baseURI, RDFFormat dataFormat, ParserConfig settings, ValueFactory valueFactory, ParseErrorListener errors, Resource ... contexts) throws IOException, RDFParseException, UnsupportedRDFormatException {
        LinkedHashModel result = new LinkedHashModel();
        RDFParser parser = Rio.createParser(dataFormat, valueFactory);
        parser.setParserConfig(settings);
        parser.setParseErrorListener(errors);
        parser.setRDFHandler(new ContextStatementCollector((Collection<Statement>)result, valueFactory, contexts));
        parser.parse(in, baseURI);
        return result;
    }

    public static Model parse(Reader reader, String baseURI, RDFFormat dataFormat, ParserConfig settings, ValueFactory valueFactory, ParseErrorListener errors, Resource ... contexts) throws IOException, RDFParseException, UnsupportedRDFormatException {
        LinkedHashModel result = new LinkedHashModel();
        RDFParser parser = Rio.createParser(dataFormat, valueFactory);
        parser.setParserConfig(settings);
        parser.setParseErrorListener(errors);
        parser.setRDFHandler(new ContextStatementCollector((Collection<Statement>)result, valueFactory, contexts));
        parser.parse(reader, baseURI);
        return result;
    }

    public static void write(Iterable<Statement> model, OutputStream output, RDFFormat dataFormat) throws RDFHandlerException {
        Rio.write(model, output, dataFormat, new WriterConfig());
    }

    public static void write(Iterable<Statement> model, Writer output, RDFFormat dataFormat) throws RDFHandlerException {
        Rio.write(model, output, dataFormat, new WriterConfig());
    }

    public static void write(Iterable<Statement> model, OutputStream output, RDFFormat dataFormat, WriterConfig settings) throws RDFHandlerException {
        RDFWriter writer = Rio.createWriter(dataFormat, output);
        writer.setWriterConfig(settings);
        Rio.write(model, (RDFHandler)writer);
    }

    public static void write(Iterable<Statement> model, Writer output, RDFFormat dataFormat, WriterConfig settings) throws RDFHandlerException {
        RDFWriter writer = Rio.createWriter(dataFormat, output);
        writer.setWriterConfig(settings);
        Rio.write(model, (RDFHandler)writer);
    }

    public static void write(Iterable<Statement> model, RDFHandler writer) throws RDFHandlerException {
        writer.startRDF();
        if (model instanceof Model) {
            for (Namespace nextNamespace : ((Model)model).getNamespaces()) {
                writer.handleNamespace(nextNamespace.getPrefix(), nextNamespace.getName());
            }
        }
        for (Statement st : model) {
            writer.handleStatement(st);
        }
        writer.endRDF();
    }

    public static void write(Statement st, OutputStream output, RDFFormat dataFormat) throws RDFHandlerException {
        Rio.write(st, output, dataFormat, new WriterConfig());
    }

    public static void write(Statement st, OutputStream output, RDFFormat dataFormat, WriterConfig settings) throws RDFHandlerException {
        RDFWriter writer = Rio.createWriter(dataFormat, output);
        writer.setWriterConfig(settings);
        Rio.write(st, (RDFHandler)writer);
    }

    public static void write(Statement statement, Writer output, RDFFormat dataFormat) throws RDFHandlerException {
        Rio.write(statement, output, dataFormat, new WriterConfig());
    }

    public static void write(Statement statement, Writer output, RDFFormat dataFormat, WriterConfig settings) throws RDFHandlerException {
        RDFWriter writer = Rio.createWriter(dataFormat, output);
        writer.setWriterConfig(settings);
        Rio.write(statement, (RDFHandler)writer);
    }

    public static void write(Statement statement, RDFHandler writer) throws RDFHandlerException {
        writer.startRDF();
        writer.handleStatement(statement);
        writer.endRDF();
    }

    public static void main(String[] args) throws IOException, RDFParseException, RDFHandlerException, UnsupportedRDFormatException {
        if (args.length < 2) {
            System.out.println("Usage: java org.openrdf.rio.Rio <inputFile> <outputFile>");
            System.exit(1);
            return;
        }
        String inputFile = args[0];
        String outputFile = args[1];
        try (FileOutputStream outStream = new FileOutputStream(outputFile);
             FileInputStream inStream = new FileInputStream(inputFile);){
            Rio.createParser(Rio.getParserFormatForFileName(inputFile).orElse(RDFFormat.RDFXML)).setRDFHandler(Rio.createWriter(Rio.getWriterFormatForFileName(outputFile).orElse(RDFFormat.RDFXML), outStream)).parse(inStream, "file:" + inputFile);
        }
    }

    public static Supplier<UnsupportedRDFormatException> unsupportedFormat(RDFFormat unsupportedFormat) {
        return () -> new UnsupportedRDFormatException("Did not recognise RDF format object " + (Object)((Object)unsupportedFormat));
    }

    public static Supplier<UnsupportedRDFormatException> unsupportedFormat(String unsupportedFormat) {
        return () -> new UnsupportedRDFormatException("Did not recognise RDF format string " + unsupportedFormat);
    }
}

