/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.base;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Model;
import org.openrdf.model.ModelFactory;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.Var;
import org.openrdf.sail.SailConflictException;
import org.openrdf.sail.SailException;
import org.openrdf.sail.base.SailDatasetImpl;
import org.openrdf.sail.base.SailSink;

abstract class Changeset
implements SailSink,
ModelFactory {
    private Set<SailDatasetImpl> refbacks;
    private Set<Changeset> prepend;
    private Set<StatementPattern> observations;
    private Model approved;
    private Model deprecated;
    private Set<Resource> approvedContexts;
    private Set<Resource> deprecatedContexts;
    private Map<String, String> addedNamespaces;
    private Set<String> removedPrefixes;
    private boolean namespaceCleared;
    private boolean statementCleared;

    Changeset() {
    }

    @Override
    public void close() throws SailException {
    }

    @Override
    public void prepare() throws SailException {
        if (this.prepend != null && this.observations != null) {
            for (StatementPattern p : this.observations) {
                Resource subj = (Resource)p.getSubjectVar().getValue();
                URI pred = (URI)p.getPredicateVar().getValue();
                Value obj = p.getObjectVar().getValue();
                Var ctxVar = p.getContextVar();
                Resource[] contexts = ctxVar == null ? new Resource[]{} : new Resource[]{(Resource)ctxVar.getValue()};
                for (Changeset changeset : this.prepend) {
                    Model approved = changeset.getApproved();
                    Model deprecated = changeset.getDeprecated();
                    if ((approved == null || !approved.contains(subj, pred, obj, contexts)) && (deprecated == null || !deprecated.contains(subj, pred, obj, contexts))) continue;
                    throw new SailConflictException("Observed State has Changed");
                }
            }
        }
    }

    public synchronized void addRefback(SailDatasetImpl dataset) {
        if (this.refbacks == null) {
            this.refbacks = new HashSet<SailDatasetImpl>();
        }
        this.refbacks.add(dataset);
    }

    public synchronized void removeRefback(SailDatasetImpl dataset) {
        if (this.refbacks != null) {
            this.refbacks.remove(dataset);
        }
    }

    public synchronized boolean isRefback() {
        return this.refbacks != null && !this.refbacks.isEmpty();
    }

    public synchronized void prepend(Changeset changeset) {
        if (this.prepend == null) {
            this.prepend = new HashSet<Changeset>();
        }
        this.prepend.add(changeset);
    }

    @Override
    public synchronized void setNamespace(String prefix, String name) {
        if (this.removedPrefixes == null) {
            this.removedPrefixes = new HashSet<String>();
        }
        this.removedPrefixes.add(prefix);
        if (this.addedNamespaces == null) {
            this.addedNamespaces = new HashMap<String, String>();
        }
        this.addedNamespaces.put(prefix, name);
    }

    @Override
    public synchronized void removeNamespace(String prefix) {
        if (this.addedNamespaces != null) {
            this.addedNamespaces.remove(prefix);
        }
        if (this.removedPrefixes == null) {
            this.removedPrefixes = new HashSet<String>();
        }
        this.removedPrefixes.add(prefix);
    }

    @Override
    public synchronized void clearNamespaces() {
        if (this.removedPrefixes != null) {
            this.removedPrefixes.clear();
        }
        if (this.addedNamespaces != null) {
            this.addedNamespaces.clear();
        }
        this.namespaceCleared = true;
    }

    @Override
    public synchronized void observe(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailConflictException {
        if (this.observations == null) {
            this.observations = new HashSet<StatementPattern>();
        }
        if (contexts == null) {
            this.observations.add(new StatementPattern(new Var("s", (Value)subj), new Var("p", (Value)pred), new Var("o", obj), new Var("g", null)));
        } else if (contexts.length == 0) {
            this.observations.add(new StatementPattern(new Var("s", (Value)subj), new Var("p", (Value)pred), new Var("o", obj)));
        } else {
            for (Resource ctx : contexts) {
                this.observations.add(new StatementPattern(new Var("s", (Value)subj), new Var("p", (Value)pred), new Var("o", obj), new Var("g", (Value)ctx)));
            }
        }
    }

    @Override
    public synchronized void clear(Resource ... contexts) {
        if (contexts != null && contexts.length == 0) {
            if (this.approved != null) {
                this.approved.remove(null, null, null, new Resource[0]);
            }
            if (this.approvedContexts != null) {
                this.approvedContexts.clear();
            }
            this.statementCleared = true;
        } else {
            if (this.approved != null) {
                this.approved.remove(null, null, null, contexts);
            }
            if (this.approvedContexts != null) {
                this.approvedContexts.removeAll(Arrays.asList(contexts));
            }
            if (this.deprecatedContexts == null) {
                this.deprecatedContexts = new HashSet<Resource>();
            }
            this.deprecatedContexts.addAll(Arrays.asList(contexts));
        }
    }

    @Override
    public synchronized void approve(Resource subj, URI pred, Value obj, Resource ctx) {
        if (this.deprecated != null) {
            this.deprecated.remove(subj, pred, obj, new Resource[]{ctx});
        }
        if (this.approved == null) {
            this.approved = this.createEmptyModel();
        }
        this.approved.add(subj, pred, obj, new Resource[]{ctx});
        if (ctx != null) {
            if (this.approvedContexts == null) {
                this.approvedContexts = new HashSet<Resource>();
            }
            this.approvedContexts.add(ctx);
        }
    }

    @Override
    public synchronized void deprecate(Resource subj, URI pred, Value obj, Resource ctx) {
        if (this.approved != null) {
            this.approved.remove(subj, pred, obj, new Resource[]{ctx});
        }
        if (this.deprecated == null) {
            this.deprecated = this.createEmptyModel();
        }
        this.deprecated.add(subj, pred, obj, new Resource[]{ctx});
        if (this.approvedContexts != null && this.approvedContexts.contains(ctx) && !this.approved.contains(null, null, null, new Resource[]{ctx})) {
            this.approvedContexts.remove(ctx);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.observations != null) {
            sb.append(this.observations.size());
            sb.append(" observations, ");
        }
        if (this.namespaceCleared) {
            sb.append("namespaceCleared, ");
        }
        if (this.removedPrefixes != null) {
            sb.append(this.removedPrefixes.size());
            sb.append(" removedPrefixes, ");
        }
        if (this.addedNamespaces != null) {
            sb.append(this.addedNamespaces.size());
            sb.append(" addedNamespaces, ");
        }
        if (this.statementCleared) {
            sb.append("statementCleared, ");
        }
        if (this.deprecatedContexts != null && !this.deprecatedContexts.isEmpty()) {
            sb.append(this.deprecatedContexts.size());
            sb.append(" deprecatedContexts, ");
        }
        if (this.deprecated != null) {
            sb.append(this.deprecated.size());
            sb.append(" deprecated, ");
        }
        if (this.approved != null) {
            sb.append(this.approved.size());
            sb.append(" approved, ");
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 2);
        }
        return super.toString();
    }

    protected void setChangeset(Changeset from) {
        this.observations = from.observations;
        this.approved = from.approved;
        this.deprecated = from.deprecated;
        this.approvedContexts = from.approvedContexts;
        this.deprecatedContexts = from.deprecatedContexts;
        this.addedNamespaces = from.addedNamespaces;
        this.removedPrefixes = from.removedPrefixes;
        this.namespaceCleared = from.namespaceCleared;
        this.statementCleared = from.statementCleared;
    }

    public synchronized Set<StatementPattern> getObservations() {
        return this.observations;
    }

    public synchronized Model getApproved() {
        return this.approved;
    }

    public synchronized Model getDeprecated() {
        return this.deprecated;
    }

    public synchronized Set<Resource> getApprovedContexts() {
        return this.approvedContexts;
    }

    public synchronized Set<Resource> getDeprecatedContexts() {
        return this.deprecatedContexts;
    }

    public synchronized boolean isStatementCleared() {
        return this.statementCleared;
    }

    public synchronized Map<String, String> getAddedNamespaces() {
        return this.addedNamespaces;
    }

    public synchronized Set<String> getRemovedPrefixes() {
        return this.removedPrefixes;
    }

    public synchronized boolean isNamespaceCleared() {
        return this.namespaceCleared;
    }
}

