/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.base;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.IterationWrapper;
import java.util.NoSuchElementException;
import org.openrdf.sail.SailException;
import org.openrdf.sail.base.SailClosable;

abstract class SailClosingIteration<T, X extends Exception>
extends IterationWrapper<T, X> {
    private final SailClosable[] closes;

    public static <E> SailClosingIteration<E, SailException> makeClosable(CloseableIteration<? extends E, SailException> iter, SailClosable ... closes) {
        return new SailClosingIteration<E, SailException>((CloseableIteration)iter, closes){

            @Override
            protected void handleSailException(SailException e) throws SailException {
                throw e;
            }
        };
    }

    public SailClosingIteration(CloseableIteration<? extends T, X> iter, SailClosable ... closes) {
        super(iter);
        this.closes = closes;
    }

    public synchronized boolean hasNext() throws X {
        if (this.isClosed()) {
            return false;
        }
        if (super.hasNext()) {
            return true;
        }
        this.close();
        return false;
    }

    public synchronized T next() throws X {
        if (this.isClosed()) {
            throw new NoSuchElementException("Iteration has been closed");
        }
        return (T)super.next();
    }

    public synchronized void remove() throws X {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        super.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleClose() throws X {
        try {
            super.handleClose();
        }
        finally {
            SailClosingIteration sailClosingIteration = this;
            synchronized (sailClosingIteration) {
                for (SailClosable closing : this.closes) {
                    try {
                        closing.close();
                    }
                    catch (SailException e) {
                        this.handleSailException(e);
                    }
                }
            }
        }
    }

    protected abstract void handleSailException(SailException var1) throws X;
}

