/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.base;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.ExceptionConvertingIteration;
import info.aduna.iteration.Iteration;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.sail.SailException;
import org.openrdf.sail.base.SailDataset;

class SailDatasetTripleSource
implements TripleSource {
    private final ValueFactory vf;
    private final SailDataset dataset;

    public SailDatasetTripleSource(ValueFactory vf, SailDataset dataset) {
        this.vf = vf;
        this.dataset = dataset;
    }

    public String toString() {
        return this.dataset.toString();
    }

    public CloseableIteration<? extends Statement, QueryEvaluationException> getStatements(Resource subj, URI pred, Value obj, Resource ... contexts) throws QueryEvaluationException {
        try {
            return new Eval((Iteration<? extends Statement, ? extends Exception>)this.dataset.getStatements(subj, pred, obj, contexts));
        }
        catch (SailException e) {
            throw new QueryEvaluationException((Throwable)e);
        }
    }

    public ValueFactory getValueFactory() {
        return this.vf;
    }

    public static class Eval
    extends ExceptionConvertingIteration<Statement, QueryEvaluationException> {
        public Eval(Iteration<? extends Statement, ? extends Exception> iter) {
            super(iter);
        }

        protected QueryEvaluationException convert(Exception e) {
            return new QueryEvaluationException((Throwable)e);
        }
    }
}

