/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.base;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.openrdf.IsolationLevel;
import org.openrdf.IsolationLevels;
import org.openrdf.model.Model;
import org.openrdf.model.ModelFactory;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.TreeModelFactory;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.Var;
import org.openrdf.sail.SailException;
import org.openrdf.sail.base.Changeset;
import org.openrdf.sail.base.DelegatingSailDataset;
import org.openrdf.sail.base.ObservingSailDataset;
import org.openrdf.sail.base.SailDataset;
import org.openrdf.sail.base.SailDatasetImpl;
import org.openrdf.sail.base.SailSink;
import org.openrdf.sail.base.SailSource;

class SailSourceBranch
implements SailSource {
    private final ReentrantLock semaphore = new ReentrantLock();
    private final LinkedList<Changeset> changes = new LinkedList();
    private final Collection<Changeset> pending = new LinkedList<Changeset>();
    private final Collection<SailDataset> observers = new LinkedList<SailDataset>();
    private final SailSource backingSource;
    private final ModelFactory modelFactory;
    private final boolean autoFlush;
    private SailDataset snapshot;
    private SailSink serializable;
    private SailSink prepared;

    public SailSourceBranch(SailSource backingSource) {
        this(backingSource, (ModelFactory)new TreeModelFactory(), false);
    }

    public SailSourceBranch(SailSource backingSource, ModelFactory modelFactory) {
        this(backingSource, modelFactory, false);
    }

    public SailSourceBranch(SailSource backingSource, ModelFactory modelFactory, boolean autoFlush) {
        this.backingSource = backingSource;
        this.modelFactory = modelFactory;
        this.autoFlush = autoFlush;
    }

    @Override
    public void close() throws SailException {
        block11: {
            try {
                this.semaphore.lock();
                if (this.snapshot != null) {
                    try {
                        this.snapshot.close();
                    }
                    finally {
                        this.snapshot = null;
                    }
                }
                if (this.serializable == null) break block11;
                try {
                    this.serializable.close();
                }
                finally {
                    this.serializable = null;
                }
            }
            finally {
                this.semaphore.unlock();
            }
        }
    }

    @Override
    public SailSink sink(IsolationLevel level) throws SailException {
        Changeset changeset = new Changeset(){
            private boolean prepared;

            @Override
            public void prepare() throws SailException {
                if (!this.prepared) {
                    SailSourceBranch.this.preparedChangeset(this);
                    this.prepared = true;
                }
                super.prepare();
            }

            @Override
            public void flush() throws SailException {
                SailSourceBranch.this.merge(this);
            }

            @Override
            public void close() throws SailException {
                try {
                    super.close();
                }
                finally {
                    if (this.prepared) {
                        SailSourceBranch.this.closeChangeset(this);
                        this.prepared = false;
                    }
                    SailSourceBranch.this.autoFlush();
                }
            }

            public Model createEmptyModel() {
                return SailSourceBranch.this.modelFactory.createEmptyModel();
            }
        };
        try {
            this.semaphore.lock();
            this.pending.add(changeset);
        }
        finally {
            this.semaphore.unlock();
        }
        return changeset;
    }

    @Override
    public SailDataset dataset(IsolationLevel level) throws SailException {
        DelegatingSailDataset dataset = new DelegatingSailDataset(this.derivedFromSerializable(level)){

            @Override
            public void close() throws SailException {
                super.close();
                try {
                    SailSourceBranch.this.semaphore.lock();
                    SailSourceBranch.this.observers.remove(this);
                    SailSourceBranch.this.compressChanges();
                    SailSourceBranch.this.autoFlush();
                }
                finally {
                    SailSourceBranch.this.semaphore.unlock();
                }
            }
        };
        try {
            this.semaphore.lock();
            this.observers.add(dataset);
        }
        finally {
            this.semaphore.unlock();
        }
        return dataset;
    }

    @Override
    public SailSource fork() {
        return new SailSourceBranch(this, this.modelFactory);
    }

    @Override
    public void prepare() throws SailException {
        try {
            this.semaphore.lock();
            if (!this.changes.isEmpty()) {
                if (this.prepared == null && this.serializable == null) {
                    this.prepared = this.backingSource.sink((IsolationLevel)IsolationLevels.NONE);
                } else if (this.prepared == null) {
                    this.prepared = this.serializable;
                }
                this.prepare(this.prepared);
                this.prepared.prepare();
            }
        }
        finally {
            this.semaphore.unlock();
        }
    }

    @Override
    public void flush() throws SailException {
        block8: {
            try {
                this.semaphore.lock();
                if (this.changes.isEmpty()) break block8;
                if (this.prepared == null) {
                    this.prepare();
                }
                this.flush(this.prepared);
                this.prepared.flush();
                try {
                    if (this.prepared != this.serializable) {
                        this.prepared.close();
                    }
                }
                finally {
                    this.prepared = null;
                }
            }
            finally {
                this.semaphore.unlock();
            }
        }
    }

    public boolean isChanged() {
        try {
            this.semaphore.lock();
            boolean bl = !this.changes.isEmpty();
            return bl;
        }
        finally {
            this.semaphore.unlock();
        }
    }

    public String toString() {
        return this.backingSource.toString() + "\n" + this.changes.toString();
    }

    void preparedChangeset(Changeset changeset) {
        this.semaphore.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void merge(Changeset change) {
        try {
            this.semaphore.lock();
            this.pending.remove(change);
            if (this.isChanged(change)) {
                this.changes.add(change);
                this.compressChanges();
                Changeset merged = this.changes.getLast();
                for (Changeset c : this.pending) {
                    c.prepend(merged);
                }
            }
        }
        finally {
            this.semaphore.unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void compressChanges() {
        try {
            this.semaphore.lock();
            while (this.changes.size() > 1 && !this.changes.get(this.changes.size() - 2).isRefback()) {
                try {
                    Changeset pop = this.changes.removeLast();
                    this.prepare(pop, this.changes.getLast());
                    this.flush(pop, this.changes.getLast());
                }
                catch (SailException e) {
                    throw new AssertionError((Object)e);
                    return;
                }
            }
        }
        finally {
            this.semaphore.unlock();
        }
    }

    void closeChangeset(Changeset changeset) {
        this.semaphore.unlock();
    }

    void autoFlush() throws SailException {
        if (this.autoFlush && this.semaphore.tryLock()) {
            try {
                if (this.serializable == null && this.observers.isEmpty()) {
                    this.flush();
                }
            }
            finally {
                this.semaphore.unlock();
            }
        }
    }

    private boolean isChanged(Changeset change) {
        return change.getApproved() != null || change.getDeprecated() != null || change.getApprovedContexts() != null || change.getDeprecatedContexts() != null || change.getAddedNamespaces() != null || change.getRemovedPrefixes() != null || change.isStatementCleared() || change.isNamespaceCleared() || change.getObservations() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SailDataset derivedFromSerializable(IsolationLevel level) throws SailException {
        try {
            this.semaphore.lock();
            if (this.serializable == null && level.isCompatibleWith((IsolationLevel)IsolationLevels.SERIALIZABLE)) {
                this.serializable = this.backingSource.sink(level);
            }
            SailDataset derivedFrom = this.derivedFromSnapshot(level);
            if (this.serializable == null) {
                SailDataset sailDataset = derivedFrom;
                return sailDataset;
            }
            ObservingSailDataset observingSailDataset = new ObservingSailDataset(derivedFrom, this.sink(level));
            return observingSailDataset;
        }
        finally {
            this.semaphore.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SailDataset derivedFromSnapshot(IsolationLevel level) throws SailException {
        try {
            SailDataset derivedFrom;
            this.semaphore.lock();
            if (this.snapshot != null) {
                derivedFrom = new DelegatingSailDataset(this.snapshot){

                    @Override
                    public void close() throws SailException {
                    }
                };
            } else {
                derivedFrom = this.backingSource.dataset(level);
                if (level.isCompatibleWith((IsolationLevel)IsolationLevels.SNAPSHOT)) {
                    this.snapshot = derivedFrom;
                    derivedFrom = new DelegatingSailDataset(derivedFrom){

                        @Override
                        public void close() throws SailException {
                        }
                    };
                }
            }
            Iterator iter = this.changes.iterator();
            while (iter.hasNext()) {
                derivedFrom = new SailDatasetImpl(derivedFrom, (Changeset)iter.next());
            }
            SailDataset sailDataset = derivedFrom;
            return sailDataset;
        }
        finally {
            this.semaphore.unlock();
        }
    }

    private void prepare(SailSink sink) throws SailException {
        try {
            this.semaphore.lock();
            Iterator iter = this.changes.iterator();
            while (iter.hasNext()) {
                this.prepare((Changeset)iter.next(), sink);
            }
        }
        finally {
            this.semaphore.unlock();
        }
    }

    private void prepare(Changeset change, SailSink sink) throws SailException {
        Set<StatementPattern> observations = change.getObservations();
        if (observations != null) {
            for (StatementPattern p : observations) {
                Resource subj = (Resource)p.getSubjectVar().getValue();
                URI pred = (URI)p.getPredicateVar().getValue();
                Value obj = p.getObjectVar().getValue();
                Var ctxVar = p.getContextVar();
                if (ctxVar == null) {
                    sink.observe(subj, pred, obj, new Resource[0]);
                    continue;
                }
                sink.observe(subj, pred, obj, (Resource)ctxVar.getValue());
            }
        }
    }

    private void flush(SailSink sink) throws SailException {
        try {
            this.semaphore.lock();
            if (this.changes.size() == 1 && !this.changes.getFirst().isRefback() && sink instanceof Changeset && !this.isChanged((Changeset)sink)) {
                Changeset dst = (Changeset)sink;
                dst.setChangeset(this.changes.pop());
            } else {
                Iterator iter = this.changes.iterator();
                while (iter.hasNext()) {
                    this.flush((Changeset)iter.next(), sink);
                    iter.remove();
                }
            }
        }
        finally {
            this.semaphore.unlock();
        }
    }

    private void flush(Changeset change, SailSink sink) throws SailException {
        Model approved;
        Model model;
        Set<Resource> set;
        Map<String, String> addedNamespaces;
        Set<String> removedPrefixes;
        this.prepare(change, sink);
        if (change.isNamespaceCleared()) {
            sink.clearNamespaces();
        }
        if ((removedPrefixes = change.getRemovedPrefixes()) != null) {
            for (String string : removedPrefixes) {
                sink.removeNamespace(string);
            }
        }
        if ((addedNamespaces = change.getAddedNamespaces()) != null) {
            for (Map.Entry<String, String> entry : addedNamespaces.entrySet()) {
                sink.setNamespace(entry.getKey(), entry.getValue());
            }
        }
        if (change.isStatementCleared()) {
            sink.clear(new Resource[0]);
        }
        if ((set = change.getDeprecatedContexts()) != null && !set.isEmpty()) {
            sink.clear(set.toArray(new Resource[set.size()]));
        }
        if ((model = change.getDeprecated()) != null) {
            for (Statement st : model) {
                sink.deprecate(st.getSubject(), st.getPredicate(), st.getObject(), st.getContext());
            }
        }
        if ((approved = change.getApproved()) != null) {
            for (Statement st : approved) {
                sink.approve(st.getSubject(), st.getPredicate(), st.getObject(), st.getContext());
            }
        }
    }
}

