/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.base;

import info.aduna.iteration.CloseableIteration;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.IsolationLevel;
import org.openrdf.IsolationLevels;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.QueryRoot;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.openrdf.query.algebra.evaluation.federation.FederatedServiceResolverClient;
import org.openrdf.query.algebra.evaluation.impl.BindingAssigner;
import org.openrdf.query.algebra.evaluation.impl.CompareOptimizer;
import org.openrdf.query.algebra.evaluation.impl.ConjunctiveConstraintSplitter;
import org.openrdf.query.algebra.evaluation.impl.ConstantOptimizer;
import org.openrdf.query.algebra.evaluation.impl.DisjunctiveConstraintOptimizer;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStrategyImpl;
import org.openrdf.query.algebra.evaluation.impl.FilterOptimizer;
import org.openrdf.query.algebra.evaluation.impl.IterativeEvaluationOptimizer;
import org.openrdf.query.algebra.evaluation.impl.OrderLimitOptimizer;
import org.openrdf.query.algebra.evaluation.impl.QueryJoinOptimizer;
import org.openrdf.query.algebra.evaluation.impl.QueryModelNormalizer;
import org.openrdf.query.algebra.evaluation.impl.SameTermFilterOptimizer;
import org.openrdf.query.impl.EmptyBindingSet;
import org.openrdf.sail.SailException;
import org.openrdf.sail.UnknownSailTransactionStateException;
import org.openrdf.sail.UpdateContext;
import org.openrdf.sail.base.DelegatingSailSource;
import org.openrdf.sail.base.SailClosable;
import org.openrdf.sail.base.SailClosingIteration;
import org.openrdf.sail.base.SailDataset;
import org.openrdf.sail.base.SailDatasetTripleSource;
import org.openrdf.sail.base.SailSink;
import org.openrdf.sail.base.SailSource;
import org.openrdf.sail.base.SailStore;
import org.openrdf.sail.base.UnionSailSource;
import org.openrdf.sail.helpers.NotifyingSailConnectionBase;
import org.openrdf.sail.helpers.SailBase;
import org.openrdf.sail.inferencer.InferencerConnection;

public abstract class SailSourceConnection
extends NotifyingSailConnectionBase
implements InferencerConnection,
FederatedServiceResolverClient {
    private final Map<UpdateContext, SailDataset> datasets = new HashMap<UpdateContext, SailDataset>();
    private final Map<UpdateContext, SailSink> explicitSinks = new HashMap<UpdateContext, SailSink>();
    private SailDataset explicitOnlyDataset;
    private SailDataset inferredDataset;
    private SailSink inferredSink;
    private final ValueFactory vf;
    private final SailStore store;
    private final IsolationLevel defaultIsolationLevel;
    private SailSource explicitOnlyBranch;
    private SailSource inferredOnlyBranch;
    private SailSource includeInferredBranch;
    private FederatedServiceResolver federatedServiceResolver;

    protected SailSourceConnection(SailBase sail, SailStore store, FederatedServiceResolver resolver) {
        super(sail);
        this.vf = sail.getValueFactory();
        this.store = store;
        this.defaultIsolationLevel = sail.getDefaultIsolationLevel();
        this.federatedServiceResolver = resolver;
    }

    public FederatedServiceResolver getFederatedServiceResolver() {
        return this.federatedServiceResolver;
    }

    public void setFederatedServiceResolver(FederatedServiceResolver resolver) {
        this.federatedServiceResolver = resolver;
    }

    protected EvaluationStrategy getEvaluationStrategy(Dataset dataset, TripleSource tripleSource) {
        return new EvaluationStrategyImpl(tripleSource, dataset, this.getFederatedServiceResolver());
    }

    protected CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateInternal(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        this.flush();
        this.logger.trace("Incoming query model:\n{}", (Object)tupleExpr);
        tupleExpr = tupleExpr.clone();
        if (!(tupleExpr instanceof QueryRoot)) {
            tupleExpr = new QueryRoot(tupleExpr);
        }
        SailSource branch = this.branch(includeInferred);
        SailDataset rdfDataset = branch.dataset(this.getIsolationLevel());
        boolean releaseLock = true;
        try {
            SailDatasetTripleSource tripleSource = new SailDatasetTripleSource(this.vf, rdfDataset);
            EvaluationStrategy strategy = this.getEvaluationStrategy(dataset, tripleSource);
            new BindingAssigner().optimize(tupleExpr, dataset, bindings);
            new ConstantOptimizer(strategy).optimize(tupleExpr, dataset, bindings);
            new CompareOptimizer().optimize(tupleExpr, dataset, bindings);
            new ConjunctiveConstraintSplitter().optimize(tupleExpr, dataset, bindings);
            new DisjunctiveConstraintOptimizer().optimize(tupleExpr, dataset, bindings);
            new SameTermFilterOptimizer().optimize(tupleExpr, dataset, bindings);
            new QueryModelNormalizer().optimize(tupleExpr, dataset, bindings);
            new QueryJoinOptimizer(this.store.getEvaluationStatistics()).optimize(tupleExpr, dataset, bindings);
            new IterativeEvaluationOptimizer().optimize(tupleExpr, dataset, bindings);
            new FilterOptimizer().optimize(tupleExpr, dataset, bindings);
            new OrderLimitOptimizer().optimize(tupleExpr, dataset, bindings);
            this.logger.trace("Optimized query model:\n{}", (Object)tupleExpr);
            CloseableIteration iter = strategy.evaluate(tupleExpr, EmptyBindingSet.getInstance());
            iter = this.interlock(iter, rdfDataset, branch);
            releaseLock = false;
            CloseableIteration closeableIteration = iter;
            return closeableIteration;
        }
        catch (QueryEvaluationException e) {
            throw new SailException((Throwable)e);
        }
        finally {
            if (releaseLock) {
                rdfDataset.close();
                branch.close();
            }
        }
    }

    protected void closeInternal() throws SailException {
    }

    protected CloseableIteration<? extends Resource, SailException> getContextIDsInternal() throws SailException {
        this.flush();
        SailSource branch = this.branch(false);
        SailDataset snapshot = branch.dataset(this.getIsolationLevel());
        return SailClosingIteration.makeClosable(snapshot.getContextIDs(), snapshot, branch);
    }

    protected CloseableIteration<? extends Statement, SailException> getStatementsInternal(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        this.flush();
        SailSource branch = this.branch(includeInferred);
        SailDataset snapshot = branch.dataset(this.getIsolationLevel());
        return SailClosingIteration.makeClosable(snapshot.getStatements(subj, pred, obj, contexts), snapshot, branch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long sizeInternal(Resource ... contexts) throws SailException {
        this.flush();
        CloseableIteration<? extends Statement, SailException> iter = this.getStatementsInternal(null, null, null, false, contexts);
        try {
            long size = 0L;
            while (iter.hasNext()) {
                iter.next();
                ++size;
            }
            long l = size;
            return l;
        }
        finally {
            iter.close();
        }
    }

    protected CloseableIteration<? extends Namespace, SailException> getNamespacesInternal() throws SailException {
        SailSource branch = this.branch(false);
        SailDataset snapshot = branch.dataset(this.getIsolationLevel());
        return SailClosingIteration.makeClosable(snapshot.getNamespaces(), snapshot, branch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getNamespaceInternal(String prefix) throws SailException {
        SailSource branch = this.branch(false);
        SailDataset snapshot = branch.dataset(this.getIsolationLevel());
        try {
            String string = snapshot.getNamespace(prefix);
            return string;
        }
        finally {
            snapshot.close();
            branch.close();
        }
    }

    protected void startTransactionInternal() throws SailException {
        assert (this.explicitOnlyBranch == null);
        assert (this.inferredOnlyBranch == null);
        assert (this.includeInferredBranch == null);
        IsolationLevel level = this.getTransactionIsolation();
        if (!IsolationLevels.NONE.isCompatibleWith(level)) {
            this.explicitOnlyBranch = this.store.getExplicitSailSource().fork();
            this.inferredOnlyBranch = this.store.getInferredSailSource().fork();
            this.includeInferredBranch = new UnionSailSource(this.inferredOnlyBranch, this.explicitOnlyBranch);
        }
    }

    protected void prepareInternal() throws SailException {
        if (this.includeInferredBranch != null) {
            this.includeInferredBranch.prepare();
        }
    }

    protected void commitInternal() throws SailException {
        try {
            if (this.includeInferredBranch != null) {
                this.includeInferredBranch.flush();
            }
        }
        finally {
            if (this.includeInferredBranch != null) {
                this.includeInferredBranch.close();
                this.includeInferredBranch = null;
                this.explicitOnlyBranch = null;
                this.inferredOnlyBranch = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollbackInternal() throws SailException {
        Map<UpdateContext, SailDataset> map = this.datasets;
        synchronized (map) {
            if (this.datasets.containsKey(null)) {
                this.datasets.remove(null).close();
            }
            if (this.explicitSinks.containsKey(null)) {
                this.explicitSinks.remove(null).close();
            }
            if (this.explicitOnlyDataset != null) {
                this.explicitOnlyDataset.close();
                this.explicitOnlyDataset = null;
            }
            if (this.inferredDataset != null) {
                this.inferredDataset.close();
                this.inferredDataset = null;
            }
            if (this.inferredSink != null) {
                this.inferredSink.close();
                this.inferredSink = null;
            }
        }
        if (this.includeInferredBranch != null) {
            this.includeInferredBranch.close();
            this.includeInferredBranch = null;
            this.explicitOnlyBranch = null;
            this.inferredOnlyBranch = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startUpdate(UpdateContext op) throws SailException {
        if (op != null) {
            IsolationLevel level = this.getIsolationLevel();
            this.flush();
            Map<UpdateContext, SailDataset> map = this.datasets;
            synchronized (map) {
                SailSource source;
                assert (!this.datasets.containsKey(op));
                if (op.isIncludeInferred() && this.inferredOnlyBranch == null) {
                    SailSource explicit = this.store.getExplicitSailSource();
                    SailSource inferred = this.store.getInferredSailSource();
                    source = new UnionSailSource(explicit, inferred);
                } else {
                    source = op.isIncludeInferred() ? new UnionSailSource(this.explicitOnlyBranch, this.inferredOnlyBranch) : this.branch(false);
                }
                this.datasets.put(op, source.dataset(level));
                this.explicitSinks.put(op, source.sink(level));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatement(UpdateContext op, Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.verifyIsOpen();
        this.verifyIsActive();
        Map<UpdateContext, SailDataset> map = this.datasets;
        synchronized (map) {
            if (op == null && !this.datasets.containsKey(null)) {
                SailSource source = this.branch(false);
                this.datasets.put(null, source.dataset(this.getIsolationLevel()));
                this.explicitSinks.put(null, source.sink(this.getIsolationLevel()));
            }
            assert (this.explicitSinks.containsKey(op));
            this.add(subj, pred, obj, this.datasets.get(op), this.explicitSinks.get(op), contexts);
        }
        this.addStatementInternal(subj, pred, obj, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatement(UpdateContext op, Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.verifyIsOpen();
        this.verifyIsActive();
        this.flush();
        Map<UpdateContext, SailDataset> map = this.datasets;
        synchronized (map) {
            if (op == null && !this.datasets.containsKey(null)) {
                SailSource source = this.branch(false);
                this.datasets.put(null, source.dataset(this.getIsolationLevel()));
                this.explicitSinks.put(null, source.sink(this.getIsolationLevel()));
            }
            assert (this.explicitSinks.containsKey(op));
            this.remove(subj, pred, obj, this.datasets.get(op), this.explicitSinks.get(op), contexts);
        }
        this.removeStatementsInternal(subj, pred, obj, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endUpdateInternal(UpdateContext op) throws SailException {
        Map<UpdateContext, SailDataset> map = this.datasets;
        synchronized (map) {
            SailSink explicit;
            if (this.inferredSink != null) {
                try {
                    this.inferredSink.flush();
                }
                finally {
                    this.inferredSink.close();
                    this.inferredSink = null;
                }
            }
            if (this.explicitOnlyDataset != null) {
                this.explicitOnlyDataset.close();
                this.explicitOnlyDataset = null;
            }
            if (this.inferredDataset != null) {
                this.inferredDataset.close();
                this.inferredDataset = null;
            }
            if ((explicit = this.explicitSinks.remove(op)) != null) {
                try {
                    explicit.flush();
                }
                finally {
                    explicit.close();
                    this.datasets.remove(op).close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addInferredStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.verifyIsOpen();
        this.verifyIsActive();
        IsolationLevel level = this.getIsolationLevel();
        Map<UpdateContext, SailDataset> map = this.datasets;
        synchronized (map) {
            if (this.inferredSink == null) {
                SailSource branch = this.branch(true);
                this.inferredDataset = branch.dataset(level);
                this.inferredSink = branch.sink(level);
                this.explicitOnlyDataset = this.branch(false).dataset(level);
            }
            this.addStatementInternal(subj, pred, obj, contexts);
            boolean modified = false;
            if (contexts.length == 0) {
                if (!this.hasStatement(this.explicitOnlyDataset, subj, pred, obj, null)) {
                    if (!this.hasStatement(this.inferredDataset, subj, pred, obj, null)) {
                        this.notifyStatementAdded(this.vf.createStatement(subj, pred, obj));
                        modified = true;
                    }
                    this.inferredSink.approve(subj, pred, obj, null);
                }
            } else {
                for (Resource ctx : contexts) {
                    if (this.hasStatement(this.explicitOnlyDataset, subj, pred, obj, ctx)) continue;
                    if (!this.hasStatement(this.inferredDataset, subj, pred, obj, ctx)) {
                        this.notifyStatementAdded(this.vf.createStatement(subj, pred, obj, ctx));
                        modified = true;
                    }
                    this.inferredSink.approve(subj, pred, obj, ctx);
                }
            }
            return modified;
        }
    }

    private boolean add(Resource subj, URI pred, Value obj, SailDataset dataset, SailSink sink, Resource ... contexts) throws SailException {
        boolean modified = false;
        if (contexts.length == 0) {
            if (!this.hasStatement(dataset, subj, pred, obj, null)) {
                this.notifyStatementAdded(this.vf.createStatement(subj, pred, obj));
                modified = true;
            }
            sink.approve(subj, pred, obj, null);
        } else {
            for (Resource ctx : contexts) {
                if (!this.hasStatement(dataset, subj, pred, obj, ctx)) {
                    this.notifyStatementAdded(this.vf.createStatement(subj, pred, obj, ctx));
                    modified = true;
                }
                sink.approve(subj, pred, obj, ctx);
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeInferredStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.verifyIsOpen();
        this.verifyIsActive();
        Map<UpdateContext, SailDataset> map = this.datasets;
        synchronized (map) {
            IsolationLevel level = this.getIsolationLevel();
            if (this.inferredSink == null) {
                SailSource branch = this.branch(true);
                this.inferredDataset = branch.dataset(level);
                this.inferredSink = branch.sink(level);
                this.explicitOnlyDataset = this.branch(false).dataset(level);
            }
            this.removeStatementsInternal(subj, pred, obj, contexts);
            return this.remove(subj, pred, obj, this.inferredDataset, this.inferredSink, contexts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean remove(Resource subj, URI pred, Value obj, SailDataset dataset, SailSink sink, Resource ... contexts) throws SailException {
        boolean statementsRemoved = false;
        CloseableIteration<? extends Statement, SailException> iter = dataset.getStatements(subj, pred, obj, contexts);
        try {
            while (iter.hasNext()) {
                Statement st = (Statement)iter.next();
                sink.deprecate(st.getSubject(), st.getPredicate(), st.getObject(), st.getContext());
                statementsRemoved = true;
                this.notifyStatementRemoved(st);
            }
        }
        finally {
            iter.close();
        }
        return statementsRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearInternal(Resource ... contexts) throws SailException {
        this.verifyIsOpen();
        this.verifyIsActive();
        Map<UpdateContext, SailDataset> map = this.datasets;
        synchronized (map) {
            if (!this.datasets.containsKey(null)) {
                SailSource source = this.branch(false);
                this.datasets.put(null, source.dataset(this.getIsolationLevel()));
                this.explicitSinks.put(null, source.sink(this.getIsolationLevel()));
            }
            assert (this.explicitSinks.containsKey(null));
            if (this.hasConnectionListeners()) {
                this.remove(null, null, null, this.datasets.get(null), this.explicitSinks.get(null), contexts);
            }
            this.explicitSinks.get(null).clear(contexts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInferred(Resource ... contexts) throws SailException {
        this.verifyIsOpen();
        this.verifyIsActive();
        Map<UpdateContext, SailDataset> map = this.datasets;
        synchronized (map) {
            if (this.inferredSink == null) {
                IsolationLevel level = this.getIsolationLevel();
                SailSource branch = this.branch(true);
                this.inferredDataset = branch.dataset(level);
                this.inferredSink = branch.sink(level);
                this.explicitOnlyDataset = this.branch(false).dataset(level);
            }
            if (this.hasConnectionListeners()) {
                this.remove(null, null, null, this.inferredDataset, this.inferredSink, contexts);
            }
            this.inferredSink.clear(contexts);
        }
    }

    public void flushUpdates() throws SailException {
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setNamespaceInternal(String prefix, String name) throws SailException {
        SailSource branch = this.branch(false);
        SailSink sink = branch.sink(this.getTransactionIsolation());
        try {
            sink.setNamespace(prefix, name);
            sink.flush();
        }
        finally {
            sink.close();
            branch.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNamespaceInternal(String prefix) throws SailException {
        SailSource branch = this.branch(false);
        SailSink sink = branch.sink(this.getTransactionIsolation());
        try {
            sink.removeNamespace(prefix);
            sink.flush();
        }
        finally {
            sink.close();
            branch.close();
        }
    }

    protected void clearNamespacesInternal() throws SailException {
        SailSource branch = this.branch(false);
        SailSink sink = branch.sink(this.getTransactionIsolation());
        try {
            sink.clearNamespaces();
            sink.flush();
        }
        finally {
            sink.close();
            branch.close();
        }
    }

    private IsolationLevel getIsolationLevel() throws UnknownSailTransactionStateException {
        if (this.isActive()) {
            return super.getTransactionIsolation();
        }
        return this.defaultIsolationLevel;
    }

    private SailSource branch(boolean includeinferred) throws SailException {
        boolean isolated;
        boolean active = this.isActive();
        IsolationLevel level = this.getIsolationLevel();
        boolean bl = isolated = !IsolationLevels.NONE.isCompatibleWith(level);
        if (includeinferred && active && isolated) {
            return new DelegatingSailSource(this.includeInferredBranch, false);
        }
        if (active && isolated) {
            return new DelegatingSailSource(this.explicitOnlyBranch, false);
        }
        if (includeinferred && active) {
            return new UnionSailSource(this.store.getInferredSailSource(), this.store.getExplicitSailSource());
        }
        if (active) {
            return this.store.getExplicitSailSource();
        }
        if (includeinferred) {
            return new UnionSailSource(this.store.getInferredSailSource().fork(), this.store.getExplicitSailSource().fork());
        }
        return this.store.getExplicitSailSource().fork();
    }

    private <T, X extends Exception> CloseableIteration<T, QueryEvaluationException> interlock(CloseableIteration<T, QueryEvaluationException> iter, SailClosable ... closes) {
        return new SailClosingIteration<T, QueryEvaluationException>(iter, closes){

            @Override
            protected void handleSailException(SailException e) throws QueryEvaluationException {
                throw new QueryEvaluationException((Throwable)e);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasStatement(SailDataset dataset, Resource subj, URI pred, Value obj, Resource ctx) throws SailException {
        CloseableIteration<? extends Statement, SailException> iter = dataset.getStatements(subj, pred, obj, ctx);
        try {
            boolean bl = iter.hasNext();
            return bl;
        }
        finally {
            iter.close();
        }
    }
}

