/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.base;

import org.openrdf.model.ModelFactory;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStatistics;
import org.openrdf.sail.SailException;
import org.openrdf.sail.base.SailSource;
import org.openrdf.sail.base.SailSourceBranch;
import org.openrdf.sail.base.SailStore;

public class SnapshotSailStore
implements SailStore {
    private final SailStore backingStore;
    private final SailSourceBranch explicitAutoFlush;
    private final SailSourceBranch inferredAutoFlush;

    public SnapshotSailStore(SailStore backingStore, ModelFactory modelFactory) {
        this.backingStore = backingStore;
        this.explicitAutoFlush = new SailSourceBranch(backingStore.getExplicitSailSource(), modelFactory, true);
        this.inferredAutoFlush = new SailSourceBranch(backingStore.getInferredSailSource(), modelFactory, true);
    }

    @Override
    public void close() throws SailException {
        try {
            try {
                this.explicitAutoFlush.flush();
                this.inferredAutoFlush.flush();
            }
            finally {
                this.explicitAutoFlush.close();
                this.inferredAutoFlush.close();
            }
        }
        finally {
            this.backingStore.close();
        }
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.backingStore.getValueFactory();
    }

    @Override
    public EvaluationStatistics getEvaluationStatistics() {
        return this.backingStore.getEvaluationStatistics();
    }

    @Override
    public SailSource getExplicitSailSource() {
        return this.explicitAutoFlush;
    }

    @Override
    public SailSource getInferredSailSource() {
        return this.inferredAutoFlush;
    }
}

