/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.base;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.UnionIteration;
import java.util.Arrays;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sail.SailException;
import org.openrdf.sail.base.SailDataset;

class UnionSailDataset
implements SailDataset {
    private final SailDataset[] datasets;

    public UnionSailDataset(SailDataset ... datasets) {
        this.datasets = datasets;
    }

    public String toString() {
        return Arrays.asList(this.datasets).toString();
    }

    @Override
    public void close() throws SailException {
        for (SailDataset dataset : this.datasets) {
            dataset.close();
        }
    }

    @Override
    public CloseableIteration<? extends Namespace, SailException> getNamespaces() throws SailException {
        CloseableIteration[] result = new CloseableIteration[this.datasets.length];
        for (int i = 0; i < this.datasets.length; ++i) {
            result[i] = this.datasets[i].getNamespaces();
        }
        return this.union(result);
    }

    @Override
    public String getNamespace(String prefix) throws SailException {
        for (int i = 0; i < this.datasets.length; ++i) {
            String result = this.datasets[i].getNamespace(prefix);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public CloseableIteration<? extends Resource, SailException> getContextIDs() throws SailException {
        CloseableIteration[] result = new CloseableIteration[this.datasets.length];
        for (int i = 0; i < this.datasets.length; ++i) {
            result[i] = this.datasets[i].getContextIDs();
        }
        return this.union(result);
    }

    @Override
    public CloseableIteration<? extends Statement, SailException> getStatements(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        CloseableIteration[] result = new CloseableIteration[this.datasets.length];
        for (int i = 0; i < this.datasets.length; ++i) {
            result[i] = this.datasets[i].getStatements(subj, pred, obj, contexts);
        }
        return this.union(result);
    }

    private <T> CloseableIteration<? extends T, SailException> union(CloseableIteration<? extends T, SailException>[] items) {
        return new UnionIteration(items);
    }
}

