/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.federation.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.util.ModelException;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryImplConfig;
import org.openrdf.repository.config.RepositoryImplConfigBase;
import org.openrdf.sail.config.SailConfigException;
import org.openrdf.sail.config.SailImplConfigBase;

public class FederationConfig
extends SailImplConfigBase {
    public static final String NAMESPACE = "http://www.openrdf.org/config/sail/federation#";
    public static final URI MEMBER = new URIImpl("http://www.openrdf.org/config/sail/federation#member");
    public static final URI LOCALPROPERTYSPACE = new URIImpl("http://www.openrdf.org/config/sail/federation#localPropertySpace");
    public static final URI DISTINCT = new URIImpl("http://www.openrdf.org/config/sail/federation#distinct");
    public static final URI READ_ONLY = new URIImpl("http://www.openrdf.org/config/sail/federation#readOnly");
    private List<RepositoryImplConfig> members = new ArrayList<RepositoryImplConfig>();
    private final Set<String> localPropertySpace = new HashSet<String>();
    private boolean distinct;
    private boolean readOnly;

    public List<RepositoryImplConfig> getMembers() {
        return this.members;
    }

    public void setMembers(List<RepositoryImplConfig> members) {
        this.members = members;
    }

    public void addMember(RepositoryImplConfig member) {
        this.members.add(member);
    }

    public Set<String> getLocalPropertySpace() {
        return this.localPropertySpace;
    }

    public void addLocalPropertySpace(String localPropertySpace) {
        this.localPropertySpace.add(localPropertySpace);
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean disjoint) {
        this.distinct = disjoint;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Resource export(Graph model) {
        ValueFactoryImpl valueFactory = ValueFactoryImpl.getInstance();
        Resource self = super.export(model);
        for (RepositoryImplConfig member : this.getMembers()) {
            model.add(self, MEMBER, (Value)member.export(model), new Resource[0]);
        }
        for (String space : this.getLocalPropertySpace()) {
            model.add(self, LOCALPROPERTYSPACE, (Value)valueFactory.createURI(space), new Resource[0]);
        }
        model.add(self, DISTINCT, (Value)valueFactory.createLiteral(this.distinct), new Resource[0]);
        model.add(self, READ_ONLY, (Value)valueFactory.createLiteral(this.readOnly), new Resource[0]);
        return self;
    }

    public void parse(Graph graph, Resource implNode) throws SailConfigException {
        super.parse(graph, implNode);
        LinkedHashModel model = new LinkedHashModel((Collection)graph);
        for (Value member : model.filter(implNode, MEMBER, null, new Resource[0]).objects()) {
            try {
                this.addMember(RepositoryImplConfigBase.create((Graph)graph, (Resource)((Resource)member)));
            }
            catch (RepositoryConfigException e) {
                throw new SailConfigException((Throwable)e);
            }
        }
        for (Value space : model.filter(implNode, LOCALPROPERTYSPACE, null, new Resource[0]).objects()) {
            this.addLocalPropertySpace(space.stringValue());
        }
        try {
            Literal bool = model.filter(implNode, DISTINCT, null, new Resource[0]).objectLiteral();
            if (bool != null && bool.booleanValue()) {
                this.distinct = true;
            }
            if ((bool = model.filter(implNode, READ_ONLY, null, new Resource[0]).objectLiteral()) != null && bool.booleanValue()) {
                this.readOnly = true;
            }
        }
        catch (ModelException e) {
            throw new SailConfigException((Throwable)e);
        }
    }

    public void validate() throws SailConfigException {
        super.validate();
        if (this.members.isEmpty()) {
            throw new SailConfigException("No federation members specified");
        }
        for (RepositoryImplConfig member : this.members) {
            try {
                member.validate();
            }
            catch (RepositoryConfigException e) {
                throw new SailConfigException((Throwable)e);
            }
        }
    }
}

