/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf;

import info.aduna.io.IOUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openrdf.model.Namespace;
import org.openrdf.model.impl.NamespaceImpl;

class NamespaceStore
implements Iterable<NamespaceImpl> {
    private static final String FILE_NAME = "namespaces.dat";
    private static final byte[] MAGIC_NUMBER = new byte[]{110, 110, 102};
    private static final byte FILE_FORMAT_VERSION = 1;
    private final File file;
    private final Map<String, NamespaceImpl> namespacesMap;
    private volatile boolean contentsChanged;

    public NamespaceStore(File dataDir) throws IOException {
        this.file = new File(dataDir, FILE_NAME);
        this.namespacesMap = new LinkedHashMap<String, NamespaceImpl>(16);
        if (this.file.exists()) {
            this.readNamespacesFromFile();
        } else {
            this.writeNamespacesToFile();
        }
        this.contentsChanged = false;
    }

    public String getNamespace(String prefix) {
        String result = null;
        NamespaceImpl namespace = this.namespacesMap.get(prefix);
        if (namespace != null) {
            result = namespace.getName();
        }
        return result;
    }

    public void setNamespace(String prefix, String name) {
        NamespaceImpl ns = this.namespacesMap.get(prefix);
        if (ns != null) {
            if (!ns.getName().equals(name)) {
                ns.setName(name);
                this.contentsChanged = true;
            }
        } else {
            this.namespacesMap.put(prefix, new NamespaceImpl(prefix, name));
            this.contentsChanged = true;
        }
    }

    public void removeNamespace(String prefix) {
        NamespaceImpl ns = this.namespacesMap.remove(prefix);
        if (ns != null) {
            this.contentsChanged = true;
        }
    }

    @Override
    public Iterator<NamespaceImpl> iterator() {
        return this.namespacesMap.values().iterator();
    }

    public void clear() {
        if (!this.namespacesMap.isEmpty()) {
            this.namespacesMap.clear();
            this.contentsChanged = true;
        }
    }

    public void sync() throws IOException {
        if (this.contentsChanged) {
            this.writeNamespacesToFile();
            this.contentsChanged = false;
        }
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNamespacesToFile() throws IOException {
        File file = this.file;
        synchronized (file) {
            DataOutputStream out = new DataOutputStream(new FileOutputStream(this.file));
            try {
                out.write(MAGIC_NUMBER);
                out.writeByte(1);
                for (Namespace namespace : this.namespacesMap.values()) {
                    out.writeUTF(namespace.getName());
                    out.writeUTF(namespace.getPrefix());
                }
            }
            finally {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readNamespacesFromFile() throws IOException {
        File file = this.file;
        synchronized (file) {
            DataInputStream in = new DataInputStream(new FileInputStream(this.file));
            try {
                byte[] magicNumber = IOUtil.readBytes((InputStream)in, (int)MAGIC_NUMBER.length);
                if (!Arrays.equals(magicNumber, MAGIC_NUMBER)) {
                    throw new IOException("File doesn't contain compatible namespace data");
                }
                byte version = in.readByte();
                if (version > 1) {
                    throw new IOException("Unable to read namespace file; it uses a newer file format");
                }
                if (version != 1) {
                    throw new IOException("Unable to read namespace file; invalid file format version: " + version);
                }
                try {
                    while (true) {
                        String name = in.readUTF();
                        String prefix = in.readUTF();
                        NamespaceImpl ns = new NamespaceImpl(prefix, name);
                        this.namespacesMap.put(prefix, ns);
                    }
                }
                catch (EOFException e) {
                    in.close();
                }
            }
            catch (Throwable throwable) {
                in.close();
                throw throwable;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        NamespaceStore nsStore = new NamespaceStore(new File(args[0]));
        for (Namespace ns : nsStore) {
            System.out.println(ns.getPrefix() + " = " + ns.getName());
        }
    }
}

