/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.iteration;

import info.aduna.iteration.AbstractCloseableIteration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CloseableIteratorIteration<E, X extends Exception>
extends AbstractCloseableIteration<E, X> {
    private Iterator<? extends E> iter;

    public CloseableIteratorIteration() {
    }

    public CloseableIteratorIteration(Iterator<? extends E> iter) {
        this.setIterator(iter);
    }

    protected void setIterator(Iterator<? extends E> iter) {
        this.iter = iter;
    }

    @Override
    public boolean hasNext() throws X {
        return !this.isClosed() && this.iter.hasNext();
    }

    @Override
    public E next() throws X {
        if (this.isClosed()) {
            throw new NoSuchElementException("Iteration has been closed");
        }
        return this.iter.next();
    }

    @Override
    public void remove() throws X {
        if (this.isClosed()) {
            throw new IllegalStateException("Iteration has been closed");
        }
        this.iter.remove();
    }
}

