/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.iterator;

import info.aduna.iterator.AbstractCloseableIterator;
import java.io.IOException;
import java.util.NoSuchElementException;

public abstract class LookAheadIterator<E>
extends AbstractCloseableIterator<E> {
    private E nextElement;
    private IOException closeException;

    protected abstract E getNextElement();

    @Override
    public final boolean hasNext() {
        this.lookAhead();
        return this.nextElement != null;
    }

    @Override
    public final E next() {
        this.lookAhead();
        E result = this.nextElement;
        if (result != null) {
            this.nextElement = null;
            return result;
        }
        throw new NoSuchElementException();
    }

    private void lookAhead() {
        if (this.nextElement == null && !this.isClosed()) {
            this.nextElement = this.getNextElement();
            if (this.nextElement == null) {
                try {
                    this.close();
                }
                catch (IOException ioe) {
                    this.closeException = ioe;
                }
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void handleClose() throws IOException {
        super.handleClose();
        this.nextElement = null;
    }

    @Override
    protected void handleAlreadyClosed() throws IOException {
        if (this.closeException != null) {
            throw this.closeException;
        }
    }
}

