/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.iteration;

import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.Consumer;

public class IterationSpliterator<T>
extends Spliterators.AbstractSpliterator<T> {
    private final Iteration<T, ? extends Exception> iteration;

    public IterationSpliterator(Iteration<T, ? extends Exception> iteration) {
        super(Long.MAX_VALUE, 1280);
        this.iteration = iteration;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action may not be null");
        try {
            if (this.iteration.hasNext()) {
                action.accept(this.iteration.next());
                return true;
            }
            Iterations.closeCloseable(this.iteration);
            return false;
        }
        catch (Exception e) {
            try {
                Iterations.closeCloseable(this.iteration);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action may not be null");
        try {
            while (this.iteration.hasNext()) {
                action.accept(this.iteration.next());
            }
            Iterations.closeCloseable(this.iteration);
        }
        catch (Exception e) {
            try {
                Iterations.closeCloseable(this.iteration);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }
}

