/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.iteration;

import info.aduna.iteration.AbstractCloseableIteration;
import java.util.NoSuchElementException;

public abstract class LookAheadIteration<E, X extends Exception>
extends AbstractCloseableIteration<E, X> {
    private E nextElement;

    protected abstract E getNextElement() throws X;

    @Override
    public final boolean hasNext() throws X {
        this.lookAhead();
        return this.nextElement != null;
    }

    @Override
    public final E next() throws X {
        this.lookAhead();
        E result = this.nextElement;
        if (result != null) {
            this.nextElement = null;
            return result;
        }
        throw new NoSuchElementException();
    }

    private void lookAhead() throws X {
        if (this.nextElement == null && !this.isClosed()) {
            this.nextElement = this.getNextElement();
            if (this.nextElement == null) {
                this.close();
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void handleClose() throws X {
        super.handleClose();
        this.nextElement = null;
    }
}

