/*
 * Decompiled with CFR 0.152.
 */
package com.colloquial.arithcode;

import com.colloquial.arithcode.ArithCodeModel;
import com.colloquial.arithcode.ArithDecoder;
import com.colloquial.arithcode.BitInput;
import com.colloquial.arithcode.Converter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ArithCodeInputStream
extends InputStream {
    private final ArithCodeModel _model;
    private final ArithDecoder _decoder;
    private int _nextByte;
    private final int[] _interval = new int[3];

    public ArithCodeInputStream(ArithDecoder decoder, ArithCodeModel model) throws IOException {
        this._decoder = decoder;
        this._model = model;
        this.decodeNextByte();
    }

    public ArithCodeInputStream(BitInput in, ArithCodeModel model) throws IOException {
        this(new ArithDecoder(in), model);
    }

    public ArithCodeInputStream(BufferedInputStream in, ArithCodeModel model) throws IOException {
        this(new BitInput(in), model);
    }

    public ArithCodeInputStream(InputStream in, ArithCodeModel model) throws IOException {
        this(new BufferedInputStream(in), model);
    }

    @Override
    public int available() {
        return this._nextByte >= 0 ? 1 : 0;
    }

    @Override
    public void close() throws IOException {
        this._decoder.close();
    }

    @Override
    public void mark(int readLimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read(byte[] bs) throws IOException {
        return this.read(bs, 0, bs.length);
    }

    @Override
    public int read(byte[] bs, int off, int len) throws IOException {
        for (int i = off; i < len; ++i) {
            int nextByte = this.read();
            if (nextByte == -1) {
                return i - off;
            }
            bs[i] = Converter.integerToByte(nextByte);
        }
        return len > 0 ? len : 0;
    }

    @Override
    public int read() throws IOException {
        int result = this._nextByte;
        this.decodeNextByte();
        return result;
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset not supported in AdaptiveUnigramInputStream");
    }

    @Override
    public long skip(long n) throws IOException {
        for (long i = 0L; i < n; ++i) {
            if (this.read() != -1) continue;
            return i;
        }
        return n;
    }

    private void decodeNextByte() throws IOException {
        if (this._nextByte == -1) {
            return;
        }
        if (this._decoder.endOfStream()) {
            this._nextByte = -1;
            return;
        }
        do {
            this._nextByte = this._model.pointToSymbol(this._decoder.getCurrentSymbolCount(this._model.totalCount()));
            this._model.interval(this._nextByte, this._interval);
            this._decoder.removeSymbolFromStream(this._interval);
        } while (this._nextByte == -2);
    }
}

