/*
 * Decompiled with CFR 0.152.
 */
package com.colloquial.arithcode;

import com.colloquial.arithcode.ArithCodeModel;
import com.colloquial.arithcode.ArithEncoder;
import com.colloquial.arithcode.BitOutput;
import com.colloquial.arithcode.Converter;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ArithCodeOutputStream
extends OutputStream {
    private final ArithCodeModel _model;
    private final ArithEncoder _encoder;
    private final int[] _interval = new int[3];

    public ArithCodeOutputStream(ArithEncoder encoder, ArithCodeModel model) {
        this._encoder = encoder;
        this._model = model;
    }

    public ArithCodeOutputStream(BitOutput bitOut, ArithCodeModel model) {
        this(new ArithEncoder(bitOut), model);
    }

    public ArithCodeOutputStream(BufferedOutputStream out, ArithCodeModel model) {
        this(new ArithEncoder(out), model);
    }

    public ArithCodeOutputStream(OutputStream out, ArithCodeModel model) {
        this(new BufferedOutputStream(out), model);
    }

    @Override
    public void close() throws IOException {
        this.encode(-1);
        this._encoder.close();
    }

    @Override
    public void flush() throws IOException {
        this._encoder.flush();
    }

    @Override
    public void write(byte[] bs) throws IOException {
        this.write(bs, 0, bs.length);
    }

    @Override
    public void write(byte[] bs, int off, int len) throws IOException {
        while (off < len) {
            this.write(Converter.byteToInteger(bs[off++]));
        }
    }

    @Override
    public void write(int i) throws IOException {
        this.encode(i);
    }

    private void encode(int symbol) throws IOException {
        while (this._model.escaped(symbol)) {
            this._model.interval(-2, this._interval);
            this._encoder.encode(this._interval);
        }
        this._model.interval(symbol, this._interval);
        this._encoder.encode(this._interval);
    }
}

