/*
 * Decompiled with CFR 0.152.
 */
package com.colloquial.arithcode;

public final class ByteBuffer {
    final byte[] _bytes;
    private final int _maxWidth;
    int _offset = 0;
    int _length = 0;
    private static final int BUFFER_SIZE_MULTIPLIER = 32;

    public ByteBuffer(int maxWidth) {
        this._maxWidth = maxWidth;
        this._bytes = new byte[32 * maxWidth];
    }

    public byte[] bytes() {
        return this._bytes;
    }

    public int offset() {
        return this._offset;
    }

    public int length() {
        return this._length;
    }

    public void buffer(byte b) {
        if (this.nextFreeIndex() > this.maxIndex()) {
            this.tampDown();
        }
        this._bytes[this.nextFreeIndex()] = b;
        if (this._length < this._maxWidth) {
            ++this._length;
        } else {
            ++this._offset;
        }
    }

    public String toString() {
        return new String(this._bytes, this._offset, this._length);
    }

    private int nextFreeIndex() {
        return this._offset + this._length;
    }

    private int maxIndex() {
        return this._bytes.length - 1;
    }

    private void tampDown() {
        for (int i = 0; i < this._length - 1; ++i) {
            this._bytes[i] = this._bytes[this._offset + i + 1];
        }
        this._offset = 0;
    }
}

