/*
 * Decompiled with CFR 0.152.
 */
package com.colloquial.arithcode;

import com.colloquial.arithcode.ArithCodeModel;
import com.colloquial.arithcode.ByteBuffer;
import com.colloquial.arithcode.ByteSet;
import com.colloquial.arithcode.Converter;
import com.colloquial.arithcode.ExcludingAdaptiveUnigramModel;
import com.colloquial.arithcode.PPMNode;

public final class PPMModel
implements ArithCodeModel {
    private final ExcludingAdaptiveUnigramModel _backoffModel = new ExcludingAdaptiveUnigramModel();
    private final PPMNode[] _contexts = new PPMNode[256];
    private final int _maxContextLength;
    private final PPMNode _rootNode = new PPMNode(46);
    private int _contextLength;
    private PPMNode _contextNode;
    private final ByteBuffer _buffer;
    private final ByteSet _excludedBytes = new ByteSet();
    private static final int MIN_CONTEXT_LENGTH = 1;

    public PPMModel(int maxContextLength) {
        this._maxContextLength = maxContextLength;
        this._buffer = new ByteBuffer(maxContextLength + 1);
    }

    @Override
    public boolean escaped(int symbol) {
        return this._contextNode != null && (symbol == -1 || !this._contextNode.hasDaughter(symbol));
    }

    @Override
    public void exclude(int i) {
        this._excludedBytes.add(i);
    }

    @Override
    public void interval(int symbol, int[] result) {
        if (symbol == -1) {
            this._backoffModel.interval(-1, result, this._excludedBytes);
        } else if (symbol == -2) {
            this.intervalEscape(result);
        } else {
            this.intervalByte(symbol, result);
        }
    }

    @Override
    public int pointToSymbol(int count) {
        if (this._contextNode != null) {
            return this._contextNode.pointToSymbol(count, this._excludedBytes);
        }
        return this._backoffModel.pointToSymbol(count, this._excludedBytes);
    }

    @Override
    public int totalCount() {
        if (this._contextNode == null) {
            return this._backoffModel.totalCount(this._excludedBytes);
        }
        return this._contextNode.totalCount(this._excludedBytes);
    }

    @Override
    public void increment(int i) {
        this.increment(Converter.integerToByte(i));
    }

    public void exclude(ByteSet bytesToExclude) {
        this._excludedBytes.add(bytesToExclude);
    }

    private void intervalByte(int i, int[] result) {
        if (this._contextNode != null) {
            this._contextNode.interval(i, this._excludedBytes, result);
        } else {
            this._backoffModel.interval(i, result, this._excludedBytes);
        }
        this.increment(i);
    }

    private void intervalEscape(int[] result) {
        this._contextNode.intervalEscape(this._excludedBytes, result);
        if (this._contextLength >= 1) {
            PPMNode child = this._contextNode._firstChild;
            while (child != null) {
                this._excludedBytes.add(child._byte);
                child = child._nextSibling;
            }
        }
        --this._contextLength;
        this.getContextNodeLongToShort();
    }

    private void increment(byte b) {
        this._buffer.buffer(b);
        byte firstByte = this._buffer.bytes()[this._buffer.offset()];
        if (this._contexts[Converter.byteToInteger(firstByte)] == null) {
            this._contexts[Converter.byteToInteger((byte)firstByte)] = new PPMNode(firstByte);
        }
        if (this._buffer.length() > 1) {
            this._contexts[Converter.byteToInteger(firstByte)].increment(this._buffer.bytes(), this._buffer.offset() + 1, this._buffer.length() - 1);
        }
        this._contextLength = Math.min(this._maxContextLength, this._buffer.length());
        this.getContextNodeBinarySearch();
        this._excludedBytes.clear();
    }

    private void getContextNodeBinarySearch() {
        int low = 1;
        int high = this._contextLength;
        this._contextLength = 0;
        this._contextNode = null;
        boolean isDeterministic = false;
        while (high >= low) {
            int contextLength = (high + low) / 2;
            PPMNode contextNode = this.lookupNode(contextLength);
            if (contextNode == null || contextNode.isChildless(this._excludedBytes)) {
                if (contextLength < high) {
                    high = contextLength;
                    continue;
                }
                --high;
                continue;
            }
            if (contextNode.isDeterministic(this._excludedBytes)) {
                this._contextLength = contextLength;
                this._contextNode = contextNode;
                isDeterministic = true;
                if (contextLength < high) {
                    high = contextLength;
                    continue;
                }
                --high;
                continue;
            }
            if (!isDeterministic) {
                this._contextLength = contextLength;
                this._contextNode = contextNode;
                if (contextLength > low) {
                    low = contextLength;
                    continue;
                }
                ++low;
                continue;
            }
            if (contextLength > low) {
                low = contextLength;
                continue;
            }
            ++low;
        }
    }

    private void getContextNodeLongToShort() {
        while (this._contextLength >= 1) {
            this._contextNode = this.lookupNode(this._contextLength);
            if (this._contextNode == null || this._contextNode.isChildless(this._excludedBytes)) {
                --this._contextLength;
                continue;
            }
            while (this._contextLength > 1 && this._contextNode.isDeterministic(this._excludedBytes)) {
                PPMNode backoffNode = this.lookupNode(this._contextLength - 1);
                if (backoffNode == null || !backoffNode.isDeterministic(this._excludedBytes)) {
                    return;
                }
                this._contextNode = backoffNode;
                --this._contextLength;
            }
            return;
        }
        this._contextNode = null;
    }

    private PPMNode lookupNode(int contextLength) {
        PPMNode node = this._contexts[Converter.byteToInteger(this._buffer.bytes()[this._buffer.offset() + this._buffer.length() - contextLength])];
        if (node == null) {
            return null;
        }
        return PPMModel.lookup(node, this._buffer.bytes(), this._buffer.offset() + this._buffer.length() - contextLength + 1, contextLength - 1);
    }

    private static PPMNode lookup(PPMNode node, byte[] bytes, int offset, int length) {
        if (length == 0) {
            return node;
        }
        PPMNode child = node._firstChild;
        while (length > 0 && child != null) {
            if (bytes[offset] == child._byte) {
                if (length == 1) {
                    return child;
                }
                node = child;
                child = child._firstChild;
                ++offset;
                --length;
                continue;
            }
            child = child._nextSibling;
        }
        return null;
    }
}

